## MobileAppsVerificationJob

### Продукт/подсистема

Реклама мобильных приложений.


### Роль в работе продукта/подсистемы

Подтверждает владение пользователя приложением в Директе.
Владение подтверждается в контексте какого либо трекера (MMP). Для этого ваделец приложения внедряет sdk трекера в приложение, с определёнными трекером ключами, тем самым подтверждая факт доступа к коду приложения и размещения в сторе.
Далее, владелец указывает в трекере идентификатор приложения AppId из аккаунта Директа, трекер посылает постбэки в Яндекс, Директ может проверить наличие правильного AppId в постбэках (через БК). Этим подтверждается доступ рекламодателя Директа к аккаунт в трекере, и далее по цепочке доступ к коду и аккаунту в сторе.
Если всё эта цепочка проходит, мы считаем что приложение верифицировано и рекламодатель -- представитель владельца приложения.


### Датафлоу

- Джоба достаёт из базы пачку мобильных приложений из [mobile_apps](https://direct-dev.yandex-team.ru/db/ppc/tables/mobile_apps.html).
- Собирает верифицированные приложения в динамической таблице в YT `//home/yabs/stat/DirectMobileAppStat`.
- Проверяет доступ клиентов к приложениям через API AppMetrica.
- Обновляет в базе флаг `has_identified_postbacks` у всех верифицированных приложений.
- Повторяет для следующей пачки.


### Способы наблюдения за текущим состоянием

- [Juggler-проверка](https://juggler.yandex-team.ru/check_details/?host=checks_auto.direct.yandex.ru&service=jobs.MobileAppsVerificationJob.working.production&last=1DAY&query=)
- [Логи](https://direct.yandex.ru/logviewer#~(logType~'messages~form~(fields~(~'log_time~'host~'service~'method~'trace_id~'span_id~'prefix~'log_level~'class_name~'message)~conditions~(service~'direct.jobs~method~'mobileappsverification.MobileAppsVerificationJob)~limit~100~offset~0~reverseOrder~true~showTraceIdRelated~false))$)


### Какая функциональность пострадает от отказа джобы

Пострадает верификация приложений, от которой зависит выдача слотов для SkAdNetwork.


### Как пользователи (или команда) заметят проблему и через какое время

Пользователи увидят, что их приложение не верифицировано при создании РМП кампании.


### Контакты разработчиков и менеджеров

Разработчики: [Егор Иватько](https://staff.yandex-team.ru/ivatkoegor), [Захар Зибаров](https://staff.yandex-team.ru/zakhar) <br/>
Менеджеры: [Роман Кухта](https://staff.yandex-team.ru/kuhtich)


### Желательное время исправления в случае поломки

День.


### Способы регулирования работы джобы

Количество запросов от Директа в AppMetrica в секунду ограничено квотой, в случае превышения квоты в логах появятся запросы со статусом 429 - Quota exceeded for service with tvm, для регулировки количества запросов в AppMetrica используются следующие проперти: 
- app_metrica_request_limit - максимальное число запросов, которые можно выполнить, не опасаясь превышения лимита в AppMetrica, default 120
- app_metrica_request_idle_time - время бездействия в миллисекундах после выполнения app_metrica_request_limit запросов

### Известные причины поломок



### Дополнительно: тонкости и подводные камни
