## ResetCpmPriceCampaignFlightStatusApproveJob

### Продукт/подсистема

"Кампании с фиксированным CPM" ("прайсовая кампания") (`campaigns.type = 'cpm_price'`).


### Роль в работе продукта/подсистемы

В прайсовых кампаниях мы с клиентом заранее заключаем двустороннюю договоренность о периоде работы кампании и объеме трафика: с одной стороны мы бронируем для кампании часть трафика, а с другой - клиент обязуется этот трафик исчерпать (для этого он должен к моменту старта кампании создать в ней баннеры требуемых форматов и пройти модерацию). Данная джоба отменяет бронь, если в день старта в 4:00 клиент не сделал кампанию пригодной для запуска и отправляет об этом письмо менеджеру (или на общую рассылку).


### Датафлоу

Читаем и пишем только из/в MySQL.


### Способы наблюдения за текущим состоянием

- [Juggler-проверка](https://juggler.yandex-team.ru/check_details/?host=checks_auto.direct.yandex.ru&service=jobs.ResetCpmPriceCampaignFlightStatusApproveJob.working.production&query=&last=1DAY)


### Какая функциональность пострадает от отказа джобы

- Из за отказа джобы можем начать крутить кампании позже и это может вызвать недокруты как у этой кампании, так и у других кампаний, с которыми она будет конкурировать за трафик.
- Менеджеры не узнают вовремя о том что забронированный трафик не используется, мы на этом можем недополучать деньги.
- Менеджеры не узнают вовремя о нарушениях клиентами договоренностей.


### Как пользователи (или команда) заметят проблему и через какое время?

- У клиентов могут появиться недокрутки прайсовых кампаний.


### Контакты разработчиков и менеджеров

Разработчики: [Олег Важнев](https://staff.yandex-team.ru/ovazhnev), [Андрей Павленко](https://staff.yandex-team.ru/andreypav) <br/>
Менеджеры: [Алексей Александров](https://staff.yandex-team.ru/hrustyashko)


### Желательное время исправления в случае поломки

В течении нескольких дней.


### Способы регулирования работы джобы

Настройки в секции `cpm_price_campaign_mails` в [app-production.conf](https://a.yandex-team.ru/arc/trunk/arcadia/direct/jobs/src/main/resources/app-production.conf) приложения Jobs.


### Известные причины поломок




### Дополнительно: тонкости и подводные камни

Если джоба не отработала например 2021-04-01, можно поискать есть ли проблемные кампании таким запросом `dbs-sql pr:ppc:all "select campaigns.cid from campaigns join campaigns_cpm_price on campaigns.cid=campaigns_cpm_price.cid where start_time = '2021-04-01' and type = 'cpm_price' and status_approve = 'Yes' and status_correct = 'No' \G"` (не будет лишним проверить по бинлогам, что status_approve действительно не был сброшен в день старта, т.к. часто его переподтверждают после сброса)
