## UpdateDayBudgetJob

### Продукт/подсистема

Дневной бюджет / Стратегии.


### Роль в работе продукта/подсистемы

Джоба выполняет полезную работу 1 раз в сутки и делает следующее:
- Сбрасывает в 0 количество изменений дневного бюджета кампании. Количество изменений бюджета используется, чтобы запрещать пользователям изменять бюджет более N раз в день (сейчас N = 3).
- Сбрасывает время остановки кампании по исчерпанию дневного бюджета и статус отправки нотификации.


### Датафлоу

Количество изменений дневного бюджета:
- Получает id всех кампаний в шарде, у которых поле `day_budget_daily_change_count` в таблице [ppc.camp_options](https://direct-dev.yandex-team.ru/db/ppc/tables/camp_options.html) больше `0`.
- У полученных кампаний устанавливает значение этого поля в `0` (чанками), как и у их стратегий в тaблице [ppc.strategies](https://direct-dev.yandex-team.ru/db/ppc/tables/strategies.html) поле `day_budget_daily_change_count`.

Время остановки:
- Получает все кампании, у которых время остановки дневного бюджета `day_budget_stop_time` в таблице [ppc.camp_options](https://direct-dev.yandex-team.ru/db/ppc/tables/camp_options.html) меньше текущего времени
- У полученных кампаний обнуляет поле `day_budget_stop_time`, а так же сбрасывает статус отправки нотификации `day_budget_notification_status` ("отправка случилась" (`sent`) -> "готово к отправке" (`ready`)).

### Способы наблюдения за текущим состоянием

- [Juggler-проверка](https://juggler.yandex-team.ru/check_details/?host=checks_auto.direct.yandex.ru&service=jobs.UpdateDayBudgetJob.working.production&query=&last=1DAY)
- [Логи](https://direct.yandex.ru/logviewer/#~(logType~'messages~form~(fields~(~'log_time~'host~'service~'method~'trace_id~'span_id~'prefix~'log_level~'class_name~'message)~conditions~(service~'direct.jobs~method~'autobudget.UpdateDayBudgetJob)~limit~100~offset~0~reverseOrder~true~showTraceIdRelated~false))$)


### Какая функциональность пострадает от отказа джобы

- Возможность изменения дневного бюджета у тех, кто достиг лимита по кол-ву изменений.
- Что-то связанное со временем ограничения дневного бюджета.


### Как пользователи (или команда) заметят проблему и через какое время

- С момента отказа джобы пользователи смогут поменять поменять дневной бюджет в каждой кампании от 0 до N раз (на момент написания = 3) в зависимости от текущего сохраненного количества изменений, так как количество совершенных изменений не будет сбрасываться.
- Что-то связанное со временем ограничения дневного бюджета.

### Контакты разработчиков и менеджеров

Разработчики: [Бехруз Афзали](https://staff.yandex-team.ru/xy6er)


### Желательное время исправления в случае поломки

Максимально быстро.


### Способы регулирования работы джобы

- ppc-property `UPDATE_DAY_BUDGET_LAST_RUN_DATE_%d`  — содержит дату, когда последний раз джоба выполнялась. Можно указать дату из будущего, чтобы джоба на время перестала выполнять полезную работу.


### Известные причины поломок




### Дополнительно: тонкости и подводные камни
