# Язык выражений фильтров
  
1. Условия, указанные через пробел или запятую, объединяются по "ИЛИ" (дизъюнктивно). Например, если фильтровать поле по условиям `0,1 2 , 3` , то будут показаны все записи, в которых значение данного поля равно 0, 1, 2 или 3.
Будет сгенерировано следующее условие в запросе в БД: `field_name = 0 OR field_name = 1 OR field_name = 2 OR field_name = 3`.  
2. Значение может иметь префикс в виде одного из операторов: !, <, >, <=, >=. Оператор может быть отделён от значения пробелами.
Оператор ! означает, что значение поля в записи должно отличаться от заданного. Например, фильтрация по условию `!12` (или `! 12`) выдаст все записи, значения которых в данном поле не равны 12.
Операторы <, >, <=, >= применяются для построения соответствующих условий сравнения.
Все условия, содержащие операторы, объединяются между собой по "И" (конъюнктивно), и объединяются с остальными условиями по "ИЛИ" (дизъюнктивно).
Пример: фильтрация поля по строке `> 12, 5, !17, 2` означает, что будут выданы записи, значения поля в которых больше 12 и не равно 17, или равно 5, или равно 2.
Будет сгенерировано следующее условие в запросе в БД: `(field_name > 12 AND field_name != 17) OR field_name = 5 OR field_name = 2`.  
3. При обработке строковых полей сравнение на равенство и неравенство заменяется на сравнение по like и not like в случае, если значения полей содержат символы подстановки % или _.
Например, запрос `abc% !de_g` преобразуется в `not like(field_name, "de_g") OR like(field_name, "abc%")`. В случае отсутствия подстановочных символов сравнение производится на равенство и неравенство.
Условия >, <, >=, <= сравнивают строки лексикографически и не обрабатывают символы подстановки каким-либо специальным образом.  
4. При фильтрации по колонкам, содержащим массив, при обработке массивов сравнения на равенство и неравенство заменяются на сравнения по has и not has, а сравнения >, <, >=, <= не допускаются.
Например, запрос `!8, 12` преобразуется в `not has(field_name, 8) OR has(field_name, 12)`, т.е. будут выданы все записи, в которых в массиве не содержится значение 8 или содержится значение 12 (на самом деле второе условие в данном запросе излишне).  
