# ppcCampQueue.pl

## Описание
### Продукт/подсистема

Обработка очередей заданий на действия с кампаниями.

### Роль в работе продукта/подсистемы

Асинхронное копирование, архивация, разархивация и удаление кампаний.


### Датафлоу
Читает из БД, пишет в БД, в другие сервисы не ходит.

В зависимости от par-id, переданного в параметрах запуска, обрабатывает одну из очередей операций с кампаниями:
  - par-id=copy:1..N - [ppc.camp_operations_queue_copy](https://a.yandex-team.ru/arc/trunk/arcadia/direct/perl/db_schema/ppc/camp_operations_queue_copy.text), копирование кампаний
  - par-id=rest - [ppc.camp_operations_queue](https://a.yandex-team.ru/arc/trunk/arcadia/direct/perl/db_schema/ppc/camp_operations_queue.text), архивация, разархивация, удаление

Очереди шардированные - на обработку заданий каждого шарда запускается не менее одного worker'а.

Задание выбирается из соответствующей очереди и пытается выполниться. Если обработка задания падает - делается 5 попыток повтора с нарастающим интервалом: 1, 30, 60 и 180 секунд.

После выполнения, либо окончания попыток повтора, задание удаляется из очереди.

Захват и результат выполнения задания логируются в `messages`, где могут быть найдены по `cid`.


### Способы наблюдения за текущим состоянием

- [Juggler-проверка](https://juggler.yandex-team.ru/check_details/?host=checks_auto.direct.yandex.ru&service=scripts.ppcCampQueue.working&query=&last=1DAY)
- [Логи](https://direct.yandex.ru/logviewer/#~(logType~'messages~form~(fields~(~'log_time~'host~'service~'method~'trace_id~'span_id~'prefix~'log_level~'class_name~'message)~conditions~(method~'ppcCampQueue~service~'direct.script)~limit~100~offset~0~reverseOrder~true~showTraceIdRelated~false))$)
- [Возраст очереди в минутах, по шардам](https://solomon.yandex-team.ru/?project=direct&cluster=app_java-jobs&service=java_jobs&l.sensor=age_minutes&l.host=CLUSTER&graph=auto&l.queue=camp_operations_queue_copy&l.env=production&secondaryGraphMode=none&stack=false&b=1d&e=)


### Какая функциональность пострадает от отказа скрипта

При накоплении большого количества заданий в одной из очередей копирование/архивация/разархивация/удаление выполняются с ощутимой задержкой.


### Как пользователи (или команда) заметят проблему и через какое время

Если возраст заданий в очереди начинает исчисляться часами - возможны жалобы от клиентов, что копирование/архивация/разархивация не работают.



### Контакты разработчиков и менеджеров

Разработчики: [Максим Логунов](https://staff.yandex-team.ru/maxlog) (плохо знаю код скрипта, но посмотреть могу)


### Желательное время исправления в случае поломки

В течение суток.


### Способы регулирования работы скрипта
Посмотреть и изменить значения влияющих на работу скрипта `ppc_property` можно через [Ограниченное редактирование типизированных свойств](https://direct.yandex.ru/internal_tools/#set_typed_ppc_property).

{% cut "Управление worker'ами очереди копирования" %}

**ppc_property**: `camp_copy_queue_additional_workers` - можно ускорить исполнение заданий в очередях указанных шардов за счет активации дополнительных обработчиков.

По крону на очередь каждого шарда запускается по три обработчика: 
 - `--par_id copy:1` пытается запуститься каждые три минуты,
 - `--par_id copy:2, --par_id copy:3` - каждые 15 минут.

При пустом значении `camp_copy_queue_additional_workers` только первый обработчик активируется после запуска и начинает следить за очередью.  
Два других проверяют значение `camp_copy_queue_additional_workers` и, не найдя там записей для себя, завершают работу.

Чтобы дополнительный обработчик N активировался и начал разбор очереди шарда S, нужно в значении `camp_copy_queue_additional_workers` указать
`{"S:N":"on"}` или `{"S:N":"R:M"}`.

В первом случае обработчик N шарда S запустится и начнет обрабатывать очередь своего шарда, во втором - начнет обрабатывать очередь шарда R, идентифицируя себя как "обработчик номер M".

{% note warning %}

Без переназначения на обработку очереди шарда можно подключить дополнительных обработчиков не больше, чем запускается по крону (сейчас - 2 + 1 основной).
Т.е. `"2:2": "on", "2:3": "on"` подключат обработчики, а `"2:4":"on"` - уже нет. Если нужны еще обрабочики - можно забрать их c других шардов: ` ... "3:2":"2:4", "4:2":"2:5", ...`.

Конфигурацию основного обработчика менять нельзя - запись в конфигурации `"2:1":"on"`, ``"2:1":"3:2"``, ``"3:2":"2:1"`` будет воспринята как ошибочная.
Если в конфигурации найдены ошибки - запускаются только основные обработчики. Ошибки [логируются в messages](https://direct.yandex.ru/logviewer#~(logType~'messages~form~(fields~(~'log_time~'host~'service~'method~'trace_id~'span_id~'prefix~'log_level~'class_name~'message)~conditions~(message~'*25additional_workers_error*25~method~'ppcCampQueue)~limit~100~offset~0~reverseOrder~false~showTraceIdRelated~false))$)

{% endnote %}

#### Пример
Задана конфигурация
```json
{"2:2":"on", "5:3":"on", "6:2":"on", "6:3":"on", "5:2":"6:4"}
```
При такой конфигурации очереди шардов 2 и 5 будут разбираться двумя обработчиками:
 - для любого шарда обработчик `:1` (основной) работает всегда
 - вдобавок к нему  на втором шарде будет активирован дополнительный обработчик `:2`, а на пятом - дополнительный `:3`.

Очередь шестого шарда будет разбираться четырьмя обрабочиками:
 - основной `:1`,
 - дополнительные `:2` и `:3`,
 - плюс обработчик `:2` пятого шарда тоже подключится к разбору очереди шестого, используя идентификатор "4" для логирования и захвата заданий.

В `messages` у сообщений обработчиков очереди шестого шарда будут префиксы `shard_6,par-id_copy:1`, `shard_6,par-id_copy:2`, `shard_6,par-id_copy:3`, `shard_6,par-id_copy:4`.  
С префиксом `shard_5,par-id_copy:2` будет только однократное сообщение`remaping applied 5:2 -> 6:4` - при активации обработчика.

Активированные дополнительные обработчики работают до тех пор, пока в `camp_copy_queue_additional_workers` не будет изменено связанное с ними значение.
При изменении связанного значения обработчик завершит работу, а затем  в течение 15 минут поднимется с новой конфигурацией.

#### Пример

Предыдущая конфигурация изменена на следующую
```json
{"2:2":"6:5", "6:2":"on", "3:2":"on"}
```
При таком изменении конфигурации все активированные ранее дополнительные обработчики, кроме второго обработчика очереди шестого шарда, завершат работу.  
Затем, в течение 15 минут активируются обработчики `:2` второго и третьего шардов.
Обработчик `:2` второго шарда подключится к разбору очереди шестого, а обработчик `:2` третьего шарда будет разбирать свою очередь.

{% endcut %}

{% cut "Управление нагрузкой на БД при копировании кампаний" %}

**ppc_property**:  `camp_copy_queue_sleep_coef` - можно уменьшить интенсивность копирования, чтобы снизить нагрузку на базу данных.

Задает значения разгрузочных коэффициентов для обработчиков указанных шардов.

Разгрузочный коэффциент определяет отношение паузы, которую сделает обработчик перед тем как взять следующее задание ко времени выполнения текущего задания.  
Т.е. при значении разгрузочного коэффициента 2, выполнив копирование за 10 секунд, обработчик прождет еще 20 секунд, прежде чем возьмет следующее задание.

#### Пример
```json
{"default":"1", "shard_1":"0.5", "shard_6":"3"}
```
В данном случае для всех обработчиков очереди копирования кампаний первого шарда задан разгрузочный коэффициент 0.5, для обработчиков заданий 6-го шарда - разгрузочный коэффициент 3, а для всех остальных - 1.

При пустом значении `camp_copy_queue_sleep_coef` для всех обработчиков используется разгрузочный коэффициент 0.01.

Если через `camp_copy_queue_additional_workers` для обработчика переопределен шард - обработчик будет использовать значение разгрузочного коэффициента того шарда, очередь которого обрабатывает.

Т.е. если заданы  `camp_copy_queue_additional_workers`:`{"2:3":"5:4"}` и `camp_copy_queue_sleep_coef`:`{"shard_2":"1", "shard_5":"2"}` - очередь 5-го шарда будет разбираться тремя обработчиками и все три будут использовать разгрузочный коэффициент 2.

{% endcut %}

Реальные примеры конфигурации и результаты изменения параметров обработки очереди можно посмотреть в [DIRECT-143213: Активировать в проде дополнительные обработчики копирования и проследить за их работой](https://st.yandex-team.ru/DIRECT-143213).


### Известные причины поломок

Периодически клиенты используют копирование большого числа кампаний чтобы создать нагрузку на модерацию в расчете на то, что она пропустит контент, который в нормальном режиме был бы гарантированно отклонен.  
В этом случае в очереди одного из шардов скапливается большое количество кампаний, поставленных на копирование примерно в одно и то же время.
Это может на несколько часов затормозить обработку кампаний других клиентов.

Также, запустить большое число кампаний на копирование может менеджер или агенство.  
В этом случае можно аккуратно подключить дополнительные обработчики очереди, не забывая следить за нагрузкой на базу.  
Как подключать обработчики и регулировать нагрузку на базу описано выше.


### Дополнительно: тонкости и подводные камни
{% cut "Порядок обработки заданий на копирование кампаний" %}

При копировании worker `copy:n` выбирает задание с минимальным `effective_queue_time` и `par_id` равным `n` или `null`.
Задание метится установкой `par_id=n` и отправляется на дальнейшее выполнение.
`par_id` отличный от null может быть у задания в двух случаях:
  - если оно уже пыталось обработаться, но обработка завершилась аварийно и задание не было удалено из очереди;
  - если вручную, миграцией, форсирована обработка задания воркером с таким номером;

{% note warning %}

Задания с установленным `par_id` не будут обрабатываться, если worker с соответствующим номером не запущен для данного шарда.

{% endnote %}

Ручную установку `par_id` можно использовать в экстренных случаях, для обработки копирования определенных кампаний отдельным потоком.

{% endcut %}

{% cut "Пессимизация копирования кампаний клиента" %}

Для того, чтобы клиенты активно и помногу копирующие кампании меньше тормозили обработку заданий других клиентов, после каждого копирования остальные задания того же клиента сдвигаются назад по очереди.

Для этого в `ppc.camp_operations_queue_copy`, помимо истиного времени постановки задания в очередь - `queue_time`, добавлено условное время постановки в очередь - `effective_queue_time`,
а в `ppc.clients_options` в поле `camp_copy_ela` сохраняются накопленное суммарное время копирования кампаний клиентом и unixtime последнего копирования.

При постановке задания в очередь ему выставляется `effective_queue_time` равное `queue_time` + `накопленное время копирования`.

После выполнения копирования кампании суммарное накопленное время уменьшается на часть пропорциональную времени, прошедшему с последнего копирования, а затем потраченное на копирование кампании время добавляется к накопленному.
Всем имеющимся заданиям в очереди проставляется `effective_queue_time` = `queue_time` + `новое значение накопленного суммарного времени`.

Пессимизируются только задания, добавленые в очередь клиентами.
Задания добавленные операторами с другой ролью не пессимизируются.

{% endcut %}

