# ppcFeedToBannerLand.pl

## Описание
### Продукт/подсистема

Обработка фидов товаров и услуг в BannerLand

### Роль в работе продукта/подсистемы

Отправка фидов в BannerLand для их валидации и разбора. По результату проставляет фидам статус, количество офферов и
записывается в БД информацию об ошибках, если они были.


### Датафлоу
Читает из БД, пишет в БД, отправляет фиды синхронно в ручку `yml2directinf`.

При запуске выставляет устаревшим фидам статус `Outdated`, а ошибочным, у которых с ошибки прошло достаточно много
времени — `Updating`. Дальше берёт все фиды в статусах `New`, `Outdated`, `Updating` и пытается переотправить их в
BannerLand. По результатам проставляет фидам актуальные статусы и добавляет/обновляет записи в смежных таблицах
с историей, категориями и вендорами.


### Способы наблюдения за текущим состоянием

- [Juggler-проверка](https://juggler.yandex-team.ru/check_details/?host=checks_auto.direct.yandex.ru&service=scripts.ppcFeedToBannerLand.working&query=&last=1DAY)
- [Логи](https://direct.yandex.ru/logviewer/#~(logType~'messages~form~(fields~(~'log_time~'host~'service~'method~'trace_id~'span_id~'prefix~'log_level~'class_name~'message)~conditions~(method~'ppcFeedToBannerLand~service~'direct.script)~limit~100~offset~0~reverseOrder~false~showTraceIdRelated~false))$)


### Какая функциональность пострадает от отказа скрипта

Перестанут обновляться фиды, включая новые. Клиенты не смогут использовать свои фиды для создания ДО, смартов и
товарных кампаний.


### Как пользователи (или команда) заметят проблему и через какое время

Возможны жалобы от клиентов, что обработка фидов занимает слишком много времени.


### Контакты разработчиков и менеджеров

Разработчики: [Евгений Козобродов](https://staff.yandex-team.ru/kozobrodov), [Сергей Ковач](https://staff.yandex-team.ru/buhter)

Менеджеры: [Дмитрий Уляшев](https://staff.yandex-team.ru/ulyashevda)


### Желательное время исправления в случае поломки

В течение суток.


### Способы регулирования работы скрипта

У скрипта есть несколько параметров, настраиваемых из перловых [внутренних инструментов](https://direct.yandex.ru/registered/main.pl?cmd=internalReports&report_id=feed_to_banner_land_settings):
- Размер выборки из БД за раз
- Количество параллельных запросов в BannerLand
- Максимальное количество попыток загрузить фид в Banner Land
- Срок годности статуса `Error`
- Максимальное время сна между итерациями


### Известные причины поломок


### Дополнительно: тонкости и подводные камни

