### Вводные
В Мастер добавилась возможность создания лендингов Бизнеса.

Лендинг -- это простой сайт, который можно завести для своей организации.

Если пользователь вводит ссылку, и мы по этому урлу не нашли счетчика или целей, то предлагаем пользователю блок с лендингами.

В блоке с лендингами пользователю нужно выбрать или создать организацию из Яндекс Бизнеса.

Если на этой организации есть лендинг, то он отобразится в Мастере. Если у выбранной организации лендинга нет, то у пользователя создастся лендинг и в интерфейсе мастера появится блок с текстовыми полями, где можно будет заполнить информацию о лендинге.

Также, пользователь может после создания лендинга редактировать его в Яндекс Бизнесе. В Яндекс Бизнесе доступно больше возможностей для добавления на лендинг , которых нет в Директе, например, добавление товаров или фотографий.

**Пример на тестовой среде**

Организация [в тестинге](https://l7test.yandex.ru/sprav/8636603/edit/main). 

Если прав нет, то нажать на кнопку "Получить права", вбить любой номер телефона, код подтверждения 0123

Лендинг редактируется на [странице](https://l7test.yandex.ru/business/crm/company/1144061008/site)

Результат -- [ссылка на лендинг](https://izumrud-jug2.tst-clients.site)

### Связь с организацией
Лендинг живёт на организации. Клиент может задать, на какой организации будет создан лендинг. Если у этой организации уже есть лендинг, то использоваться будет он. Ссылка на лендинг будет использоваться в объявлениях


### Что нужно хранить в БД

В целом все данные про лендинг мы забираем у Бизнеса, но есть несколько полей, которые храним у себя

1. Связь РК с лендингом
2. Все изображения, используемые для лендинга -- сейчас это лого и обложка, мы будем загружать их в свой неймспейс в Аватарнице[1]
3. Ссылка на лендинг. Используется при формировании объявления

[1] пока что не планируем удалять загруженные изображения. Подробности тут https://st.yandex-team.ru/DIRECT-166957#6272637c5cfc9d5d2ba904bf

Данные хранятся в GRUT

### Как храним данные
1. Поле `biz_landing_id` в таблице `campaigns`. Индекс (для поиска всех кампаний с конкретным лендингом в будущем) + внешним ключом с таблицей `biz_landing`
2. Таблица `biz_landing`, в которой храним `id`, `href`, `logo_image_url`, `cover_image_url`,
   Таблица отдельная, потому что в перспективе туда будут добавлены и другие поля, например, статус

Связь клиента и лендингов не нужна, каждый с доступом может редактировать этот лендинг и все видят один и тот же лендинг

### Как используем на бекенде БД
1. Так как есть несколько мест, из которых лендинг может быть отредактирован, актуальную информацию всегда будем забирать из Бизнеса. У нас будет храниться всего лишь маленькая часть полей, которые нужны нам в других процессах помимо отрисовки лендингов на странице редактирования кампании
2. При создании/редактировании РК, если для выбранной организации уже существует какой-то лендинг и нам нужно достать его описание, таблицу `biz_landing` на чтение не используем
2. При создании/редактировании лендинга обновляем `logo_image_url` в `biz_landings` таблице, если он изменился.
   Аналогично с `cover_image_url`.
3. `href` через интерфейс Директа изменить нельзя
4. `biz_landings.href` используем в джобе при генерации объявлений, чтобы не ходить напрямую в API Бизнеса за ссылкой
5. Будет джоба, которая обновляет `biz_landings.href`, если он изменился в Бизнесе, и обновляет это поле у объявлений

### Сценарии взаимодействия с фронтендом
1. При **создании** кампании на фронте выгружается список организаций клиента в отдельном попапе.
   Если список не пуст, то пользователь выбирает организацию. Иначе создает новую. Только когда он выберет организацию, приступает к заполнению полей для лендинга. С имеющимся пермалинком с фронта приходит запрос на чтение лендинга. С бекенда всегда возвращается лендинг (если его не было, он генерируется в моменте и отдается)
2. При **редактировании** кампании в поле `biz_landing_id` на кампании будет либо идентификатор лендинга, либо `null`. Если есть какой-то идентификатор, то нужно сходить за описанием в ручку чтения. Если `null`, значит лендинг на этой кампании не захотели устанавливать (тумблер выключен?). Если его включают, то все как при создании


### Важные моменты
1. Лендинг связан с организацией как 1:1. Он не завязан на конкретного пользователя в Яндексе -- каждый у кого есть доступ к организации редактирует один и тот же лендинг
2. Для редактирования лендинга у оператора должны быть права на редактирование организации, связанной с этим лендингом
3. Если на кампании установлен лендинг от Бизнеса, то на редактировании нет возможности отключить ее.
4. Нигде не храним исходный `url`, который ввел пользователь при создании кампании
5. Чтение на самом деле это мутация, которая работает по принципу *getOrCreate*
6. Если пользователь изменит уже созданный в Бизнесе лендинг в Директе, то в случае есть делать сразу же обновление лендинга, весь функционал, который есть в Бизнесе , но нет в Директе, сотрется и останутся только те части лендинга, которые есть в Директе. Чтобы этого избежать перед обновлением нужно делать чтение и мерджить текущее состояние с входящими изменениями, не трогая при этом те поля, про которые не знает Директ

### Более подробно интеграция с API Landlord, BVM, Справочник
#### Чтение по заданному идентификатору лендинга
Запрашиваем данные у Лендлорда и возвращаем на фронт
#### Чтение по пермалинку
1. Идем в BVM API, чтобы получить идентификатор лендинга для заданной организации или `null`, если лендинга нет
2. Если лендинг есть, то запрашиваем данные у Лендлорда и возвращаем на фронт
3. Если лендинга нет, то нужно создать его с дефолтными параметрами == параметрами из организации. Для этого сначала проверяем есть ли у оператора права на редактирование организации, и если да, то вновь идем в BVM API, запрашиваем создание идентификатора лендинга, далее идем в Landlord API и генерируем данные для лендинга. После этого вновь должны сходить в Landlord API, чтобы получить описание лендинга, которое отдаем на фронт

#### Обновление лендинга
1. Проверяем права оператора на редактирование организации
2. Валидируем переданные контакты и подготавливаем ссылки на них, если это нужно (с фронта может прийти контакт типа TELEGRAM со значением `foo`, а при запросе в Landlord API мы должны сформировать ссылку вида `https://t.me/foo`)
3. Вычитываем текущий стейт лендинга с помощью Landlord API
4. Мерджим input на изменение от фронтенда с текущим стейтом, полученным на предыдущем шаге. Это сделано для того, чтобы не перезатереть поля, которые есть у лендинга, но которых нет в Директе.
5. Обновляем контакты организации, делая запрос в Справочник. Это сделано для того, чтобы на лендинге и на организации были одинаковые контакты -- это обязательное условие
6. Отправляем два запроса в Landlord API на обновление лендинга. Два -- STABLE и UNSTABLE версия -- легаси Лендлорда
7. Обновляем данные в grut
