# Сбор сегментов аудиторий

## О фиче

Клиенты Директа могут собирать аудитории из людей, которые видели их рекламу, чтобы затем таргетировать на них другие креативы.
Таким образом, они могут поэтапно показывать аудитории разные креативы в зависимости от того, на сколько аудитория знакома с продуктом.
Другими словами, рекламодатели могут показывать потенциальным клиентам целый сериал.

Клиент выставляет настройку в группе "собирать сегмент". Для видео-объявлений доступны опции сбора разных сегментов
в зависимости от просмотренной длительности ("увидел", "посмотрел 25%", "посмотрел 50%" и т.д.).
Для ТГО-объявлений доступна опция сбора сегментов видевших рекламу в РСЯ. Через некоторое время в сервисе Я.Аудитории
появляется сегмент, который можно использовать для таргетинга в Директе.

## Данные в MySQL

При первом включении каждой галочки в таблице [ppc.video_segment_goals](https://direct-dev.yandex-team.ru/db/ppc/tables/video_segment_goals.html)
создаётся запись с мета-информацией о собираемом сегменте.

Поля таблички:

- `audience_type` - тип просмотра (просмотр, 25%, 50% и т.д.)
- `internal_status` - внутренний статус в Директе:
  - `new` - сегмент еще не создан в Я.Аудиториях
  - `complete` - сегмент создан в Я.Аудиториях
  - `historical_required` - не используется
- `external_audience_status` - статус сегмента в Я.Аудиториях:
  - `processed` - сегмент готов к дальнейшей доливке данных (uid-ов)
  - `is_processed` - сегмент в обработке, доливка данных недоступна
  - `processing_failed` - обработка завершилась с ошибкой, доливка данных недоступна
  - `deleted` - сегмент удален в интерфейсе Я.Аудиторий, доливка данных недоступна
  - `few_data` - сегмент отсутствует в интерфейсе Я.Аудиторий, так как недостаточно данных для его создания (< 1000)
- `is_disabled` - сбор сегмента выключен (галочка отжата в интерфейсе редактирования группы)
- `external_audience_id` - id сегмента в Я.Аудиториях, 0 - если сегмент не создан
- `segment_owner_uid` - uid владельца, от имени которого создаётся и используется сегмент в Я.Аудиториях
- `time_created` - время создания
- `last_successful_update_time` - последняя дата, за которую в сегмент были долиты данные из логов
- `segment_error_count` - количество ошибок подряд при доливке сегмента, при достижении лимита попытки прекращаются (50)

## Основные блоки функциональности

[SegmentStatusUpdateJob](../jobs/list/SegmentStatusUpdateJob.md) раз в сутки обновляет статусы сегментов в поле `ppc.video_segment_goals.external_audience_status`.

[CpmDefaultSegmentIntermediateTableCreateJob](../jobs/list/CpmDefaultSegmentIntermediateTableCreateJob.md)
варит промежуточные таблицы по chtracking-логам (для CPM) только с релевантными данными для последующего чтения джобами сбора сегментов.

[CommonSegmentIntermediateTableCreateJob](../jobs/list/CommonSegmentIntermediateTableCreateJob.md)
варит промежуточные таблицы по chevent-логам (для ТГО) только с релевантными данными для последующего чтения джобами сбора сегментов.

Джобы создания сегментов создают сегмент в Я.Аудиториях по API от имени главного представителя и заливает в него uid-ы видевших рекламу.

Джобы обновления сегментов доливают в сегменты в Я.Аудиториях по API новые uid-ы видевших рекламу.

На каждый тип группы есть свои джобы создания и обновления сегментов, наследующие общий механизм.
Это нужно для параллельной обработки и устранения единой точки отказа.

## Алгоритм создания/обновления сегментов

Что нужно знать для понимания алгоритма:
- при наливке порции данных в сегмент в Я.Аудиториях он переходит в статус "в обработке" и
становится недоступен для дальнейшей наливки, пока не перейдет в статус "обработан". Сроки перехода между статусами непредсказуемы.
- количество данных в логах, которые требуется заливать в сегмент, вариируются между разными сегментами от единиц uid-ов до десятков миллионов.
- чтение производится из подневных таблиц Крутилки, которые варятся раз в сутки за предыдущие сутки

Общий алгоритм работы джоб создания и обновления сегментов:

1. Из базы извлекаются записи с мета-информацией о сегментах, готовых к дальнейшей наливке.
2. Отбираются записи с самой старой датой последних прочитанных логов.
3. Из промежуточной таблицы в YT читается количество данных для каждого сегмента с предыдущей даты до даты с самыми свежими логами.
4. Жадным алгоритмом отбираются сегменты, суммарное количество данных по которым не превышает лимит.
5. Если самый большой сегмент упирается в лимит, то диапазон дат сокращается вдвое (переход к шагу 3).
6. Извлекаются непосредственно данные сегментов.
7. Данные сегментов последовательно заливаются в Я.Аудитории.
8. Обновляется мета-информация о сегментах в базе:
  - для сегментов с новыми данными сдвигается дата, меняется статус на "в обработке";
  - для сегментов без новых данных сдвигается дата;
  - для сегментов, которые не удалось залить, увеличивается количество ошибок.

Перевести сегмент из статуса "в обработке" может только джоба [SegmentStatusUpdateJob](../jobs/list/SegmentStatusUpdateJob.md).
