# Организации Справочника

## Как лежит в базе Директа { #base }

### Организации { #base-organizations }

**Структура**

Таблица organizations хранит статус организаций, которые использовал клиент.

Колонки:

- ClientID — идентификатор клиента
- permalink_id — идентификатор организации в Справочнике
- chain_id — идентификатор сети организации. Если организация не находится в сети тогда значение 0.
- status_publish ('unknown','published','unpublished') — статус организации (определяется по статусу организации в базе Справочника)

Первичный ключ ClientID + permalink_id

**Как меняются записи**

- Запись добавляется, когда клиент впервые привязывает организацию к своему банеру или кампании. Подробнее про привязки к [банеру](#actions-banner_link) и [кампании](#actions-campaign_link).
- Меняться в существующей записи может только статус публикации. Меняется он при обработке пуша от Справочника об изменении статуса публикации организации. Подробнее [тут](#actions-unpublishing).

Записи никогда не удаляются. Даже после того как клиент отвязал организацию от всех своих кампаний и банеров запись остается.

### Привязки к банерам { #base-banner_permalinks }

**Структура**

Таблица banner_permalinks хранит привязки организаций к банерам.

Колонки:

- bid — идентификатор банера
- permalink — идентификатор организации в Справочнике
- chain_id — идентификатор сети организации в Справочнике
- permalink_assign_type ('auto','manual') — тип привязки (ручной или автоматический)
- is_sent_to_bs — признак отправки в БК
- uniq_cond — техническое поле для реализации уникальности привязок на уровне базы
- is_change_to_manual_rejected — признак отклонения подтверждения на изменение типа привязки
- prefer_vcard_over_permalink — признак приоритета визитки над карточкой организации
- client_phone_id — идентификатор телефона клиента (из таблицы client_phones)

Первичный ключ bid + permalink + chain_id.
К банеру вручную может быть привязана только одна организация. Сеть может быть привязана только автоматически.

**Как меняются записи**

- Ручная (permalink_assign_type=manual) привязка к банеру добавляется/удаляется при привязке/отвязке организации к банеру/кампании. Подробнее про привязку организации к [банеру](#actions-banner_link) / [кампании](#actions-campaign_link).
- Автоматическая (permalink_assign_type=auto) привязка к банеру добавляется/удаляется при обновлении автопривязанных организаций/сетей. [Подробнее](#sprav-import_autoassign)
- Автоматическая привязка может превратиться в ручную (permalink_assign_type=manual), если эта организация привязывается к банеру или кампании вручную. Например, это происходит при [подтверждении рекомендации по ручной привязке автопривязанной организации](#actions-autoassign_links).
- У автоматической привязки может включиться флаг is_change_to_manual_rejected, если клиент отказался от ручной привязки автопривязанной организации. [Подробнее](#actions-reject_autoassigned_links)
- Ручная привязка меняется при изменении приоритета визитки (prefer_vcard_over_permalink).

### Привязки к кампаниям { #base-campaign_permalinks }

**Структура**

Таблица campaign_permalinks хранит привязки организаций к кампаниям.

Колонки:

- cid — идентификатор кампании
- permalink_id — идентификатор организации в Справочнике
- chain_id — идентификатор сети. Сейчас не используется и всегда 0.
- client_phone_id — идентификатор телефона клиента (из таблицы client_phones)

Первичный ключ cid. То есть к одной организации можно привязать только одну организацию.

**Как меняются записи**

- Запись добавляется/удаляется при привязке/отвязке организации к кампании. Подробнее про [привязку организации к кампании](#actions-campaign_link).

## Действия { #actions }

### Превью банера или организации { #actions-preview }

- Превью организации есть на странице редактирования текстовой кампании и банера ТГО. Отображаются название, статус, телефон и адрес.
- Также на редактировании кампании используются счетчики метрики.
- Фронт для получения информации ходит в ручку бека get_info со списком организаций. Бек ходит в АПИ Справочника [запросом информации по организации](#operations-get_organization).
- Статус АПИ [мапится](#operations-map_status) в статус Директа.
- На фронте статусы отображаются по-разному: PUBLISHED — зеленая, MOVED и TEMPORARILY_CLOSED — желтая (ворнинг), UNPUBLISHED — красная.

### Привязки к банерам { #actions-banner_link }

**Интерфейс**

- Выбор организации доступен через iframe Справочника.
- После выбора организации она отображается как описано [выше](#actions-preview).
- Если организация заполнена, то можно указать "номер в объявлении". Для владельцев есть возможность указать любой телефон. Остальные пользователи могут указать только подменный номер Телефонии (aka Calltracking) или номер из Справочника. Подробнее во внешней документации: <https://yandex.ru/support/direct/efficiency/phone.html>

**Серверная часть**

- Информация об организации привязанной к банеру достается из Справочника [балковым информации по организациям](#operations-get_organization).
- Достаются только новые привязки, поэтому при отсутствии изменение или отвязвании организации АПИ Справочника не дергается.
- Статус АПИ [мапится](#operations-map_status) в статус Директа.
- При валидации проверяется статус привязываемой организации. Он должен быть PUBLISHED, иначе валидация считается не пройденной и создание/редактирование банера не применяется.
- Если клиент впервые привязывает эту организацию, то организация [добавляется на клиента](#operations-client_link).
- При изменении привязок производится изменение счетчиков кампании. [Подробнее](#operations-calculate_metrics_by_banners)

### Привязки к кампаниям { #actions-campaign_link }

**Интерфейс**

- Выбор организации доступен через iframe Справочника.
- После выбора организации она отображается как описано [выше](#actions-preview).
- Если организация заполнена, то можно указать "номер в объявлении". Для владельцев есть возможность указать любой телефон. Остальные пользователи могут указать только подменный номер Телефонии (aka Calltracking) или номер из Справочника. Подробнее во внешней документации: <https://yandex.ru/support/direct/efficiency/phone.html>

**Серверная часть**

- Информация об организации привязанной к банеру достается из Справочника [балковым запросом](#operations-get_organization).
- Достаются только новые привязки, поэтому при отсутствии изменение или отвязвании организации АПИ Справочника не дергается.
- Статус АПИ [мапится](#operations-map_status) в статус Директа.
- При валидации проверяется статус привязываемой организации. Он должен быть PUBLISHED, иначе валидация считается не пройденной и создание/редактирование банера не применяется.
- Если клиент впервые привязывает эту организацию, то организация [добавляется на клиента](#operations-client_link).
- В ближайшем будущем при привязке организации к кампании ко всем банерам этой кампании также привязывается эта организация. Аналогично на банеры копируется и подменный номер телефона. При отвязке организации от кампании от всех банеров тоже будут отвязаны организации.

### Распубликация { #actions-unpublishing }

- в топик sprav/altay/publishing-status-changes приходят события об изменении опубликованности организаций
- Директ обрабатывает события в ReceiveOrganizationStatusChangesJob
- На каждом шарде статус публикации организации меняется на PUBLISHED или UNPUBLISHED
- Всем банеры с ручной привязкой к одной из таких организаций отправляются на перемодерацию и переотправляются в БК.

### Подтверждение ручной привязки автопривязанной организаций { #actions-autoassign_links }

**Интерфейс**

- На странице редактирования банера пользователю предлагается вручную привязать автопривязанную организацию.
- При нажатии пользователем кнопки "Добавить" организация заполняется в интерфейсе будто бы пользователь сам ее нашел и выбрал. В базе данных при этом никаких изменений не происходит.
- В базе организация привязывается только после того как пользователь нажмет "Сохранить" и операция успешно завершится.

**Серверная часть**

Со стороны сервера операция ничем не отличается от обычной [привязки организации к банеру](#actions-banner_link). При этом запись про автоматическую привязку будут заменена на запись про ручную привязку.

### Отказ от рекомендованной привязки организаций { #actions-reject_autoassigned_links }

- На странице редактирования банера пользователю предлагается вручную привязать автопривязанную организацию.
- При нажатии пользователем кнопки "Скрыть" в сервер сразу отправляется запрос для скрытия рекомендации.
- В базе данных привязка помечается как отклоненная и больше не рекомендуется пользователю. При этом привязка продолжает работать как автопривязанная.

### Модерация банеров

TODO описать

### Транспорт банеров

TODO описать

## Операции { #operations }

### Мапинг статусов организаций из АПИ Справочника в статусы Директа { #operations-map_status }

Из АПИ приходят статусы:

- PUBLISH -> PUBLISHED
- MOVED -> MOVED
- TEMPORARILY_CLOSED -> TEMPORARILY_CLOSED
- CLOSED, GEO_SPAM -> UNPUBLISHED
- DUPLICATE* -> UNPUBLISHED

DUPLICATE* — такой статус не приходит от API Справочника, но Директ распознает дубли [другим способом](#other-duplicate_status) и проставляет статус DUPLICATE.

Других статусов из АПИ пока что не приходит, но все они по умолчанию будут мапиться в UNPUBLISHED. Скора начнет приходить DUPLICATE.

### Мапинг статусов организаций Директа в статусы организаций в базе Директа { #operations-map_to_db }

- PUBLISHED, MOVED, TEMPORARILY_CLOSED -> PUBLISHED
- UNPUBLISHED -> UNPUBLISHED
- CLOSED сейчас приходить не может, но по умолчанию он мапится в PUBLISHED
- UNKNOWN сейчас приходить не может, но по умолчанию он мапится в UNKNOWN

### Добавление организации на клиента { #operations-client_link }

В таблицу [organizations](#base-organizations) добавляется запись.
Статус организации маптся в enum базы по правилу

- PUBLISHED, MOVED, TEMPORARILY_CLOSED, CLOSED -> published
- UNPUBLISHED -> unpublished
- UNKNOWN -> unknown

Но при текущей валидации сюда всегда приходят организации только со статусом PUBLISHED.

### Обновление счетчиков кампании при изменении привязок организаций к банерам { #operations-calculate_metrics_by_banners }

**Будущий вариант**

- Берутся все банеры кампании. Берутся все организации привязанные (с учетом изменений) вручную к этим банерам.
- Достаются счетчики метрики для каждой организации. [Подробнее](#operations-get_metrics)
- Если Справочник недоступен, а новые организации не привязывались, то обновления счетчиков не происходит.
- Если Справочник недоступен и привязывались новые организации, то выбрасывается ошибка, которая отменяет изменение банеров.
- Технические счетчики кампании обновляются до списка, полученного от АПИ Справочника.

**Текущий вариант**

- Берутся все банеры кампании.
- Берутся все организации привязываемые в текущей операции и которые не были привязаны к банерам ранее.
- Берутся все организации отвязываемые в текущей операции и у которых привязок к этим банерам не остаются.
- Достаются счетчики метрики для организаций из списков. [Подробнее](#operations-get_metrics)
- Если Справочник недоступен, а новые организации не привязывались, то обновления счетчиков не происходит.
- Если Справочник недоступен и привязывались новые организации, то выбрасывается ошибка, которая отменяет изменение банеров.
- Технические счетчики кампании изменяются в соответсвии со списками отвязанных и привязанных организаций.

### Получение счетчиков метрики { #operations-get_metrics }

- Метрики достаются запросом АПИ Справочника. [Подробнее](#sprav_api-get_metrics)
- Если для какой-то организации счетчик метрики не нашелся, то он создается на лету. [Подробнее](#other-force_metric_creating).

### Получение информации по организациям { #operations-get_organization }

- Для получения информации для превью в интерфейсе (старом и новом) если требуется информация по одному пермалинку, то используется [запрос информации по одной организации](#sprav_api-get_single_organization).
- В остальных случаях бек ходит в АПИ Справочника [балковым запросом](#sprav_api-get_multiple_organization).
- Если запрашивалась информация по счетчикам метрики и для какой-то организации счетчик метрики не нашелся, то он создается на лету. [Подробнее](#other-force_metric_creating).

## Взаимодействие со Справочником { #sprav_api }

- В проде ходим в https://sprav-api.yandex.net
- В тестовых средах ходим в http://sprav-api-test.yandex.net

У всех запросов кроме [поиска по тексту](#sprav-text_search)

- request_timeout = 2000ms
- soft_timeout = 500ms 
- request_retries = 2 (помимо первой попытки)

### Запрос информации по организации { #sprav_api-get_single_organization }

Ручка /v1/companies/{permalink}

Запрашиваемые параметры:

- Для интерфейса: NAMES, ADDRESS, PHONES, URLS, RUBRICS, LK_LINK (кнопка редактирования организации), PUBLISHING_STATUS
- HEAD_PERMALINK — для выявления PUBLISHING_STATUS=DUPLICATE кнопка редактирования организации)
- RUBRIC_DEFS — расшифровка названий рубрик
- Для превью банеров: IS_ONLINE, WORK_INTERVALS
- Нужно проверить и может быть убрать лишние: EMAILS, CHAIN, BUSINESS_PROFILE_LINK, METRIKA_DATA

### Балковый запрос информации по организациям { #sprav_api-get_multiple_organization }

TODO описать

### Запрос счетчиков метрики { #sprav_api-get_metrics }

Ручка /v1/metrika

Параметр permalinkIds — список пермалинков.

Ручка используется для [обновления счетчиков кампании при изменении привязок организаций к банерам](#operations-calculate_metrics_by_banners), поэтому список пермалинков может содержать все пермалинки кампании.

При большом списке пермалинков нужно запрашивать их счетчики порционно: https://st.yandex-team.ru/DIRECT-129709

### Создание счетчика метрики { #sprav_api-create_metrics }

Ручка /v3/companies/{permalink}/create-metrika

Используется при [создании счетчика метрики на лету](#other-force_metric_creating).

### Поиск организации по тексту { #sprav-text_search }

Настройки таймаутов мягче чем по остальным ручкам:

- request_timeout = 5000ms
- soft_timeout = 1000ms 
- request_retries = 2 (помимо первой попытки)

### Создание организации

Пока что не используется

### Выгрузка визиток из Директа

YQL запрос [banners_vcards.yql](https://a.yandex-team.ru/arc/trunk/arcadia/direct/jobs/src/main/resources/export/ppcdataexport/sprav/banners_vcards.yql) ежедневно собирает данные по [базе Директа](https://yt.yandex-team.ru/hahn/navigation?path=//home/direct/mysql-sync/current) и кладет результаты в [banners_vcards](https://yt.yandex-team.ru/hahn/navigation?path=//home/direct/export/sprav/banners_vcards).

Берутся только активные банеры или незаархивированные неотклоненные модерацией редактированные в последнюю неделю.

- bid, BannerID, domain, statusShow, statusActive, statusArch, statusModerate, LastChange — данные банера
- catalogia_categories — категория банера
- ClientID — клиент, которому принадлежит кампания
- vcard_id, uid, name, phone, worktime, address, lon, lat — данные визитки
- manual_permalink —  вручную привязанный пермалинк

### Загрузка автопривязанных организаций { #sprav-import_autoassign }

Справочник периодически обновляет данные по автопривязка на YT в таблице [banners-to-permalink](https://yt.yandex-team.ru/hahn/navigation?path=//home/altay/y-direct/current-state/banners-to-permalink).

Директ периодически првоеряет обновлялась ли таблица и при обновлении запускает YQL запрос [update_banner_permalinks.yql](https://a.yandex-team.ru/arc/trunk/arcadia/direct/jobs/src/main/resources/permalinks/update_banner_permalinks.yql), выгружая дифф между текущими автопривязками и обновлением Справочника. Дифф представляет собой список привязок для удаления и список привязок, которые нужно добавить.

Дифф применяется порционно к каждому шарду.

Для защиты от удаления всех привязок из-за пустой таблицы banners-to-permalink установлен лимит на размер диффа (70млн привязок). При превышения лимита загорается мониторинг и дифф не применяется.

## Прочее { #other }

### Распознавание организаций-дубликатов { #other-duplicate_status }

- Применяется при запросе статуса организации внутри [получения информации по организациям](#operations-get_organization).
- Если запрашивается статус организации, то обязательно запрашивается и поле head_permalink.
- При получения ответа для организации (каждой если это балковый запрос) проверяются поля id и head_permalink.
- Если поля заполнены и не свопадают, то статус подменяется на DUPLICATE.

### Восстановление дубликатов по оригиналам { #other-restore_duplicate }

- Если в [балковом запросе информации по организациям](#sprav_api-get_multiple_organization) указано более одного пермалинка, то в запрашивается поле DUPLICATES.
- Если в ответе данные по какому-то пермалинку не вернулись, то запускается процесс восстановления дубликатов.
- По вернувшимся пермалинкам собираются списки дубликатов с соответствующими им оригиналами.
- Если в списках дубликатов оказывается пермалинк, по которому данные не вернулись, то данные копируются с оригинала, но подменяются поля ID и PUBLISHING_STATUS.

### Создание счетчика метрики на лету { #other-force_metric_creating }

- Применяется при запросе счетчиков метрики внутри [получения информации по организациям](#operations-get_organization) и при специализированном [запросе счетчиков метрики](#sprav_api-get_metrics).
- Если для какой-то организации счетчик не вернулся, то такой организации [создается счетчик](#sprav_api-create_metrics).
- Данные по созданным счетчикам добавляются в исходный ответ так будто счетчик уже был создан на момент первого запроса.

### Изменение ссылки на личный кабинет Справочника { #other-update_lk_link }

- Применяется при запросе ссылки на личный кабинет внутри [получения информации по организациям](#operations-get_organization).
- В вернувшуюся ссылку добавляется параметр source=direct.
