# Регламент тестирования задач

## Новый процесс тестирования задач

1. _Разработчик:_ 
- тестирует задачу в ветке самостоятельно 
- покрывает основные регрессионные кейсы автотестами
- после окончания тестирования и написания автотестов переводит тикет в _Beta-tested_ и оставляет **подробный** комментарий с кейсами, которые были проверены в рамках тикета, и с кейсами, которые были покрыты автотестами (пишем так, чтобы было понятно **любому** человеку из команды).
_*Список поддерживаемых браузеров и разрешений можно найти [на страничке](https://wiki.yandex-team.ru/users/sonick/direct-cross-test)_
- мержит ветку в транк.  

2. При попадании задачи в релиз робот призовет разработчика в его тикеты. _Разработчик:_
- Делает смоук по задаче на тестовой среде https://test-direct.yandex.ru
- Отписывается в комментарий о сделанных проверках 
- В поле _Tested apps_ выставляет приложение в релизе которого был протестирован тикет. 
Для релизов dna - dna, для релизов canvas - canvas итд. 
Все затронутые изменениями приложения можно увидеть в поле _Affected apps_. 
_P.S. Больше ничего не делаем с задачей. Статус тикета не изменяем, это сделает робот после выкладки релизов по всем приложениям._

   {% cut "Шаги с ревью кейсов больше не выполняем (все шаги под катом)" %}

    1. _QA-Reviewer_ задачи реагирует на статусы _Beta-tested_, _Awaiting Release_, _Closed_ и  приходит ревьюить список протестированных разработчиком кейсов и список покрытых автотестами кейсов. Если списка нет - призываем разработчика
    2. Если список протестированных кейсов полный и дополнений нет, то выставляем в поле _QA review_ значение **Ok**.   
    Если были проверены не все кейсы, то выставляем в поле _QA review_ значение **Нужны доработки**, оставляем комментарий с чек-листом пропущенных проверок и призываем разработчика для ознакомления

    3. Если список покрытых автотестами кейсов полный и дополнений нет, то выставляем в поле _Autotesting_ значение **Тест написан**.   
    Если автотестами были покрыты не все необходимые кейсы, то выставляем в поле _Autotesting_ значение **Требуется тест** и создаем тикет на написание автотестов [по шаблону](https://st.yandex-team.ru/settings/templates/issues?name=Тикет%20на%20автотесты&owner=1120000000014295&queue=DIRECT) на разработчика задачи    

    Если автотесты в рамках тикета не требуются выставляем в поле _Autotesting_ значение **Тестирование не требуется**  
    4.  _Разработчик_ делает необходимые проверки и отписывается об этом в тикет.  
    5. _QA-Reviewer_ выставляет в поле _QA review_ значение **Ok**. Если по какой-то причине разработчик не выполнил все рекомендуемые проверки, то оставляем в поле _QA review_ значение **Нужны доработки**.  

   {% endcut %}


## Тестирование продуктовых фичей

{% note info %}

На тестирование крупных продуктовых фичей в проде заводятся цели с саб-тикетами на финальное тестирование, написание чеклиста и документации, написание кейсов и оценку покрытия автотестами
  {% cut "пример цели с тикетами на продуктовую фичу" %}

   ![alt text](https://jing.yandex-team.ru/files/sonick/2022-01-12_14-08-30.png "пример цели с тикетами на продуктовую фичу")

   {% endcut %}   

{% endnote %}

1. Сразу после появления требований по проекту _менеджер_ проекта делает синк с командой разработки и QA, где рассказывает про детали фичи и ее предполагаемые сроки открытия на % 
2. После выяснения требований _QA-Engineer_ приступает к составлению чеклиста, задает все интересующие вопросы менеджеру задачи и совместно с ним обсуждает все ли учтено в требованиях. 
На тикет с чеклистом назначается _QA-Reviewer_, он свежим взглядом ревьюит список проверок и дополняет его при необходимости. 
_Разработчик_ может использовать чеклист для тестирования своих задач по проекту.
3. Как только чеклист написан, на встрече по продуктовой фиче _QA-Engineer_ задачи совместно с _менеджером_ и _разработчиками бекенда и фронтенда_ задачи обсуждают все тестовые сценарии чеклиста, которые необходимо покрыть автотестами на беке и на фронте. По результатам встречи заводятся тикеты на автотесты [по шаблону](https://st.yandex-team.ru/settings/templates/issues?name=Тикет%20на%20автотесты&owner=1120000000014295&queue=DIRECT), которые также планируются в спринты, чтобы к запуску фичи в проде все автотесты были максимально написаны.
4. _QA-Engineer_ прорабатывает требования и пользовательские сценарии совместно с менеджером проекта и готовит Use Case'ы для тестирования заранее (до попадания фичи в прод) в рамках задачи на документацию
5. _QA-Engineer_ участвует во всех встречах по своему проекту и контролирует его статус, чтобы вовремя написать кейсы для асессоров (при невозоможности покрытия автотестами) и приступить к финальному тестированию по отмашке команды и менеджера проекта
6. _QA-Engineer_ проекта, после ревью задачи по своему проекту:
- если не все кейсы покрыты автотестами: заводит тикет на написание регрессионных кейсов асессорам и пишет кейсы в приоритетном порядке на логику, которая уже зарелизилась. **Все кейсы должны быть написаны и/или исправлены до финального тестирования!**
- форсит написание автотестов на синках для своих фичей
7. После того как фича полностью выкатилась в прод или на ТС, _QA-Engineer_ делает финальное тестирование по написанным Use Case'ам, проверяет все интеграции и догфудит. 
_Заведенные баги тестирует разработчик, как и другие тикеты. За конечное состояние фичи отвечает QA._
8. _Менеджер_ открывает фичу на процент по отмашке от _QA-Engineer_


## Тестирование задач в ветке (старый процесс)

1. Задача прилетает в тестирование в статусе **Ready For Test (RFT)**
2. QA выставляет в поле **Testing Story Points** примерное время в часах, требуемое для тестирования задачи, например: 0.25 TSP = 15 минут, 0.5 TSP = 0.5 часа, 1 TSP = 1 час и т. д. (учитывается только время чистого тестирования одной итерации всех кейсов по задаче)
3. QA берет задачу в работу в течение 2-3 рабочих дней и переводит тикет в статус **Testing**, когда начинает ее тестировать. _В зонте "Качество для специалистов" выставляем задаче день окончания тестированпия в поле "QA deadline"._
4. QA оценивает нужно ли исправлять или дописывать кейсы в регрессию по своей задаче и заводит связанный тикет в очереди **DIRECT** на написание yml. Для новых yml проставляем тег **regression**, новые кейсы должны быть вмержены в мастер к моменту попадания задачи в релиз (мержим одновременно с кодом разработчика задачи).
5. Все задачи фронта, затрагивающие изменения верстки тестируем в разных ОС, браузерах и разрешениях. Список поддерживаемых браузеров и разрешений на [страничке](https://wiki.yandex-team.ru/users/sonick/direct-cross-test/)
6. Найденные баги заводим саб-багами к своему тикету — создаем **sub-issue** с типом **Bug** (описание бага должно быть подробным и понятным любому человеку, как в инструкции по заведению багов прода) и переводим свой тикет (головной) в статус **Need Improvement** с комментарием, например `Протестировано в ветке. Для продолжения тестирования жду исправления найденных багов` или, если тикет мелкий, можно описать в комментарии найденную проблему и так же перевести задачу в статус **Need Improvement**. 
7. После окончания тестирования задачи в ветке и проверки всех ранее найденных багов, QA переводит свой тикет в статус **Beta Tested** и пишет **подробный** комментарий с кейсами, которые были проверены в рамках тикета, в каких браузерах, разрешениях и ОС (пишем так, чтобы было понятно **любому** человеку из команды)
8. Далее разработчик мержит свою ветку с кодом в мастер/транк, и тикет попадает в релиз в статусе **Awaiting release**


## Тестирование задач в релизе (старый процесс)

После отмашки релиз инженера QA:
1. Делает смоук по задаче на тестовой среде [test.direct.yandex.ru](https://test.direct.yandex.ru)
2. Отписывается в комментарий о сделанных проверках 
3. В поле **Tested apps** выставляет приложение в релизе которого был протестирован тикет. 
Для релизов dna — dna, для релизов canvas — canvas итд. 
Все затронутые изменениями приложения можно увидеть в поле **Affected apps**. 

P.S. Больше ничего не делаем с задачей. Статус тикета не изменяем, это сделает робот после выкладки релизов по всем приложениям.

## Поля, которые нужно заполнять при заведении багов

| **Название поля**        | **Как заполнять**  |
| ------------------------ | ------------------|
| **Queue**                | DIRECT             |
| **Type**                 | Bug                |
| **Priority**             | **Critical/Blocker** — обязательно показать дежурному по поддержке, чинить ASAP<br/>**Normal** — показать менеджеру отвечающему за соответствующую область и уточнить у него приоритет, либо показать дежурному по поддержке<br/>**Minor** — дополнительно уведомлять кого-либо о баге не обязательно |
| **Assignee**             | Если баг заводится на тестовой среде и понятно, из какой задачи баг — разработчик задачи, породившей баг. Если баг на тестовой среде и не понятно, из какой задачи баг — дежурный разработчик (Релизы + ТС). Если баг на продакшн — оставляем пустым |
| **Tags**                 | Проставляем тег зонтика, из которого выехал баг (теги зонтика начинаются с *abcumb:*, при проставлении можно пользоваться [справкой по ZBP](../who-knows.md#zbp) |
| **Stage**                | **Development** — баг есть только в бранче<br/>**Trunk** — баг есть в транке, но еще не попал на ТС<br/>**Release** — баг на ТС (в релизе)<br/>**Production** — баг в проде |
| **Bug Source**           | **Команда** — найдено командой Директа (разработка, тестирование, менеджеры)<br/>**Внешние пользователи** — найдено внешними людьми<br/>**Внутренние пользователи** — принесли коллеги из Яндекса<br/>**Асессоры** — найдено асессорами |
| **Bug Detection Method** | **Manually** — найдено руками<br/>**Autotests** — найдено автотестами<br/>**Asessors** — найдено асессорами<br/> **Monitoring** — мониторинги |
| **Type of Bug**          | **Functional** — функциональный баг<br/>**Visual** — визуальный баг верстки<br/>**Internal** — внутренняя проблема, не отражающаяся явно у пользователя<br/>**Integration** — баг интеграции<br/>**Functionality blocked** — баг, следствием которого является тот факт, что для пользователя становится заблокирован тот или иной функционал (например, некорректная валидация не дает сохранить какую-то настройку совсем)<br/>**Crash** — падение страницы<br/>**Content** — проблема в контенте страницы: опечатки, ошибки орфографические и логические<br/>**Legal** — юридические проблемы: оферта, договоры<br/>**Performance** — баг производительности |
| **Audience scale**       | Охват аудитории. Заполняется только для багов продакшена (описано в разделе ниже)|
| **Root cause of Bug**    | Причина возникновения бага (описано в таблице ниже)|

### Заполнение поля *Audience scale*
Для багов продакшена нам важно понимать, сколько пользователей видит/страдает от этого бага. Для определения охвата аудитории есть ряд инструментов:
* [Error booster](https://error.yandex-team.ru/projects/direct/errors?filter=message%20like%20500&period=month) - если понятен текст ошибки (фронтовой или бэкендовой), то выбрав в Error booster проект "DIRECT" и вписав в строку поиска "message like TEXT_OF_ERROR", можно посмотреть количество пользователей, у которых наблюдалась подобная ошибка
* [Статистика по посещаемости страниц](https://metrika.yandex.ru/stat/popular?period=month&accuracy=0.1&id=34&stateHash=60bf2077c47eab00310cf1a2) - по данной странице можно определить ежедневный и ежемесячный траффик на страницу, на которой воспроизводится баг
* [Статистика по браузерам](https://metrika.yandex.ru/stat/browsers?group=day&period=quarter&accuracy=0.1&id=34&stateHash=60ee9d845987f60014df0a97) - по данной статистике можно определить процент пользователей, приходящих в Директ с разных браузеров
* [Статистика по активным кампаниям Директа](https://datalens.yandex-team.ru/tvz4zvw8bcwen-obzor-direkta?tab=OZ) - можно посмотреть открутки по кампаниям в разных и интерфейсах и открутки по кампаниям разных типов

В зависимости от выбранного способа определения охвата оценить охват аудитории можно по следующей таблице:
| **Способ / Охват**    | **Small** | **Normal** | **Big** |
| ------------------------ | ------------------| ------------------| ------------------|
| **Error booster**    | <=2 человека в день| 3-10 человек в день | больше 10 человек в день |
| **Посещаемость страниц**    | <=0.5% пользователей | 0.6-2% пользователей | больше 2% пользователей |
| **Статистика по браузерам**    | <=0.5% пользователей | 0.6-2% пользователей | больше 2% пользователей |
| **Статистика по активным кампаниям**    | открутки <=0.5% | открутки 0.6-2% | открутки больше 2% |

### Заполнение поля *Root cause of Bug*

| **Значение поля**    | **Описание** |
| ------------------------ | ------------------|
| **Specification bug**    | баг в требованиях: на вики, в описании тикета, в личных сообщениях итп |
| **Requirements changes** | изначально в требованиях была описана одна логика, но в итоге решили внести изменение в эту логику или было принято решение не чинить баг вообще, так как он был признан некритичным, но после релиза все изменилось |
| **Tanker**               | баг из-за отсутствия переводов или из-за изменения текстов в Танкере (обычно верстка) |
| **Merge problems**       | баг мержа, актуально для ТС, когда мержатся ветки в master и неправильно разруливаются конфликты в результате чего функциональность из задачи, которая работала в ветке не работает на ТС |
| **Specific data**        | баг, который воспроизводится только на специфических тестовых данных |
| **Missed by assessor in regress** | баги, пропущенные асессорами во время релизной регрессии |
| **Complicated case**     | какой-то очень сложный сценарий, приводящий к багу |
| **Environment**          | баг, воспроизводящийся только в конкретном окружении, который не проявляется на других стендах, где тестировалась задача |
| **Flow problems**        | баг из-за несоблюдения процессов: вмержили раньше времени, выкатили в прод без тестирования, коммит в другом тикете - тикет не прилинковался к релизу итп |
| **Technical bug**        | технический баг: проблемы с сетью, недоступность среды, все админские проблемы |
| **Incomplete testing**   | тестирование не было завершено, задачу решили выкатить до окончания тестирования |
| **Skipped in later iterations of testing** | баг был пропущен в каких-то древних релизах и был найден спустя несколько месяцев |
| **Non-obvious dependencies** | баг, который выехал с задачей, где было неочевидно, что нужно проверить сценарий из бага |
| **missed obvious case**  | не был проверен очевидный кейс при тестировании или ретесте |
| **released with feature without testing**  | выкатили под фичей без тестирования, баг отловили в проде |
| **short time for testing**  | торопились к релизу/дедлайну/запуску при тестировании, в результате чего пропустили баг |
| **testing by developer**  | баг выехал из задачи, которую тестировал разработчик самостоятельно |
| **case wasn't included in assessors regress**  | кейс не был добавлен в асессорскую регрессию, добавить в рамках тестирования бага |
| **case wasn't covered by autotests**  | кейс не был покрыт автотестами, проконтролировать написнаие автотеста при фиксе бага |
| **Third-party service**  | баг из-за соседнего сервиса: не Метрика, не Модерация, не БК, не Баланс итд |
| **balance bug**  | баг Баланса |
| **moderation bug**  | баг Модерации |
| **metrika bug**  | баг Метрики |
| **bk bug**  | баг БК |
| **unknown reason**  | неизвестная причина, нужна помощь при раскапывании |


## Заведение production багов 

{% note warning %}

Все баги на прод мы заводим из специальной формы при создании задач: **Для QA: заведение бага на продакшн** [по этой ссылке](https://st.yandex-team.ru/createTicket?queue=DIRECT&_form=68328)

Баг должен быть заведен подробно для того, чтобы асессор/новый человек/любой коллега исходя из описания мог его протестировать. 
Подробная инструкция про тестирование тикетов асессорами и заведение багов живет [на вики](https://wiki.yandex-team.ru/users/sonch/asessory-strajjk/asessory-na-relizy-direkta/#podgotovkatiketadelaetqazadachi)

{% endnote %}

### Production баги и приоритеты

- **Critical/Blocker** - завести баг в очередь DIRECT, обязательно **показать дежурному по поддержке**
- **Normal** - завести баг в очередь DIRECT и:
   - **показать менеджеру** отвечающему за соответствующую область, и уточнить у него приоритет,
   - либо **показать дежурному по поддержке** 
(это может быть некритичная, но массовая проблема, поломка в области связанной с финансами, юридической информацией, статистикой)
- **Minor** - завести баг в очередь DIRECT, дополнительно уведомлять кого-либо о баге не обязательно

**Кому из менеджеров какие баги нести:**
- [anyksenya@](https://staff.yandex-team.ru/anyksenya) — мастер кампаний
- [dmsuvorov@](https://staff.yandex-team.ru/dmsuvorov) — проф кабинет и все что не попало к другим
- [ulyashevda@](https://staff.yandex-team.ru/ulyashevda) — смарт, до
- [dmsuvorov@](https://staff.yandex-team.ru/dmsuvorov) — охватные, банана
- [aogay@](https://staff.yandex-team.ru/aogay) — стратегии, цели, метрика, фразы, синонимы
