{% include [links](_includes/links.md) %}

# Как протестировать новые данные в выгрузке

## Локально или на бете { #tesing-local-or-on-beta }
Чтобы проверить запрос локально или на бете, нужно запустить джобу с названием кластера в параметрах.
Пример аргументов для программы `DebugJobRunner`: `HomeDirectDbOperationsJob --param ARNOLD`.

Очень важно перед этим указать название таблицы в ppc_property `HOME_DIRECT_DB_INCLUDE` через
[интерфейс ограниченного редактирования](https://8080.beta1.direct.yandex.ru/internal_tools/#set_typed_ppc_property),
иначе джоба запустит все запросы, и это будет очень долго работать.

Джоба сгенерирует заголовок к вашему запросу из файла `include/common.yql` и запустит полученный запрос с указанием
сегодняшнего продакшенового снепшота mysql-sync в качестве входных данных, и вашу личную YT директорию для выходных данных.

Джоба не будет дожидаться окончания запроса, а просто запишет его метаданные в дин. таблицу `operations` в вашей личной
директории. А за ходом выполнения вы сможете следить в интерфейсе YQL.

## На ТС и devtest { #tesing-on-ts-or-devtest }

На ТС и devtest джобы зашедулены так же, как и на проде, но с тем исключением,
что с целью экономии ресурсов фактической работы и запуска запросов они не осуществляют
(в основном работают в режиме "dry run").

Для того, чтобы полноценно их протестировать надо:
1. выставить в ppc_property у флага `HOME_DIRECT_DB_FULL_WORK` значение `true`,
джобы начнут работать по расписанию в режиме, как на проде
2. убедиться, что все работает, запросы выполняются, результат ожидаемый и тд
3. вернуть флаг `HOME_DIRECT_DB_FULL_WORK` обратно в `false` (если вы забыли про это, то по истечению определенного
времени это произойдет автоматически, но лучше не полагаться на автоматику и выставлять флаг самим).

Альтернативным вариантом является [запуск джобы по кнопке](https://test.direct.yandex.ru/internal_tools/#hourglass_run_job_tool).
Позволяет не ждать запуска по расписанию, но для проверки полного сценария может потребоваться
нажатие на нее несколько раз.
`HOME_DIRECT_DB_FULL_WORK` так же должна быть выставлена в `true`.

{% note info %}

Стоит отметить, что джоба `HomeDirectDbResamplingJob` удаляет старые таблицы с выгрузками всегда, вне зависимости от
флага `HOME_DIRECT_DB_FULL_WORK`, но производит архивацию только с ним.

{% endnote %}
