#!/usr/bin/perl
use strict;
use warnings;
use App::Switchman;

my $filter_re = shift;
my $sw = App::Switchman->new([@ARGV, "fake_cmd"]);
$sw->zk_connect();
my @locks = get_locks($sw, $filter_re);

print join "\n", @locks;
print "\n" if @locks;

exit 1 if not @locks;

sub get_locks {
    my ($self, $filter_re) = @_;
    my @children = $self->zkh->get_children(join '/', $self->prefix, $App::Switchman::LOCKS_PATH);
    return map { s|$filter_re||; $_ } @children;
}
