#!/usr/bin/perl

use strict;
use Config::General qw(ParseConfig);

my $config_file = "/home/monitor/agents/etc/memory_check.conf";
my $memory_orig;

if ( -f $config_file ) {
    my %config = ParseConfig(-ConfigFile => $config_file);
    $memory_orig = defined($config{"memory"}) ? $config{"memory"} : define_memory();
} else {
    $memory_orig = define_memory();
}

my $mem = mem_info();

if ($mem < $memory_orig) {
  mexit(2, "Failed memory detected!");
}

mexit(0, "Memory OK");

# Exit correctly
sub mexit {
  my ($status, $msg) = @_;
  $msg = substr($msg, 0, 1024);
  print "PASSIVE-CHECK:memory_check;$status;$msg\n";
  exit(0);
}

sub mem_info {
    my $memory;
    my $memory_fh;
    open $memory_fh, '<', '/proc/meminfo' or mexit(2, "Can't open meminfo");
    while (<$memory_fh>) {
            chomp;
            $memory = $_;
            if ($memory =~ m/^MemTotal:\s+(\d+)/) {
                    $memory = $1;
                    last;
            }
    }
    close $memory_fh;

    return sprintf("%.0f", $memory / 1000 / 1000);
}

sub define_memory {
    my $amount = mem_info();
    my $config_fh;
    open $config_fh, '>', $config_file or mexit(2, "Can't open config");
    print $config_fh "memory = " . $amount . "\n";
    close $config_fh;
    return $amount;
}

