#!/usr/bin/env perl
use strict;
use warnings;

my %MTU = (4 => 1450, 6 => 8500);
my %HEADER_SIZE = (4 => 40, 6 => 60);

my $apply = ($ARGV[0] // '') eq '--apply';

fix_main_default(4, $apply);
print "\n";
fix_main_default(6, $apply);

sub fix_main_default {
    my ($ip_ver, $apply) = @_;
    # может быть несколько!
    #default via 2a02:6b8:0:1448::1 dev eth0  metric 1024  mtu 1450 advmss 1390
    #default via fe80::1 dev eth0  proto ra  metric 1024  expires 23sec hoplimit 64
    # '' on v6-only hosts
    my $defaults = qx(ip -$ip_ver route show table main default);
    chomp $defaults;
 
    if (!$defaults) {
        print "v$ip_ver: no routes, ignoring\n";
        return;
    }
    my @routes = grep { /\bdefault\b/ } grep { ! /\bexpires\b|\bproto\s+ra\b|\bip_ext_tun0\b|\btun0\b/ } split /\n/, $defaults;
    if (scalar(@routes) != 1) {
        printf "v$ip_ver: bad default routes:\n%s\nignoring\n", join('\n', @routes);
        return;
    }

    print "v$ip_ver current default: $routes[0]\n";

    my ($dev) = ($routes[0] =~ /\bdev\s+(\S+)/);
    my $dev_str = qx(ip -$ip_ver link show dev $dev);
    chomp $dev_str;
    my ($dev_mtu) = ($dev_str =~ /\bmtu\s+(\d+)/);
    if (!$dev_mtu) {
        $dev //= 'undef';
        print qq(v$ip_ver: can't get mtu for iface "$dev": $dev_str\n);
        return;
    }

    my $fixed_route = $routes[0];
    $fixed_route =~ s/\smtu\s+\d+//;
    $fixed_route =~ s/\sadvmss\s+\d+//;

    my $mtu = $MTU{$ip_ver};
    $mtu = $dev_mtu if $mtu > $dev_mtu;
    my $advmss = $mtu - $HEADER_SIZE{$ip_ver};

    $fixed_route .= " mtu $mtu advmss $advmss";
    if ($fixed_route eq $routes[0]) {
        print "v$ip_ver: default already fixed, ignoring\n";
        return;
    }

    print "v$ip_ver: new default   : $fixed_route\n";
    my $cmd = 'ip -6 route replace table main ' . $fixed_route;
    print "v$ip_ver: " . ($apply ? 'executing' : 'use --apply to execute ') . " cmd: $cmd\n";
    system($cmd) if $apply;
}
