#!/usr/bin/python
# -*- encoding: utf-8 -*- 

import argparse
import os
import subprocess

HOST_KEYS = [
        "/etc/ssh/ssh_host_rsa_key",
        "/etc/ssh/ssh_host_dsa_key",
        "/etc/ssh/ssh_host_ecdsa_key",
        "/etc/ssh/ssh_host_ed25519_key"
]

GENERATE_HOST_KEYS = "/usr/bin/ssh-keygen -A"
SSHD_RESTART = "/etc/init.d/ssh restart"
USAGE = "Программа восстанавливает ssh host ключи в /etc/ssh."

#Если один ключ есть, то ничего не генерируем
def check_any_exist_key(host_keys):
    for key in host_keys:
        if os.path.exists(key):
            return True, key
    return False, ""

def execute(command, debug=False):
    cmd = command.split(" ")
    proc = subprocess.Popen(cmd, stdout=subprocess.PIPE, stderr=subprocess.PIPE)
    out, err = proc.communicate()
    if debug:
        print "run command: '{0}', stdout: {1}, stderr: {2}, exit_code: {3}".format(command, out.strip(), err.strip(), proc.returncode)
    errmsg = "execute code {0} command '{1}': {2}".format(proc.returncode, command, err.strip())
    return errmsg, proc.returncode

def run():
    parser = argparse.ArgumentParser(description=USAGE)
    parser.add_argument('-d', '--debug', action='store_true', dest='debug',
            help="вывод отладочной информации")
    parser.add_argument('--doit', action='store_true', dest='doit',
            help="запустить исправление недостающих ключей")
    args = parser.parse_args()

    ok, keyname = check_any_exist_key(HOST_KEYS)
    if ok:
        if args.debug:
            print "Найден хост ключ в {0}. Генерация не требуется.".format(keyname)
        os._exit(0)
    else:
        print "Не найден ни один ключ: {0}".format(HOST_KEYS)
    if args.doit:
        print "Генерация хост ключей"
        errmsg, code = execute(GENERATE_HOST_KEYS, args.debug)
        if code != 0:
            print errmsg
            os._exit(1)
        err, code = execute(SSHD_RESTART, args.debug)
        if code != 0:
            print errmsg
            os._exit(2)

if __name__ == '__main__':
    run()
