#!/usr/bin/env python
import os
import dns.resolver
import subprocess

def resolver(dnsname, types):
    result = list()
    rr = dns.resolver.Resolver()
    try:
        for rdata in rr.query(dnsname, types):
            result.append(rdata.address)
    except Exception as err:
        pass
    return result
            
def run():

    ips = list()

    # ignore if the server dont have LXC
    if not os.path.exists('/etc/lxc'):
        return ips
    
    list_containers = subprocess.check_output(["sudo", "-u", "root", "lxc-ls"]).split()

    # empty list if not found running LXC containers
    if len(list_containers) == 0:
        return ips

    # aggregate ip addresses lxc containers
    [ips.extend(resolver(name, i)) for name in list_containers 
                                   for i in ['A', 'AAAA']]
    return set(ips)

if __name__ == '__main__':
    print run()
