#!/bin/sh
check_name=${0##*/}
check_name=${check_name%.sh}
check_type="PASSIVE-CHECK"
check_status="0"
check_msg=""

for eth_path in /sys/class/net/eth*; do
    SPEED=`cat $eth_path/operstate | grep -q up && cat $eth_path/speed 2> /dev/null`
    INTERFACE=${eth_path##*/}
    if [ ! -z $SPEED ]; then
        echo $SPEED | grep -vE '(1000)|(10000)' 2>/dev/null 1>&2 && check_status="2"; check_msg="${INTERFACE}_speed=${SPEED} $check_msg";
    fi
done
if [ -z "$check_msg" ]; then 
    check_msg="OK"
fi
echo "${check_type}:${check_name};${check_status}; ${check_msg}"
exit 0

