#!/usr/bin/perl

use strict;
use warnings;

use utf8;

use open ':std' => ':encoding(UTF-8)';

use File::Slurp qw/read_file/;

my $DEFAULT_THRESHOLD = '85%';
my $threshold_file = '/etc/monitoring/mem_used.conf';
(my $threshold_str = eval {read_file($threshold_file)} // $DEFAULT_THRESHOLD ) =~ s/(^\s+|\s+$)//g;
my $threshold_str_re = '^[0-9]{1,2}%$';
if ($threshold_str !~ /$threshold_str_re/) {
    print "2;incorrect threshold setting '$threshold_str', must match regexp '$threshold_str_re'\n";
    exit 0;
}
my %h = (read_file("/proc/meminfo") =~ /^(MemTotal|MemAvailable):\s*([0-9]+)/mg);
my $avail_percent = int(($h{MemAvailable} / $h{MemTotal}) * 100.0);
my $used_percent = 100 - $avail_percent;
(my $threshold_percent = $threshold_str) =~ s/%$//;
if ($used_percent > $threshold_percent) {
    print "2; $avail_percent% memory available\n";
} else {
    print "0; OK\n";
}
exit 0;
