#!/usr/bin/env python
# -*- encoding: utf-8 *-*
'''
  Скрипт проверяет mtu на основе маршрута до любого сервиса.
'''

import optparse
import subprocess
import re
import sys
import unittest

EXCLUDE_DEVICES = ['eth0', 'eth1']
IP = '2a00:1450:4010:c0b::71' #проверяем внешний ip(тут гугловый), т.к. mtu нам важно для внешки и есть отдельный маршрут до внутренних
GOOD_MTU = 8500

test = (
        ('2a02:6b8:0:3400:0:a9:0:3 from :: via 2a02:6b8:0:1604::1 dev eth0  '+
            'src 2a02:6b8:0:1604:3f54:640b:916:f8ac  metric 1024  mtu 8900 advmss 8840', 
                {'advmss': '8840',
                'dest_mask': '2a02:6b8:0:3400:0:a9:0:3',
                'device': 'eth0',
                'gate_ip': '2a02:6b8:0:1604::1',
                'metric': '1024',
                'mtu': '8900'}
        ),
        ('2a02:6b8::/32 via 2a02:6b8:0:1604::1 dev eth0  metric 1024  mtu 8900 advmss 8840',
                {'advmss': '8840',
                 'dest_mask': '2a02:6b8::/32',
                 'device': 'eth0',
                 'gate_ip': '2a02:6b8:0:1604::1',
                 'metric': '1024',
                 'mtu': '8900'}
        ),
        ('2a02:6b8:0:3400:0:a9:0:3 from :: via 2a02:6b8:0:1448::1 dev eth0  '+
            'src 2a02:6b8:0:1448:1c1d:2a94:b1e9:193  metric 0 \n    cache  mtu 8900 advmss 8840',
                {'advmss': '8840',
                'dest_mask': '2a02:6b8:0:3400:0:a9:0:3',
                'device': 'eth0',
                'gate_ip': '2a02:6b8:0:1448::1',
                'metric': '0',
                'mtu': '8900'}
        )
)


class Test(unittest.TestCase):
    def test_parse(self):
        for i, j in test:
            self.assertEqual(parse(i), j)

def run(check_ip, check_mtu):
    getRoute = lambda z: '/sbin/ip -6 ro get {0}'.format(z)
    try:
        result = parse(subprocess.check_output(getRoute(check_ip), shell=True))
    except Exception as err:
        print '2; error parse route for {1}: {0}'.format(err, check_ip)
    else:
        mtu = int(result.get('mtu'))
        device = result.get('device', '')
        if ((mtu > check_mtu) and (device not in EXCLUDE_DEVICES)):
            print '2; big route mtu in device {1} ({0} vs {2})'.format(mtu, device, check_mtu)
        elif (device in EXCLUDE_DEVICES):
            print '0; ignore check mtu in device {0}'.format(device)
        else:
            print '0; good route mtu in device {1}: ({0} vs {2})'.format(mtu, device, check_mtu)
    return

def parse(line):
    result, error = {}, ''
    rgxp = re.compile('(?P<dest_mask>\S+).*\s+via\s+(?P<gate_ip>\S+)\s+dev\s+'+
            '(?P<device>\w+).*\s+metric\s+(?P<metric>\d+)\s+.*\s+mtu\s+(?P<mtu>\d+)\s+(advmss\s+(?P<advmss>\d+))?\s*')
    result = rgxp.match(line).groupdict()
    return result

if __name__ == '__main__':
    parser = optparse.OptionParser()
    parser.add_option( "-t", "--run-test", action="store_true", dest="test",
            help="проверить скрипт на наличие ошибок")
    parser.add_option( "--ip", action="store", dest="check_ip", default=IP,
            help="ip адресс до которого проверять mtu")
    parser.add_option( "--mtu", action="store", dest="check_mtu", default=GOOD_MTU,
            help="максимальный mtu, считающийся хорошим")
    (opts, args) = parser.parse_args()
    if opts.test:
        sys.argv[1:] = args
        unittest.main()
    else:
        run(opts.check_ip, int(opts.check_mtu))
