#!/usr/bin/python
# -*- coding: utf-8 -*-
# vim: set expandtab:tabstop=4:softtabstop=4:shiftwidth=4:nowrap
# $Id$

import argparse
import json
import subprocess
import sys
import yaml

def run():
    real_hostname = subprocess.check_output(['hostname', '-f']).rstrip()
    parser = argparse.ArgumentParser()
    parser.add_argument('--groups-dict', required=True, help=u'файл с json вида {<группа>: [<список хостов>, ...]}')
    parser.add_argument('--vhosts-config', default='/etc/yandex-direct/direct-vhosts.yaml', help=u'конфиг с vhost-ами (по умолчанию /etc/yandex-direct/direct-vhosts.yaml)')
    parser.add_argument('--hostname', default=real_hostname)
    args = parser.parse_args()
    groups_dict_file = args.groups_dict
    vhosts_config_file = args.vhosts_config
    my_hostname = args.hostname
    groups = json.load(open(groups_dict_file, 'r'))
    vhosts = yaml.load(open(vhosts_config_file, 'r'))['vhosts']
    my_groups = set(g for g in groups if my_hostname in groups[g])
    my_vhosts = [ h for h in vhosts if ('endpoints' in vhosts[h]) and ((('conductor_groups' in vhosts[h]['endpoints']) and my_groups & set(vhosts[h]['endpoints']['conductor_groups'])) or (('hosts' in vhosts[h]['endpoints']) and (my_hostname in vhosts[h]['endpoints']['hosts']))) ]
    if len(my_vhosts) == 1:
        print my_vhosts[0]
    elif len(my_vhosts) > 1:
        sys.stderr.write('error: more than one vhost for host ' + host + ': ' + ', '.join(my_vhosts))
        sys.exit(2)
    else:
        sys.exit(1)

if __name__ == '__main__':
    run()

