#!/bin/sh
# vim: set expandtab:tabstop=4:softtabstop=4:shiftwidth=4:nowrap

# Скрипт для привоза роботного ключа для direct_sync_binlog_yt, который нельзя перезапустить просто так для применения новых настроек в няне.
# Задуман как временное решение до момента, когда мы всё-таки перезапустим сервисы direct_sync_binlog_yt*. После этого можно удалить и ресурс 727243999 в sandbox.
# Динамический ресурс не годится, т. к. может неожиданно привести к перезапуску контейнера и неизвестно, как понять это заблаговременно.
# Скрипт предполагает минимальное количество производимых им изменений -- только на сервисе, где это действительно нужно, только один файл и только если его ещё нет (в штатном режиме только один раз за время жизни контейнера). Некоторые команды избыточны, чтобы уменьшить контекст.

#set -x
KEYFILE="ssh-rsa_robot-direct-yav-p"
if [ -e "/etc/direct-tokens/$KEYFILE" ]; then
    exit 0
fi
tempdir="$(mktemp -d "/tmp/get-yav-key.XXXXXX")"
container_cwd="$(portoctl get self | awk '/^cwd = / {print $3;exit}')"
set -e
portoctl get self | grep -q direct_sync_binlog_yt
test -n "$tempdir"
test -n "$container_cwd"
cd "$tempdir"
umask 0277
set +e
curl -s 'https://proxy.sandbox.yandex-team.ru/727243999' > secrets.tar.des3
openssl enc -d -des3 -salt -kfile "$container_cwd/crypt-key/token" -in secrets.tar.des3 -out secrets.tar
tar -f secrets.tar -x "./$KEYFILE"
chmod 0400 "./$KEYFILE"
mv --no-clobber "./$KEYFILE" "/etc/direct-tokens/$KEYFILE"
rm -f secrets.tar
rm -f "./$KEYFILE"
rm -f secrets.tar.des3
rmdir "$tempdir"
#set +x
