#!/usr/bin/env python
# coding: utf-8
import yaml, json, sys
import socket
import requests

def get_my_cgroups():
    hostname = socket.getfqdn()
    resp = requests.get('http://c.yandex-team.ru/api/hosts2groups/%s?format=json' % hostname).json()
    resp = [ x['name'] for x in resp ]
    return resp


def get_my_vhosts(conf):
    my_vhosts = []
    my_cgroups = set(get_my_cgroups())
    for vhost, vhost_conf in conf['vhosts'].items():
        cgroups = set(vhost_conf.get('endpoints', {}).get('conductor_groups', []))
        if cgroups & my_cgroups:
            my_vhosts.append(vhost) 

    return my_vhosts


def get_vhost_from_file(dest):
    with open(dest) as f:
        for line in f:
            line = line.strip()
            if line.startswith('default'):
                return line.split()[-1][:-1] # default direct.yandex.ru; - берем direct и убираем ; в конце vhost
    return "none"


def check_my_vhosts():
    with open('/etc/yandex-direct/direct-vhosts.yaml') as f:
        conf = yaml.load(f)

    for vhost in get_my_vhosts(conf):
        if not 'logpusher_vhost_file' in conf['vhosts'][vhost]:
            continue

        dest = conf['vhosts'][vhost]['logpusher_vhost_file']
        cur_vhost = get_vhost_from_file(dest)

        if cur_vhost != vhost:
            print '2;vhost %s in file %s differs from %s - selected vhost for this server' % (cur_vhost, dest, vhost)
            return

    print '0;OK'


if __name__ == '__main__':
    check_my_vhosts()
