#!/usr/bin/python

from flask import Flask, url_for

from flask import render_template, send_file, after_this_request, request, Blueprint
import tempfile
import subprocess
import os
import re

app = Flask(__name__, template_folder='templates')

@app.route('/')
def index():
    return 'Index Page'

@app.route('/map-svg')
def map_svg():
    args = request.args.to_dict(flat=False)
    tags_raw = args['tags'] if 'tags' in args else []
    tags = parse_tags(tags_raw)

    with tempfile.NamedTemporaryFile(delete=False, suffix='.svg') as tmpfile:
        to_run = ['./bin/adv-draw-graph.py', 'data/direct/direct.yaml', '-c', 'colors.yaml', '-o', tmpfile.name]
        for t in tags:
            to_run.extend(['--include-tag', t])
        subprocess.call(to_run)

    @after_this_request
    def cleanup(response):
        os.remove(tmpfile.name)
        return response

    return send_file(tmpfile.name, cache_timeout=5, mimetype='image/svg+xml')


@app.route('/map')
def map():
    args = request.args.to_dict(flat=False)
    tags_raw = args['tags'] if 'tags' in args else []
    tags = parse_tags(tags_raw)
    return render_template('map.html', tags=tags, tags_all=['all', 'ess', 'storage', 'main'])


def parse_tags(tags_raw):
    tags = []
    for t in tags_raw:
        tags.extend(re.split("[^a-zA_Z0-9_\-]+", t))
    return tags


if __name__ == '__main__':
    app.debug = True
    app.run(port=5002)

