package ProcessResult;

use strict;
use warnings;

use Base;
use Data::Dumper;
use YAML::Syck;
use JSON;

sub process_result_by_cmd($$$)
{    
    my %REQ = @_;
#    warn Dumper {REQ => \%REQ};
    my ($cmd, $result, $soap_options, $request, $custom) = ($REQ{cmd}, $REQ{result}, $REQ{options}, $REQ{request}, $REQ{custom_options});

    if ($cmd eq 'GetBanners' && $custom->{GetAndUpdate}) {
        
        # $result->[0]{CampaignID} = 8381729;
        # $result->[0]{AdGroupID} = 0;
        # $result->[0]{BannerID} = 0;
        # $result->[0]{Title} .= " 1";
        
        if ($result->[0]{Title} =~ /\s1$/) {
            $result->[0]{Title} =~ s/\s1$//;
        } else {
            $result->[0]{Title} .= " 1";
        }

        $result->[0]{AgeLabel} = '3months';
        
        my $result2 = Base::call(url => $REQ{url}
                                    , cmd => "CreateOrUpdateBanners"
                                    , request => $result
                                    , headers => $REQ{headers}
                                    , options => $soap_options
                                    , custom_options => $custom);

        print YAML::Syck::Dump($result2);
    } else {
        print YAML::Syck::Dump($result);
    }
    
    return;
    
    # нужно порефакторить вызовы
    
    if ($cmd eq 'CreateNewForecast') {
        while ( 1 ) {
            print "\nSleep(5) ...\n\n";
            sleep(5);
            
            my $list = call_method('GetForecastList', undef, $soap_options);
            my $cnt = grep {$_->{StatusForecast} eq 'Done' && $_->{ForecastID} == $result} @$list;

            if ($cnt) {
                my $res = call_method('GetForecast', $result);
                if ($res) {
                    print YAML::Syck::Dump($res);
                    last;
                }
            } else {
                warn Dumper {list => $list};
            }
        }
    } elsif ($cmd eq '^GetCampaignsParams$' || $cmd =~ '^GetCampaignsList(?:Filter)?$') {
        foreach my $r (@$result) {
            $r->{TimeTarget} = to_json($r->{TimeTarget});
        }
        print to_json($result)."\n";

    } elsif ($cmd eq 'CreateNewReport') {

        my $reportInfo;
        my $counter = 0;
        
        my $ilist = call_method('GetReportList', undef, $soap_options);
        print "ReportID: $result\n";

        # ждем пока отчет будет создан
        while ((!$reportInfo || $reportInfo->{StatusReport} ne 'Done')
                    && $counter++ < 20) {
            print "Sleep(10) ...\n\n";
            sleep(10);
            my $list = call_method('GetReportList', $result, $soap_options);
            if (@$list) {
                ($reportInfo) = grep {$_->{ReportID} == $result && $_->{StatusReport} eq 'Done'} @$list;
                
                if (! $reportInfo) {
                    print Dumper {list => $list};
                }
            }
        }

        if ($reportInfo->{Url}) {
            
            # выводим отчет в STDOUT
            print "Report url: $reportInfo->{url}\n";
            print "Get report file:\n";
            print get_report( $reportInfo->{Url} );
            print "\n";
            
            sleep(3);
            my $res3 = call_method('DeleteReport', $reportInfo->{ReportID}, $soap_options);
            print $res3;
            
        } elsif( $counter > 20 ) {
            die "Превышено допустимое количество обращений";
        } else {
            die "Неизвестная ошибка";
        }

    } elsif ($cmd eq 'GetRubrics') {
    
        my $catalog_tree = {};
        foreach my $i (@$result) {
            $catalog_tree->{ $i->{RubricID} } = $i;
        }
        
        print "Get ".scalar(keys(%$catalog_tree))." rubrics\n";
        
        foreach my $r (keys %$catalog_tree) {
            if ($catalog_tree->{$r}{ParentID} && ! defined $catalog_tree->{ $catalog_tree->{$r}{ParentID} }) {
                die "Not exists parent rubric with RubricID = ".$catalog_tree->{$r}{ParentID};
            }
        }
        
        foreach my $r (keys %$catalog_tree) {
            foreach my $f (qw/RubricID RubricName RubricFullName ParentID Url/) {
                my $suffix = $f eq 'ParentID' ? 
                        " (".$catalog_tree->{ $catalog_tree->{$r}{ParentID} }{RubricFullName}.") "
                        : "";
                my $prefix = $f eq 'RubricID' ? "" : "\t";
                
                print "$prefix $f:\t".Encode::encode_utf8($catalog_tree->{$r}{$f} . $suffix)."\n" if defined $catalog_tree->{$r}{$f};
            }
            
            print "---\n";
        }

    
    } elsif ($cmd eq 'GetCampaignsList' && $soap_options->{short}) {
        foreach my $i (@$result) {
            print Encode::encode_utf8("$i->{CampaignID} - $i->{Name}"), "\n";
        }
    } elsif ($cmd eq 'GetCampaignsSpecialStat') {

        foreach my $line (split /[\n\r]+/, $result) {
            my @stat = split /\t/, $line;
            print "Clicks: ".$stat[9]."\n";
        }
    } elsif ($cmd eq 'GetBanners' && $soap_options->{ReUpdate}) {
        
        # ($cmd, $result, $soap_options)
    
    } else {
        print YAML::Syck::Dump($result);
        #print Dumper {api_test_client_result => $result};
    }
}

=head2 short_info_about_result(result)

    Возвращает краткую информацию о переданном параметре

=cut

sub short_info_about_result
{
    my $result = shift;

    if (ref($result) =~ /ARRAY/i) {
        return "ARRAY: count items = ".scalar(@$result);
    } else {
        return (ref($result) || "SCALAR");
    }

}

1;
