
package RequestParams;

use strict;
use warnings;

use utf8;

use Encode qw/encode_utf8 decode_utf8/;
use Data::Dumper;
use Yandex::TimeCommon qw/today/;
use JSON;

use JSON;

{   # необходимо для работы хака с JSON, который ломает SOAP
    # передается из api.pl
    my $METHOD;
    sub set_method {
        $METHOD = shift;
    }

    sub method {
        return $METHOD;
    }
}

sub CreateNewReport
{
    my %opt = @_;
    
    return {
        CampaignID => $opt{cid},
        StartDate => $opt{param} || $opt{start_date} || today(),
        EndDate => $opt{param2} || $opt{end_date} || today(),

        GroupByDate => $opt{group_by_date} || 'day',
        GroupByColumns => s2arr($opt{group_by_columns} || 'clDate,clBanner,clPhrase'),

        Filters => {
            Banner => $opt{filters_banner} ? s2arr($opt{filters_banner}) : undef,
            Phrase => $opt{filters_phrase} ? s2arr($opt{filters_phrase}) : undef,
            PageType => $opt{filters_page_type} ? s2arr($opt{filters_page_type}) : undef,
        }
    };
}

sub PingAPI
{
    my %OPT = @_;

    return undef;
}

sub opt2req
{
    my $opt = shift;

    my $req = {};
    foreach my $k (keys %$opt) {
        my @path = split /__/, $k;
        my $link = $req;
        my $cnt=1;
        my $val = $opt->{$k} && $opt->{$k} =~ /^\[(.*?)\]$/ ? s2arr($1) : $opt->{$k};

        foreach my $key_name (@path) {
            # увеличиваем первую букву каждого слова
            $key_name =~ s/(?:(?:^|\_)(\w))+/\u\L$1/g;

            # идем по веткам структуры и присваиваем значение последней
            $link = $link->{ $key_name } = ++$cnt == scalar(@path) ? {} : $val;
        }
    }

    return $req;
}

sub s2arr
{
    my $string = $_[0];

    if (defined $string) {
        return [split(/\s*,\s*/, $string)];
    }
    
    return undef;
}

sub get_request_data_by_params
{
    my %OPT = @_;

    my $call_params;

    # getting data from RequestParams method only if json_params
    # unspecified
    if ($OPT{json_params}) {
        $call_params = method() eq 'json'
            ? from_json(decode_utf8($OPT{json_params}), utf8 => 1)
            : from_json($OPT{json_params});
    } elsif ($OPT{null_value}) {
        $call_params = undef;
    } elsif ($OPT{empty_array}) {
        $call_params = [];
    } elsif ($OPT{empty_hash}) {
        $call_params = {};
    } elsif ($OPT{empty_string}) {
        $call_params = '';
    } else {
        $call_params = RequestParams->can($OPT{cmd})
            ? RequestParams->can($OPT{cmd})->(%OPT)
            : die "Unknown method while json_params, "
                . "null_value, empty_array, empty_hash, empty_string "
                . "all unspecified";
    }

    return $call_params;
}

sub StopBanners
{
    my %OPT = @_;
    
    return {
        CampaignID => $OPT{cid}
        , BannerIDS => [split /\s*,\s*/, $OPT{bid}]
    };
}

sub ResumeBanners
{
    my %OPT = @_;
    
    return {
        CampaignID => $OPT{cid}
        , BannerIDS => [split /\s*,\s*/, $OPT{bid}]
    };
}

sub ArchiveBanners
{
    my %OPT = @_;
    
    return {
        CampaignID => $OPT{cid}
        , BannerIDS => [split /\s*,\s*/, $OPT{bid}]
    };
}

sub UnArchiveBanners
{
    my %OPT = @_;
    
    return {
        CampaignID => $OPT{cid}
        , BannerIDS => [split /\s*,\s*/, $OPT{bid}]
    };
}

sub GetReportList
{
    return undef;
}
    
sub DeleteReport
{
    my %OPT = @_;
    
    return $OPT{param};
}

sub GetRegions
{
    return undef;
}

sub GetRubrics
{
    return undef;
}

sub GetBanners
{
    my %OPT = @_;
    
    return {
        BannerIDS => [split /\s*,\s*/, $OPT{bid}],
        CampaignIDS => $OPT{cid} ? [split /\s*,\s*/, $OPT{cid}] : undef,
        # Filter => {
            #StatusBannerModerate => ["Yes", "No", "PreliminaryAccept", "New"]
            # , StatusPhrasesModerate => "",
        # },
        GetPhrases => $OPT{param},
        Currency => $OPT{Currency},
    };
}

sub GetVersion
{
    return undef;
}

sub CreateNewForecast
{
    my %OPT = @_;
    
    return {
        Phrases => $OPT{param} ? [split /\s*,\s*/, $OPT{param}] : undef,
        GeoID => $OPT{param2} ? [split /\s*,\s*/, $OPT{param2}] : undef,
        Categories => $OPT{Rubrics} ? [split /\s*,\s*/, $OPT{Rubrics}] : undef,
        Currency => $OPT{Currency},
    };
}

sub GetForecastSync
{
    my %OPT = @_;
    
    return {
        Phrases => $OPT{param} ? [split /\s*,\s*/, $OPT{param}] : undef,
        GeoID => $OPT{param2} ? [split /\s*,\s*/, $OPT{param2}] : undef,
        Categories => $OPT{Rubrics} ? [split /\s*,\s*/, $OPT{Rubrics}] : undef,
        Currency => $OPT{Currency},
    };
}

sub GetForecastList
{
    return undef;
}

sub GetWordstatReportList
{
    return undef;
}

sub GetForecast
{
    my %OPT = @_;
    
    return $OPT{param};
}

sub DeleteForecastReport
{
    my %OPT = @_;
    
    return $OPT{param};
}

sub UpdatePrices
{
    my %OPT = @_;
    
    return [{
        PhraseID => $OPT{PhraseID} || $OPT{bid},
        AutoBroker => $OPT{Autobroker} || 'Yes',
        Price => $OPT{Price} || $OPT{param},
        ContextPrice => $OPT{ContextPrice} || $OPT{param2},
        AutoBudgetPriority => $OPT{AutoBudgetPriority},
        Currency => $OPT{Currency},
    }];
}
    
sub GetClientInfo
{
    my %OPT = @_;
    
    return $OPT{ulogin} ? [split /\s*,\s*/, $OPT{ulogin}] : undef;
}

sub GetBalance
{
    my %OPT = @_;
    
    return $OPT{cid} ? [split /\s*,\s*/, $OPT{cid}] : undef;
}

sub GetBannersList
{
    my %OPT = @_;
    
    return $OPT{cid} ? [split /\s*,\s*/, $OPT{cid}] : undef;
}

sub GetClientsList
{
    return undef;
}
    
sub GetBannerPhrases
{
    my %OPT = @_;
    
    return $OPT{bid} ? [split /\s*,\s*/, $OPT{bid}] : undef;
}

sub GetBannerPhrasesFilter
{
    my %OPT = @_;
    
    return {
        BannerIDS => $OPT{bid} ? [split /\s*,\s*/, $OPT{bid}] : undef
        , CampaignIDS => $OPT{cid} ? [split /\s*,\s*/, $OPT{cid}] : undef
        , ConsiderTimeTarget => $OPT{param}
        , FieldsNames => $OPT{param2} ? [split /\s*,\s*/, $OPT{param2}] : undef
        , Currency => $OPT{Currency}
     };
}

sub GetCampaignsList
{
    my %OPT = @_;
    
    return $OPT{ulogin} ? [split /\s*,\s*/, $OPT{ulogin}] : undef;
}

sub GetWordstatReport
{ 
    my %OPT = @_;
    
    return $OPT{param};
}

sub GetCampaignsListFilter
{
    my %OPT = @_;
    
    return {
        Logins => $OPT{ulogin} ? [split /\s*,\s*/, $OPT{ulogin}] : undef
        , Currency => $OPT{Currency}
#        , Filter => {
#             StatusArchive => ['Yes'],
#             IsActive => ['Yes', 'No']
#         }
    };
}
    
sub StopCampaign
{
    my %OPT = @_;
    
    return {CampaignID => $OPT{cid}};
}

sub ResumeCampaign
{
    my %OPT = @_;

    return undef unless $OPT{cid};
    return {CampaignID => $OPT{cid} };
}

sub ArchiveCampaign
{
    my %OPT = @_;

    return undef unless $OPT{cid};
    return {CampaignID => $OPT{cid} };
}

sub UnArchiveCampaign
{
    my %OPT = @_;

    return undef unless $OPT{cid};
    return {CampaignID => $OPT{cid} };
}

sub GetSubClients
{
    my %OPT = @_;
    
    return ($OPT{param} ? {Login => $OPT{param}} : undef);
}

sub ModerateBanners
{
    my %OPT = @_;
    
    return {
        CampaignID => $OPT{cid}
        , BannerIDS => $OPT{bid} ? [split /\s*,\s*/, $OPT{bid}] : undef
    };
}

sub GetClientsUnits
{
    my %OPT = @_;
    
    return $OPT{ulogin} ? [$OPT{ulogin}] : undef;
}

sub GetAvailableVersions
{
    return undef;
}

sub SetAutoPrice
{
    my %OPT = @_;

    my $wizard_mode = {
        'CampaignID' => $OPT{cid}
        , 'BannerIDS' => $OPT{bid} ? [split /\,\s*/, $OPT{bid}] : undef
        , 'PhraseIDS' => $OPT{PhraseIDS} ? [split /,/, $OPT{PhraseIDS}] : undef
        , 'Mode' => 'Wizard'
        , 'PriceBase' => 'min'
        , 'ProcBase' => 'value'
        , 'MaxPrice' => 10
        , 'Proc' => 0
        , 'UpdatePhrases' => 'Yes'
        , 'UpdateCategories' => 'Yes'
        , 'Currency' => $OPT{Currency}
        , 'BannersType' => 'All'
    };

    my $single_price_mode = {
        'CampaignID' => $OPT{cid}
        , 'BannerIDS' => $OPT{bid} ? [split /\,\s*/, $OPT{bid}] : undef
        , 'PhraseIDS' => $OPT{PhraseIDS} ? [split /,/, $OPT{PhraseIDS}] : undef
        , 'Mode' => 'SinglePrice'
        , 'SinglePrice' => $OPT{param} || $OPT{SinglePrice}
        , 'Currency' => $OPT{Currency}
        , 'BannersType' => 'All'
        , 'Price' => $OPT{Price}
        , 'ContextPrice' => $OPT{ContextPrice}
    };

    $OPT{Mode} = $OPT{param2};

    return $OPT{Mode} && $OPT{Mode} eq 'wizard' ? $wizard_mode : $single_price_mode;
}

sub GetCampaignParams
{
    my %OPT = @_;

    return undef unless $OPT{cid};
    return {CampaignID => $OPT{cid}, Currency => $OPT{Currency}};
}

sub GetCampaignsParams
{
    my %OPT = @_;
    
    return {
        CampaignIDS => $OPT{cid} ? [split /\s*,\s*/, $OPT{cid}] : undef
        , Currency => $OPT{Currency}
    };
}

sub GetTimeZones
{
    my %OPT = @_;
    
    return undef;
}

sub CreateOrUpdateBanners
{
    my %OPT = @_;
    
    my $BANNER = {
        CampaignID => $OPT{cid},
        BannerID => $OPT{bid},
        
        'Text' => $OPT{param} || 'test body_1',
        Title => $OPT{param2} || 'test title 1',
        Href => "http://ya.ru/yandsearch?p={position}&p1={param1}&p2={param2}&pt={position_type}&s={source}&st={source_type}&bm={addphrases}&kwd={keyword}",
        Geo => $OPT{Geo},

        AdGroupID => $OPT{AdGroupID},
        AdGroupName => $OPT{AdGroupName},
        MinusKeywords => $OPT{MinusKeywords} ? [split /,/, $OPT{MinusKeywords}] : undef,
        Phrases => ! $OPT{NoPhrases} ? [
            {
#                PhraseID => 0,
                Phrase => $OPT{PhraseText1} || Encode::_utf8_off("автомобили с пробегом"),
                IsRubric => 'No',
                AutoBroker => 'No',
                Price => 5,
                Currency => $OPT{Currency},
                UserParams => {
                    Param1 => 0,
                    Param2 => '%!$%$6_54-7654%$%',
                }
            },
            {
#                 PhraseID => 1,
                Phrase => "phrase test142 -w2 -w3",
                IsRubric => 'No',
                AutoBroker => 'No',
                Price => 0.01,
                Currency => $OPT{Currency},
                UserParams => {
                    Param1 => 0,
                    # Param2 => "Заказ № due" || "abc-1233",
                }
            },
             {
#                  PhraseID => 0,
                 Phrase => "10603",
                 IsRubric => 'Yes',
                 Price => 1,
             },
#             {
#                 PhraseID => 0,
#                 Phrase => "",
#                 IsRubric => 0,
#                 AutoBroker => 1,
#                 Price => 0.14,
#             },
#             {
#                 PhraseID => 3,
#                 Phrase => "10603",
#                 IsRubric => 1,
#                 AutoBroker => 1,
#                 Price => 0.14,
#             },
            {
                PhraseID => $OPT{PhraseID2},
                Phrase => $OPT{PhraseText2} || "10425",
                IsRubric => $OPT{IsRubric2} || 'Yes',
                AutoBroker => 'Yes',
                Price => $OPT{Price2} || 15.14,
                Currency => $OPT{Currency2} || $OPT{Currency},
                UserParams => {
                    Param1 => 31,
                    Param2 => "312-abc",
                }
            },
            #{
            #    Phrase => "",
            #    IsRubric => "No",
            #    Price => "1.1",
            #    PhraseId => 4,
            #    AutoBroker => "Yes",
            #    AutoBudgetPriority => "Medium",
            #}
        ] : undef,

#         ContactInfo => {
#             Apart => undef,
#             Build => 21,
#             City => ('Москва'),
#             CityCode => 499,
#             CompanyName => ('Яндекс'),
#             ContactEmail => undef,
#             ContactPerson => ('Виктория'),
#             Country => ('Россия'),
#             CountryCode => '+7',
#             ExtraMessage => 'testestestestestestsete',
#             House => 1,
#             IMClient => 'icq',
#             IMLogin => 123456712,
#             OGRN => undef,
#             Phone => '777-33-33',
#             PhoneExt => '',
#             PointOnMap => {
#                 x => 37.678515
#                 , x1 => 37.667537
#                 , x2 => 37.689491
#                 , "y" => 55.758255
#                 , y1 => 55.753615
#                 , y2 => 55.762895
#             },
#             Street => ('Самокатная'),
#             WorkTime => '0;6;9;00;18;00',
#         },

        Sitelinks => [
            { Href => "http://yandex.ru/1", Title => "title_1" },
            { Href => "http://yandex.ru/2", Title => "title_2" },
            { Href => "http://yandex.ru/3", Title => "title_3" },
        ]
    };
    
=pod
    use JSON;
    my $tmp = from_json(q|[{"BannerID":"0","Domain":"test.yandex.ru","MinusKeywords":["грузовые"],"ContactInfo":{"ExtraMessage":"Подробности о товаре. Весь текст составляет в длину ровно символов.","ContactPerson":"Тестировщик API","Street":"Пискаревский","House":"44","City":"Санкт-Петербург","CityCode":"812","ContactEmail":"at-tester@yandex-team.ru","WorkTime":"0;3;10;00;18;00;4;6;10;00;11;00","Build":"3","Phone":"123-45-67","Country":"Россия","Apart":"24","PhoneExt":"89","CompanyName":"Питер-сити","PointOnMap":{"y1":"27.587273","y":"45.72431","x2":"27.570807","x":"45.733604","y2":"45.742893","x1":"27.603739"},"CountryCode":"+7"},"Text":"Тестовое объявление, символов","Title":"Просто  зима","AdGroupID":"0","CampaignID":"7409308","Geo":"2,213,159","Phrases":[{"PhraseID":"0","Price":"0.01","AutoBroker":"No","IsRubric":"No","Phrase":"автомобили с пробегом"},{"PhraseID":"0","Price":"0.01","AutoBroker":"No","IsRubric":"Yes","Phrase":"10772"}],"Href":"test.yandex.ru","Sitelinks":[{"Href":"www.yandex.ru/?edit=1/","Title":"Настройка Яндекса"},{"Href":"www.yandex.ru/themes/?defskin=piter/","Title":"Ссылка на скин"},{"Href":"wdgt.yandex.ru/","Title":"Кабинет разработчик"}]}]|);
    $tmp->[0]{CampaignID} = $OPT{cid};
    $tmp->[0]{BannerID} = $OPT{bid};
    return $tmp;
=cut

    return [$BANNER];
}

sub CreateOrUpdateCampaign
{
    my %OPT = @_;
    
    my $CAMPAIGN = {
        'CampaignID' => $OPT{cid}, 
        'Login' => $OPT{ulogin},

        'Name' => ($OPT{param} || 'Test campaign'),
        'FIO' => ($OPT{param2} || 'Ivan Ivanov'),
        'StartDate' => today(),
        'Currency' => $OPT{Currency},

        # CampaignType => 'geo',
        # AgencyLogin => 'mirage-agency4',

    #     'AutoOptimization' => 'No',
    #         
    #     'DisabledDomains' => 'domain1.ru,domain2.ru',
    #     'DisabledIps' => '64.234.23.21',
    #                 
    #     'StatusBehavior' => 'Yes',
    #         
#          'TimeTarget' => {
#              'TimeZone' => 'Europe/Moscow',
#              'DaysHours' => [
#                  {
#                      'Hours' => [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12], 
#                      'Days' => [1, 2, 3, 4, 7],
#                      'BidCoef' => [100,80,100,80,100,80,100,80,100,80,100,80]
#                  }
#              ],        
#          },
    #     'StatusMetricaControl' => 'Yes',
    #     'ConsiderTimeTarget' => 'No',        
    #     'StatusOpenStat' => 'No',        
    #     'ContextPricePercent' => 10,
    #
    #     'ContextLimit' => 'Default',
    #     'ContextLimitSum' => 0,
#          'ContextLimit' => 'Limited',
#          'ContextLimitSum' => 80,
    #         
    #     'Autobudget' => 'Yes',          
    #     'AutobudgetSum' => 76,
    #     'AutobudgetMaxPrice' => 17,  
    # 
         'EmailNotification' => {
             'Email' => 'user@ya.ru',
             'MoneyWarningValue' => 5,
             'WarnPlaceInterval' => 15,
             'SendWarn' => 'Yes',
             #'SendAccNews' => 'Yes'        
         },
    # 
    #     'SmsNotification' => {  
    #         'MetricaSms' => 'Yes',
    #         'ModerateResultSms' => 'Yes', 
    #         'MoneyInSms' => 'Yes',
    #         'MoneyOutSms' => 'Yes',
    #         'SmsTimeFrom' => '09:15',
    #         'SmsTimeTo' => '22:15' 
    #     },
    # 
    #     'MinusKeywords' => ['keyword1', 'keyword2', 'keyword3'],
    # 
    #     'AddRelevantPhrases' => 'Yes',
    #     'RelevantPhrasesBudgetLimit' => 50
    #    , 'ShowOnPages' => ['test.ru']
        Strategy => {
            StrategyName => $OPT{SearchStrategyName} || 'HighestPosition'
            , MaxPrice => $OPT{MaxPrice} || undef
            # StrategyName => 'AverageClickPrice'
            # , WeeklySumLimit => 1000
            # , MaxPrice => 10
            # , "AveragePrice" => 1
        },
        ContextStrategy => {
            StrategyName => 'MaximumCoverage'
        },
        DayBudget => 10,
        DayBudgetShowMode => "Default",
    };

    # as new parameter it's shouldn't be wiped off from the data base
    # if it's not defined in api request
    $CAMPAIGN->{ClickTrackingEnabled} = $OPT{ClickTrackingEnabled}
        if exists $OPT{ClickTrackingEnabled};
        
    return $CAMPAIGN;
}

sub PingAPI_X
{
    return [
        {
            'IntValue' => 1,
            'DateValue' => '2008-01-01',
            'StrValue' => 'Первый элемент',
            'IntArray' => [1, 2, 3, 4],
            'StrArray' => ['Первый', 'Второй', 'Третий'],
            'StructArray' => [
                    {'Field1' => 'Значение1', 'Field2' => 1},
                    {'Field1' => 'Значение2', 'Field2' => 2}
                ],
        },
        {
            'IntValue' => 2,
            'DateValue' => '2008-12-01',
            'StrValue' => 'Второй элемент',
            'IntArray' => [5, 6, 7, 8],
            'StrArray' => ['Пятый', 'Шестой', 'Седьмой', 'Восьмой'],
            'StructArray' => [
                    {'Field1' => 'Значение3', 'Field2' => 3},
                    {'Field1' => 'Значение4', 'Field2' => 4},
                    {'Field1' => 'Значение5', 'Field2' => 5},
                ],
        }
    ];
}

sub CreateNewSubclient
{
    my %OPT = @_;
    
    return {
        Login => $OPT{ulogin},
        AgencyLogin => $OPT{param},
        Name => $OPT{Name} || 'John',
        Surname => $OPT{Surname} || 'Smith',
        LoginExists => $OPT{param2},
    };
}

sub CreateNewWordstatReport
{
    my %OPT = @_;
    
    return {
        Phrases => $OPT{Phrases} ? [split /\s*,\s*/, $OPT{Phrases}] : undef,
        GeoID   => $OPT{GeoID} ? [split /\s*,\s*/, $OPT{GeoID}] : undef,
    };
}
    
sub DeleteWordstatReport
{
    my %OPT = @_;
    
    return $OPT{param};
}

sub DeleteBanners
{
    my %OPT = @_;
    
    return { 
        CampaignID => $OPT{cid},
        BannerIDS => $OPT{bid} ? [split /\s*,\s*/, $OPT{bid}] : undef
    };
}

sub GetChanges
{
    my %OPT = @_;
    
    return {
        CampaignIDS => $OPT{cid} ? [split /,/, $OPT{cid}] : undef,
        BannerIDS => $OPT{bid} ? [split /,/, $OPT{bid}] : undef,
        Logins => $OPT{ulogin} ? [split /,/, $OPT{ulogin}] : undef,
        Timestamp => $OPT{param},
    };
}

sub DeleteCampaign
{
    my %OPT = @_;

    return {
        CampaignID => $OPT{cid}
    };
}

sub GetCampaignsSpecialStat
{
    my %OPT = @_;
    
    return {
        CampaignIDS => [split(/\s*,\s*/, $OPT{cid})]
        , StartDate => $OPT{param} || '2011-01-01'
        , EndDate => $OPT{param2} || $OPT{param} || '2011-07-01'
    };
}
    
sub GetSummaryStat
{
    my %OPT = @_;
    
    return {
        CampaignIDS => [split /\s*,\s*/, $OPT{cid}],
        , StartDate => $OPT{param} || '2011-01-01'
        , EndDate => $OPT{param2} || $OPT{param} || '2011-07-01'        
    };
}

sub GetBannersStat
{
    my %OPT = @_;

    return {
        'CampaignID' => $OPT{cid},
        'StartDate' => $OPT{param},
        'EndDate' => $OPT{param2},
        'GroupByColumns' => ['clDate', 'clPhrase', 'clBanner'],
        # 'Limit' => 10,
        # 'Offset' => 0,
        'OrderBy' => ['clDate', 'clBanner']
   };
}

sub FakeUpdateRetargetingGoals
{
    my %OPT = @_;

    return { 'ConditionID' => $OPT{param} };
}

sub FakeConvertCurrencyClient
{
    my %OPT = @_;

    return {
        'Login' => $OPT{ulogin},
        'ForceConvert' => $OPT{param},
        'TargetCurrency' => $OPT{Currency},
        'ConvertType' => $OPT{param2},
        'AddConvertCurrencyQueue' => ($OPT{param} ? 1 : 0),
   };
}

sub UpdateClientInfo
{
    my %OPT = @_;

    return [{
        "Login" => $OPT{ulogin}
        , "SendAccNews" => "No"
        , "Email" => "$OPT{ulogin}\@yandex.ru"
        , "FIO" => "Ivan Petrov" || $OPT{param}
        , "SendNews" => "Yes"
        , "Phone" => "1234567" || $OPT{param2}
        , "NonResident" => "No"
        , "SendWarn" => "Yes"
    }];
}

sub FakeCreateReportQueue
{
    my %OPT = @_;

    return ({ReportID => $OPT{param}, ReportType => $OPT{param2}});
}

sub FakeBalanceNotificationNDS
{
    my %OPT = @_;
    
    return [{
        Login => $OPT{ulogin}
        , VATRate => $OPT{param}
    }];
}

sub GetNormalizedKeywordsData
{
    my %OPT = @_;
    
    return {
        Keywords => [ split /,/, $OPT{param} ]
    };
}

sub TransferMoney
{
    my %OPT = @_;
    
    return {
        FromCampaigns => [
            {CampaignID => $OPT{FromCampaignID1}, Sum => $OPT{FromSum1}, Currency => $OPT{FromCurrency1}}           
            , {CampaignID => $OPT{FromCampaignID2}, Sum => $OPT{FromSum2}, Currency => $OPT{FromCurrency2}}           
        ],
        ToCampaigns => [
            {CampaignID => $OPT{ToCampaignID1}, Sum => $OPT{ToSum1}, Currency => $OPT{ToCurrency1}}           
        ],        
    }
}

sub CreateInvoice
{
    my %OPT = @_;
    
    return {
        Payments => [
            {
                CampaignID => $OPT{cid} || $OPT{CampaignID}
                , Sum => $OPT{param} || $OPT{Sum}
                , Currency => $OPT{Currency}
            }
        ]
    };
}

sub Mediaplan
{
    my %OPT = @_;
    
    return {
        Action => $OPT{Action}
        , SelectionCriteria => $OPT{cid} ? {
            CampaignIDS => $OPT{cid} ? [split /,/, $OPT{cid}] : undef
        } : undef
        , Options => $OPT{Currency} || $OPT{Comment} ? {
            Currency => $OPT{Currency} ? $OPT{Currency} : undef
            , Comment => $OPT{Comment} ? $OPT{Comment} : undef
        } : undef
    };
}

sub MediaplanAd
{
    my %OPT = @_;
    my $params = {
        Action => $OPT{Action}
        , SelectionCriteria => $OPT{cid} ? {
            CampaignIDS => $OPT{cid} ? [split /,/, $OPT{cid}] : undef
        } : undef
        , Options => $OPT{Currency} || $OPT{Comment} ? {
            Currency => $OPT{Currency} ? $OPT{Currency} : undef
            , Comment => $OPT{Comment} ? $OPT{Comment} : undef
        } : undef
    };
    my $MAds = {MediaplanAdID => $OPT{MediaplanAdID},
                Domain        => $OPT{AdDomain} || "ya.ru",
                MinusKeywords => [],
                Sitelinks     => [],
                Text          => $OPT{AdText} || "Mediaplan banner text",
                Title         => $OPT{AdTitle}|| "Mediaplan banner title",
                Geo           => $OPT{AdGeo}  || "225",
                CampaignID    => $OPT{cid},   
                Href          => $OPT{AdHref} || "http://yandex.ru",   
               };        
    $params->{MediaplanAds} = [$MAds] if $OPT{Action} ne 'Get';


    return $params;
}

sub MediaplanKeyword
{
    my %OPT = @_;
    
    return {
        Action => $OPT{Action}
        , SelectionCriteria => $OPT{cid} ? {
            CampaignIDS => $OPT{cid} ? [split /,/, $OPT{cid}] : undef
            , MediaplanAdIDS => $OPT{MediaplanAdIDS} ? [split /,/, $OPT{MediaplanAdIDS}] : undef
        } : undef
        , Options => $OPT{Currency} || $OPT{Comment} ? {
            Currency => $OPT{Currency} ? $OPT{Currency} : undef
            , Comment => $OPT{Comment} ? $OPT{Comment} : undef
        } : undef
    };
}

sub GetEventsLog
{
    my %OPT = @_;
    
    return {
        TimestampFrom => $OPT{From}
        , TimestampTo => $OPT{To}
        , Filter => {
            CampaignIDS => $OPT{cid} ? [split /,/, $OPT{cid}] : undef
            , EventType => $OPT{EventType} ? [split /,/, $OPT{EventType}] : undef
        }
        , Currency => $OPT{Currency}
    };
}

sub GetRetargetingGoals
{
    my %OPT = @_;
    
    return {
        Logins => [split /,/, $OPT{ulogin}]
    };
}

sub RetargetingCondition
{
    my %OPT = @_;
    
    return {
        Action => $OPT{Action},
        SelectionCriteria => {
            Logins => $OPT{ulogin} ? [split /,/, $OPT{ulogin}] : undef,
            RetargetingConditionIDS => $OPT{param} ? [split /,/, $OPT{param}] : undef
        },

        RetargetingConditions => [
                             {
                              'Fields' => ['RetargetingConditionName', 'RetargetingCondition'],
                               'RetargetingConditionName' => 'AnyRetargetingName',
                               'RetargetingCondition' => [
                                                         {
                                                           'Type' => 'or',
                                                           'Goals' => [
                                                                      {
                                                                        'Time' => '1',
                                                                        'GoalID' => $OPT{param2}
                                                                      },
                                                                    ]
                                                         },
                                                       ],
                               'RetargetingConditionDescription' => 'AnyConditionDescription',
                               'Login' => $OPT{ulogin},
                               'RetargetingConditionID' => $OPT{param},
                             },
        ],
    };
}

sub Retargeting
{
    my %OPT = @_;
    
    return {
        'Action' => $OPT{Action},
        'Retargetings' => [
            {
                'AdID' => $OPT{AdID},
                'RetargetingID' => $OPT{RetargetingID},
                'RetargetingConditionID' => $OPT{RetargetingConditionID},
                'Currency' => $OPT{Currency},
                'ContextPrice' => $OPT{ContextPrice},
                'StatusPaused' => $OPT{StatusPaused} || 'No',
                'AutoBudgetPriority' => $OPT{AutoBudgetPriority},
                'Fields' => $OPT{Fields} ? [split /,/, $OPT{Fields}] : undef,
            }
        ],

        SelectionCriteria => {
            AdIDS => $OPT{AdIDS} ? [split /,/, $OPT{AdIDS}] : undef
            , RetargetingIDS => $OPT{RetargetingIDS} ? [split /,/, $OPT{RetargetingIDS}] : undef
            , RetargetingConditionIDS => $OPT{RetargetingConditionIDS} ? [split /,/, $OPT{RetargetingConditionIDS}] : undef
        },
        
        Options => {
            Currency => $OPT{Currency},
        }
    };
}

sub AdImage
{
    my %OPT = @_;    

    return {
        Action => $OPT{Action}
        , "SelectionCriteria" => {
            "Offset" => $OPT{Offset}
            , "Logins" => $OPT{Logins} ? [split /,/, $OPT{Logins}] : undef
            , "Limit" => $OPT{Limit}
            , "AdImageHashes" => $OPT{Hashes} ? [split /,/, $OPT{Hashes}] : undef
            , "AdImageUploadTaskIDS" => $OPT{TaskIDS} ? [split /,/, $OPT{TaskIDS}] : undef
            , "Assigned" => undef
        }
        , "AdImageURLData" => $OPT{URLData}
        , "AdImageRawData" => $OPT{RawData}
    };
}

sub AddEvents
{
    my %OPT = @_;
    
    return [ {
            "CampaignID" => $OPT{cid}
            , "EventType" => $OPT{EventType}
            , "Timestamp" => $OPT{Timestamp}
            , "EventName" => $OPT{EventName}
            , "Attributes" => {
                    "Rest" => $OPT{Rest}
                    , "MinPrice" => $OPT{MinPrice}
                    , "Currency" => $OPT{Currency}
                }
        }
    ];
}

sub GetStatGoals
{
    my %OPT = @_;
    
    return {
        CampaignID => $OPT{cid}
        , CampaignIDS => $OPT{cid} ? [split /,/, $OPT{cid}] : undef
    };
}

1;
