#!/usr/bin/perl -w

use strict;
use lib '.';
#use lib '/var/www/beta.mirage.8093/protected/';

use SOAP::Lite;
use LWP::Simple;
use Crypt::SSLeay;
use MIME::Base64;
use YAML::Syck;
use JSON::Syck;
use JSON;
use HTTP::Request::Common;
use Time::HiRes;
use Text::Iconv;
use Data::Dumper;
use Getopt::Long;
use File::Slurp;
use Term::ANSIColor;

use Encode qw/encode_utf8 decode_utf8/;

use utf8;

$YAML::Syck::ImplicitUnicode = 1;

=head2 Авторизация скрипта

    Авторизация осуществляется на основе сертификата, выданного Центром Сертификации Яндекс.Директ
    Для этого необходимо инициализировать следующие переменные окружения:

        HTTPS_CERT_FILE - абсолютный путь к пользовательскому сертификату, подписанному Центром Сертификации Яндекс.Директ,
        HTTPS_KEY_FILE - абсолютный путь к файлу с секретным ключом,
        HTTPS_CA_FILE - абсолютный путь к Директ CA файлу, которым подписан пользовательский сертификат,
        HTTPS_CA_DIR - абсолютный путь в каталогу с CA сертификатами.

=cut

my ($cmd, $beta, $debug, $testing, $beta_number2, $slogin, $version, $short, $param, $server) = ('', undef, undef, 0, undef, '', undef, 0, '');
my $usetoken = 0;
my $json = 0;
my $cert_flag = 0;
my $get_token_flag = 0;
my $fake_auth = 0;
my $testing2 = 0;
my $http = 0;
my ($cid, $bid, $ulogin, $param2);
my ($empty_hash, $empty_array, $empty_string, $null_value, $jsoned_params);
my ($locale, $latest);

GetOptions(
    'cmd=s' => \$cmd,
    'beta=s' => \$beta,
    'debug' => \$debug,
    'test' => \$testing,
    'test2' => \$testing2,
    'login=s' => \$slogin,
    'version=s' => \$version,
    'usetoken' => \$usetoken,
    'short' => \$short,
    'param=s' => \$param,
    'param2=s' => \$param2,

    'cid=s' => \$cid,
    'bid=s' => \$bid,
    'ulogin=s' => \$ulogin,
    'json' => \$json,
    'http' => \$http,
    'cert' => \$cert_flag,
    'get_token=s' => \$get_token_flag,
    'fake=s' => \$fake_auth,

    'server=s' => \$server,
    'empty_string' => \$empty_string,
    'empty_array' => \$empty_array,
    'empty_hash' => \$empty_hash,
    'null_value' => \$null_value,
    'json_params=s' => \$jsoned_params,
    'locale=s' => \$locale,
    'latest' => \$latest,
) || exit(1);

$version ||= 4;
my $PRIVATE_VAR = 'mirage-agency';
$cid = process_external_value_by_spec_syntax($cid);
$bid = process_external_value_by_spec_syntax($bid);
$ulogin = process_external_value_by_spec_syntax($ulogin);
$param = process_external_value_by_spec_syntax($param);

sub process_external_value_by_spec_syntax
{
    my $value = shift || return;

    if ($value eq 'empty_string') {
        $value = '';
    } elsif ($value eq 'empty_array') {
        $value = [];
    } elsif ($value eq 'empty_hash') {
        $value = {};
    } elsif ($value eq 'undef') {
        $value = undef;
    }

    return $value;
}

my $soap_options = {
    debug => $debug,
    beta => $beta,
    test => $testing,
    test2 => $testing2,
    http => $http,
    server => $server,
};

die "Not specified operator login" if !$slogin;

#my $OAUTH_URL = $testing || $testing2 || $beta ? "http://oauth.morelia.yandex.ru" : "https://oauth.yandex.ru";
my $OAUTH_URL = "https://oauth.yandex.ru";
if ($get_token_flag) {
    
    # показать урл, по которому можно получиться токен

    my $OAUTH_URL_CODE = "$OAUTH_URL/token";

=pod

    # my $application_client_id = $testing || $testing2 || $beta ? 'd36b99da611449169c9b755d347d0cb0' : 'a4f1858939af4f9490e46facef905c8d';
    my $application_client_id = 'a4f1858939af4f9490e46facef905c8d';
    my $get_token_url = "$OAUTH_URL/authorize?client_id=".$application_client_id."&response_type=code";
    print $get_token_url, "\n";
    
    # 7232297
    my $OAUTH_URL_CODE = "$OAUTH_URL/token";
    my $req_vars = {
        grant_type => 'authorization_code'
        , code => ($get_token_flag > 1 ? $get_token_flag : 0),
        , client_id => $application_client_id
    };

    my $json_tokens = _http_post($OAUTH_URL_CODE, $req_vars);
    print $json_tokens ? Dumper(from_json($json_tokens)) : 'empty';

    exit(1);

=cut

    # client_id: 9a4b934adcc14e189c76293794c8bf59
    # secret: 88074d634f1e406cadef1ad80d23d7fc
    #

    my $app_id = "9a4b934adcc14e189c76293794c8bf59";
    my $req = {
        grand_type => 'password'
        , username => $slogin
        , password => $PRIVATE_VAR || $ENV{PASSWD}
        , client_secret => '88074d634f1e406cadef1ad80d23d7fc'
        , client_id => $app_id
    };
    my $json_tokens = _http_post2($OAUTH_URL_CODE, app_id => $app_id, req => $req);
    print $json_tokens ? Dumper(from_json($json_tokens)) : 'empty';


    exit(1);
}

my $AUTH_CONF_FILE = "/home/".( [getpwuid($<)]->[0] )."/direct-api.oauth";

unless (-f $AUTH_CONF_FILE) {
    die "Don't exists auth file: $AUTH_CONF_FILE";
}

if ($usetoken || !$cert_flag) {
    $usetoken = 1;

    my $TOKENS = from_json(read_file($AUTH_CONF_FILE));
    my $login = $slogin;

    my $token = $TOKENS->{$login}{prod}{token};
    my $application_client_id = $TOKENS->{$login}{prod}{application_id};

    my $get_token_url = "https://oauth.yandex.ru/authorize?client_id=".$application_client_id."&response_type=token";
    # print $get_token_url;
    # https://oauth.yandex.ru/authorize?client_id=d36b99da611449169c9b755d347d0cb0&response_type=token

    # access_token=00cd3e38e3774efc91716491d6d0324f&state=&expires_in=2592000&refresh_token=bb51c9f2fd3f4a36a51842a1e9106e8e
    
    # http://direct.yandex.ru/n/#state=&expires_in=2591956&
    #               access_token=00cd3e38e3774efc91716491d6d0324f
    #               refresh_token=bb51c9f2fd3f4a36a51842a1e9106e8e
    
    my @headers = (
        SOAP::Header->name("token")->value($token)->type("")
        , SOAP::Header->name("login")->value($login)->type("")
        , SOAP::Header->name("application_id")->value($application_client_id)->type("")
        , SOAP::Header->name("locale")->value($locale || 'en')->type("")
    );

    push @headers, SOAP::Header->name("fake_login")->value($fake_auth)->type("") if $fake_auth;
    
    # для SOAP
    $soap_options->{headers} = \@headers;

    # для заголовка JSON
    $soap_options->{json_auth} = {
        token => $token,
        login => $login,
        application_id => $application_client_id,
    };
    
    $soap_options->{json_auth}{fake_login} = $fake_auth if $fake_auth;
}

#if (! $usetoken) {
if ($cert_flag) {
    warn "Auth by cert $slogin";
    # тестовое агентство mirage-agency4
     $ENV{HTTPS_CERT_FILE} = "/home/mirage/certs/$slogin/cert.crt";
     $ENV{HTTPS_KEY_FILE}  = "/home/mirage/certs/$slogin/private.key";
# 
#     # общие для всех сертификатов данные
# 
     $ENV{HTTPS_CA_FILE}   = "/home/mirage/certs/$slogin/cacert.pem";
     $ENV{HTTPS_CA_DIR}    = "/home/mirage/certs/$slogin/";
#}
}
my $api_version = $version ? "v$version" : "v5";
$api_version = "live/".$api_version if $latest;

my $getPhrasesPriceData = [
    {BannerID=> 2474624
        ,CampaignID=> 1301856
        ,PhraseID=> 27890225
    },{BannerID=> 2474624
    ,CampaignID=> 1301856
    ,PhraseID=> 27890226
    }
];

my $updatePricesData = [{
        CampaignID => 716240,
        BannerID => 1022929,
        # PhraseID => 29139652,
        # ContextPrice => 10,
        # Price => '1.13',
        # AutoBroker => 'Yes',
    }
];

my $createNewReportData = {
    CampaignID => $cid || $param || 716240,
    StartDate => $param || '2010-11-18',
    EndDate => $param2 || '2010-11-25',
    
    GroupByDate => 'day',
    # GroupByColumns => ['clDate', 'clBanner', 'clPhrase', 'clPositionType', 'clPage'], # ['clPhrase', 'clDate', 'clBanner', 'clPositionType'],#['clBanner', 'clPhrase', 'clPage'], #'clBanner'
    GroupByColumns => ['clDate', 'clBanner', 'clPhrase'], # ['clPhrase', 'clDate', 'clBanner', 'clPositionType'],#['clBanner', 'clPhrase', 'clPage'], #'clBanner'
    # OrderBy => ['clPhrase', 'clDate', 'clBanner', 'clPositionType'],#['clBanner', 'clPhrase', 'clPage'], #'clBanner'
    # OrderBy => ['clPhrase', 'clDate', 'clBanner', 'clPositionType'],#['clBanner', 'clPhrase', 'clPage'], #'clBanner'
    
    #Filter => {
        # Banner => [42095777]
        #PageType => 'search'
        #, PositionType => 'other',
    #},
    
#     TypeResultReport => 'xml',
#     CompressReport => 1,

};

my $createNewForecastData = {
    Phrases => ['"кондиционер"'],
    GeoID => [213, 2],
    Categories => [10753, 3135, 333, 103]
};

my $wizard_mode = {
    'CampaignID' => $cid
    , 'Mode' => 'Wizard'
#    , 'PriceBase' => 'min'
#    , 'ProcBase' => 'diff'
    , 'MaxPrice' => 10
#    , 'Proc' => 50
    , 'Scope' => $param2
    , 'PhrasesType' => 'Network'
#    , 'UpdatePhrases' => 'Yes'
#    , 'UpdateCategories' => 'Yes'
};

my $single_price_mode = {
    'CampaignID' => $cid
    , 'Mode' => 'SinglePrice'
    , 'SinglePrice' => 0.02
};

my $phrases_list;
my ($ii, $sumlength) = (0, 0);

if ($cmd eq 'CreateOrUpdateBanners' && $param eq 'length') {

    while (1) {
        $ii++;
        my $phr = join " ", map { get_random_string(alphabets => 'wWd', length => 7) } (1 .. int(rand(7)));
        $sumlength += length($phr);

        push @$phrases_list, {
            PhraseID => $ii,
            Phrase => $phr,
            IsRubric => 'No',
            AutoBroker => 'Yes',
            Price => 0.19,
        };

        last if $sumlength > ($param2 || 4096);
    }
}

my $BANNER = {
        CampaignID => $cid || $param || 1354584,
        BannerID => $bid || 0,
        'Text' => encode_utf8("Текст тестового объявления, длинной менее 75 символов. Точнее тут ров^~ 75."),
        Title => $param2 || encode_utf8("Баннер злобного апи-тестировщика"),
        #Href => "http://ya.ru/yandsearch?p={position}&p1={param1}&p2={param2}&pt={position_type}&s={source}&st={source_type}&bm={addphrases}&kwd={keyword}",
        domain => "xxx.ru",
        AgeLabel => "0",
        # Href => "http://goo.gl/VQ5T1",
        # Href => "http://одинэсов.рф/index.html",
        Href => "http://xn--b1admucdu9g.xn--p1ai/index.html",
        #Geo => [1,2,213,214],
        Geo => '1,2',
        #GeoID => 777,
        Phrases => $phrases_list || [
#             {
#                 PhraseID => 272385273,
#                 Phrase => "phrase test133 -test5 -test23",
#                 IsRubric => 'No',
#                 AutoBroker => 'No',
#                 Price => 1.19,
#                 UserParams => {
#                     Param1 => 0,
#                     Param2 => '%!$%$6_54-7654%$%',
#                 }
#             },
            {
                PhraseID => 0,
                # Phrase => 'проектно конструкторское бюро',
                Phrase => encode_utf8('наивысшая доступная позиция'),
                # Phrase => 'тест1 тест2 тест3',
                IsRubric => 'No',
                AutoBroker => 'Yes',
                Price => 0.02,
                UserParams => {
                    Param1 => 1,
                    # Param2 => "Заказ № due" || "abc-1233",
                }
            },
            {
                PhraseID => 0,
                # Phrase => 'конструкторские бюро',
                # Phrase => 'тест1 тест2',
                Phrase => encode_utf8('lоступная позиция'),
                IsRubric => 'No',
                AutoBroker => 'Yes',
                Price => 0.01,
                UserParams => {
                    Param1 => 0,
                    # Param2 => "Заказ № due" || "abc-1233",
                }
            },
#             {
#                 PhraseID => 0,
#                 Phrase => ".",
#                 IsRubric => 'No',
#                 AutoBroker => 'Yes',
#                 Price => 0.666,
#             },
#             {
#                 PhraseID => 0,
#                 Phrase => "",
#                 IsRubric => 0,
#                 AutoBroker => 1,
#                 Price => 0.14,
#             },
#             {
#                 PhraseID => 3,
#                 Phrase => "10603",
#                 IsRubric => 1,
#                 AutoBroker => 1,
#                 Price => 0.14,
#             },
#             {
#                 PhraseID => 272385266,
#                 Phrase => "10425",
#                 IsRubric => 'Yes',
#                 AutoBroker => 'Yes',
#                 Price => 15.14,
#                 UserParams => {
#                     Param1 => 31,
#                     Param2 => "312-abc",
#                 }
#             },
#             {
#                 Phrase => "",
#                 IsRubric => "No",
#                 Price => "1.1",
#                 PhraseId => 4,
#                 AutoBroker => "Yes",
#                 AutoBudgetPriority => "Medium",
#             }
        ],

        ContactInfo => {
            Apart => undef,
            City => ('Москва'),
            CityCode => 499,
            CompanyName => ('Яндекс'),
            ContactEmail => undef,
            ContactPerson => ('Виктория'),
            Country => ('Россия'),
            CountryCode => '+7',
            ExtraMessage => 'testestestestestestsete',
            #House => 125,
            #IMClient => 'icq',
            #IMLogin => 123456712,
            IMClient => 'mail_agent',
            IMLogin => 'test1@bkk.ru',
            OGRN => undef,
            Phone => '777-33-33',
            PhoneExt => '',
             PointOnMap => {
                 x => 37.678515
                 , x1 => 37.667537
                 , x2 => 37.689491
                 , "y" => 55.758255
                 , y1 => 56.753615
                 , y2 => 56.762895
             },
             #Street => ('варшавское шоссе'),
            WorkTime => '0;6;9;00;18;00',
        },

        Sitelinks => [
             { Href => "http://yandex.ru/1", Title => "title_1" },
             { Href => "http://yandex.ru/2", Title => "title_2" },
             { Href => "http://yandex.ru/3", Title => "title_3" },
        ]
};

$BANNER->{ContactInfo} = undef;

my $pingapi_x_original = [
    {
        'IntValue' => 1,
        'DateValue' => '2008-01-01',
        'StrValue' => 'Первый элемент',
        'IntArray' => [1, 2, 3, 4],
        'StrArray' => ['Первый', 'Второй', 'Третий'],
        'StructArray' => [
                {'Field1' => 'Значение1', 'Field2' => 1},
                {'Field1' => 'Значение2', 'Field2' => 2}
            ],
    },
    {
        'IntValue' => 2,
        'DateValue' => '2008-12-01',
        'StrValue' => 'Второй элемент',
        'IntArray' => [5, 6, 7, 8],
        'StrArray' => ['Пятый', 'Шестой', 'Седьмой', 'Восьмой'],
        'StructArray' => [
                {'Field1' => 'Значение3', 'Field2' => 3},
                {'Field1' => 'Значение4', 'Field2' => 4},
                {'Field1' => 'Значение5', 'Field2' => 5},
            ],
    }
];

#print get_report("https://soap.direct.yandex.ru/reports/stat_fe739d25d0175d6704b450f2f154f85e.xml");
#exit(1);

my $CAMPAIGN = {
    'CampaignID' => ($cid || 0), 
    'Login' => ($ulogin || 'mirage59'),
    # 'StatusContextStop' => 'No',
    'Name' => ($param || 'Новая кампания'),
    'FIO' => ($param2 || $param || 'Иванов Иван Иванович'),
    'StartDate' => '2009-01-15',
    # 'CampaignType' => 'geo',

    # AgencyLogin => 'mirage-agency4',

#     'AutoOptimization' => 'No',
#         
#     'DisabledDomains' => join(',', map {"domain$_.ru"} (1..1001)),
#     'DisabledIps' => '64.234.23.21',
#                 
#     'StatusBehavior' => 'Yes',
#         
#      'TimeTarget' => {
#          'TimeZone' => 'Europe/Moscow',
#          'DaysHours' => [
#              {
#                  'Hours' => [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13], 
#                  'Days' => [1, 2, 3, 4, 6, 7],
#                  'BidCoef' => [100,80,100,80,100,80,100,80,100,80,100,80,100]
#              }
#          ],        
#      },
#     'StatusMetricaControl' => 'Yes',
#     'ConsiderTimeTarget' => 'No',        
#     'StatusOpenStat' => 'No',        
#     'ContextPricePercent' => 10,
#
#     'ContextLimit' => 'Default',
#     'ContextLimitSum' => 0,
     'ContextLimit' => 'Limited',
     'ContextLimitSum' => 80,
#         
#     'Autobudget' => 'Yes',          
#     'AutobudgetSum' => 76,
#     'AutobudgetMaxPrice' => 17,  
# 
     'EmailNotification' => {
         'Email' => ' user@ya.ru ',
         'MoneyWarningValue' => 1,
         'WarnPlaceInterval' => 15,
         'SendWarn' => 'Yes',
         'SendAccNews' => 'Yes'        
     },
# 
#     'SmsNotification' => {  
#         'MetricaSms' => 'Yes',
#         'ModerateResultSms' => 'Yes', 
#         'MoneyInSms' => 'Yes',
#         'MoneyOutSms' => 'Yes',
#         'SmsTimeFrom' => '09:15',
#         'SmsTimeTo' => '22:15' 
#     },
# 
#     'MinusKeywords' => ['keyword1', 'keyword2', 'keyword3'],
# 
#     'AddRelevantPhrases' => 'Yes',
#     'RelevantPhrasesBudgetLimit' => 50
#    , 'ShowOnPages' => ['test.ru']
    , Strategy => {
        StrategyName => 'WeeklyBudget'
        , AveragePrice => 2.0
        , WeeklySumLimit => 100
    }
};

my $CreateNewSubclient = {
        Login => $ulogin || 'mirage-7',
        AgencyLogin => $param,
        Name => 'John',
        Surname => 'Smith',
        LoginExists => $param2,
};

my $PingAPI_X = [
            {
'IntValue' => 1,
'DateValue' => '2008-01-01',
'StrValue' => 'Первый элемент',
'IntArray' => [1, 2, 3, 4],
'StrArray' => ['Первый', 'Второй', 'Третий'],
'StructArray' => [
{'Field1' => 'Значение1', 'Field2' => 1},
{'Field1' => 'Значение2', 'Field2' => 2}
],
},
{
'IntValue' => 2,
'DateValue' => '2008-12-01',
'StrValue' => 'Второй элемент',
'IntArray' => [5, 6, 7, 8],
'StrArray' => ['Пятый', 'Шестой', 'Седьмой', 'Восьмой'],
'StructArray' => [
{'Field1' => 'Значение3', 'Field2' => 3},
{'Field1' => 'Значение4', 'Field2' => 4},
{'Field1' => 'Значение5', 'Field2' => 5},
],
}
];

my $createNewWordstatData = {
    Phrases => [
                "'окна'", "\"пластиковые окна\"", "купить окна"
                ],
    GeoID   => undef, # [1, 2, 225]
};

$bid ||= "";
$cid ||= "";
$param ||= "";
$ulogin ||= "";

my %CMDS = (
    'StopBanners' => {CampaignID => $cid, BannerIDS => [split /,/, $bid]},
    'ResumeBanners' => {CampaignID => $cid, BannerIDS => [split /,/, $bid]},
    'ArchiveBanners' => {CampaignID => $cid, BannerIDS => [split /,/, $bid]},
    'UnArchiveBanners' => {CampaignID => $cid, BannerIDS => [split /,/, $bid]},

    'CreateNewReport'   => $createNewReportData,
    'GetReportURL'      => $param,
    'GetReportList'     => undef,
    'DeleteReport'      => $param,
    'GetRegions'        => {},
    'GetRubrics'        => {},
    'GetBanners'        => {
        BannerIDS => $bid ? [split /,/, $bid] : undef,
        CampaignIDS => $cid ? [split /,/, $cid] : undef,
        Filter => {
            #StatusBannerModerate => ["Yes", "No", "PreliminaryAccept", "New"]
            # , StatusPhrasesModerate => "",
            StatusArchive => ["No"]
        },
        GetPhrases => $param,
    },

    'GetVersion'        => '',
    'PingAPI'           => undef, # $param || {definedkey => 1, undefinedkey => undef}, # undef, #{1=>2,3=>4,5=>[6,7, {8=>9}]}, # [1,2,3],
    'PingAPI_X' => $PingAPI_X,

    'CreateNewForecast' => $createNewForecastData,
    'GetForecastList'   => {},
    'GetWordstatReportList'   => {},
    'GetForecast'       => $param,
    'DeleteForecastReport' => $param,

    'UpdatePrices'      => $updatePricesData,
    'GetPhrasesPrice'   => $getPhrasesPriceData,

    'GetClientInfo'     => [$param || $ulogin],
    'GetBalance'        => [$cid],
    'ResumeCampaign'    => $cid,
    

    'GetBannersList'    => [$cid],
    'GetClientsList'    => {},
    
    'GetBannerPhrases' => [split /,/, $bid],
    'GetBannerPhrasesFilter' => {
        BannerIDS => [$bid],
        FieldsNames => $param ? [split /\s+/, $param] : undef,
        ConsiderTimeTarget => $param2,

#        FieldsNames => [qw/Price Prices Coverage Min CurrentOnSearch ContextLowCTR/]
     },
    'GetCampaignsList' => [$param || $ulogin], #['mirage-7'],
    'GetWordstatReport' => $param || 0,
    'GetCampaignsListFilter' => {
        Logins => [$param || $ulogin], 
        Filter => {
                    StatusArchive => ['Yes'],
                    IsActive => ['Yes', 'No']
        }
    },
    'GetEventsLog' => {
        Logins => [split /,/, $ulogin]
        , TimestampFrom => $param || "2012-09-01T23:59:59"
        , Filter => {
            CampaignIDS => [split /,/, $cid]
            , BannerIDS => [split /,/, $bid]
        }
        , WithTextDescription => "Yes"
    },
    
  # работа с объектами
    'StopCampaign' => {CampaignID => $cid },
    'ResumeCampaign' => {CampaignID => $cid },
    'ArchiveCampaign' => {CampaignID => $cid },
    'UnArchiveCampaign' => {CampaignID => $cid },
    'GetSubClients' => ($param ? {Login => $param} : undef), #{Login => 'mirage-19'}, #{Login => 'mirage-agency4-rep1'},

    'ModerateBanners' => {CampaignID => $cid, BannerIDS => [split /,/, $bid]},
  
    #'ArchiveBanners' => (342246, ['483951']),
    #'UnArchiveBanners' => (342246, ['483951']),
    
    'GetClientsUnits' => [$ulogin],
    'GetAvailableVersions' => undef,
    'SetAutoPrice' => $wizard_mode, # $single_price_mode
    'GetCampaignParams' => {CampaignID => $cid},
    'GetCampaignsParams' => {CampaignIDS => [split /,/, $cid]},
    'GetTimeZones' => [],
    'CreateOrUpdateBanners' => [$BANNER],
    'CreateOrUpdateCampaign' => $CAMPAIGN,
    'PingAPI_X' => $pingapi_x_original,
    'CreateNewSubclient' => $CreateNewSubclient,
    'CreateNewWordstatReport' => $createNewWordstatData,
    'DeleteWordstatReport' => $param,
    'DeleteBanners' => { 
        CampaignID => $cid || 1,
        BannerIDS => [split /,/, $bid]
     },
    'GetChanges' => {
        CampaignIDS => $cid ? [split /,/, $cid] : undef,
        BannerIDS => $bid ? [split /,/, $bid] : undef,
        Logins => $ulogin ? [split /,/, $ulogin] : undef,
        Timestamp => $param,
    },
    'DeleteCampaign' => {
        CampaignID => $cid
    }
    , 'GetCampaignsSpecialStat' => {
        CampaignIDS => [split(/,/, $cid)]
        , StartDate => $param || '2011-01-01'
        , EndDate => $param2 || $param || '2011-07-01'
    }
    , 'GetSummaryStat' => {
        CampaignIDS => [split /,/, $cid],
        , StartDate => $param || '2011-01-01'
        , EndDate => $param2 || $param || '2011-07-01'        
    },
    'GetStatGoals' => {
        CampaignID => $cid
    }
    , 'FakeCampaignParams' => {
        cid => $cid,
        , OrderID => 123
        , type => 'text'
        , sum => 10
        , sum_units => undef
        , sum_spent => 9
        , sum_to_pay => 100
        , sum_last => 100
        , sum_spent_units => undef
        , statusModerate => 'No'
        , statusShow => 'Yes'
        , statusActive => 'Yes'
        , statusBsSynced => 'Yes'
        , shows => 100500
        , clicks => 1000
        , lastShowTime => '20120901'
        , finish_time => undef
        , statusMail => 'Yes'
        , paid_by_certificate => undef
        , statusNoPay => 'No'
        , DoShow => undef
        , autobudget_goal_id => undef
        , statusPostModerate => 'Accepted'
        , day_budget_daily_change_count => undef
        , day_budget_stop_time => undef,
        , day_budget_notification_status => undef,
        , sms_time => undef
        , sms_flags => undef
        , auto_optimize_request => 'No'
        , mediaplan_status => undef
        , manual_autobudget_sum => undef
        , autobudgetFromStrategyDate => undef
        , camp_description => 'camp description'
    }
    , 'FakeBannerParams' => {
        bid => $bid
        , BannerID => $bid
        , statusModerate => 'Yes'
        , statusPostModerate => 'Yes'
        , phoneflag => 'Yes'
        , sitelinks_set_id => 12345
        , statusSitelinksModerate => 'Yes'
        , statusShow => 'Yes'
        , statusActive => 'Yes'
        , statusBsSynced => 'Yes'
        , statusMetricaStop => 'No'
        , statusUnFamily => 'No'
        , p_PriorityID => 123456
        , p_statusModerate => 'Yes'
        , p_statusPostModerate => 'Yes'
        , p_statusBsSynced => 'Yes'
        , p_statusAutobudgetShow => undef 
        , p_ChoosedCategories => undef
        , p_forecastDate => undef
    }
    , 'FakeBalanceNotification' => {
        cid => $cid
        , mcb_campaign => $param2 || 0
        , sum_from_balance => $param
        , balance_paid_by_certificate => undef
    }
);

=pod

use LWP::UserAgent;
use Data::Dumper;
use Encode;
    my $url = 'http://8037.beta.direct.yandex.ru:14080/wsdl/v1/';
    my $response = LWP::UserAgent->new()->request(HTTP::Request->new('GET', $url));
    if ($response->code != 200) {
        warn Encode::decode_utf8($response->message);
    } else {
        warn $response->content();
    }
my $res = LWP::UserAgent->new()->request('https://8037.beta.direct.yandex.ru:14443/wsdl/v1/');

=cut

my $result;
my $t = Time::HiRes::time();

if (exists $CMDS{$cmd}) {
    my $call_params = $CMDS{$cmd};
    
    if ($jsoned_params) {
        $call_params = from_json($jsoned_params);
    } else {
        if ($null_value) {
            $call_params = undef;
        } elsif ($empty_array) {
            $call_params = [];
        } elsif ($empty_hash) {
            $call_params = {};
        } elsif ($empty_string) {
            $call_params = '';
        }
    }

    $result = call_method($cmd, $call_params, $soap_options, json => $json, usetoken => $usetoken);

    warn "Count items = ".scalar(@$result) if ref($result) =~ /ARRAY/i;

} else {
    die "Method doesn't describe";
}

$| = 1;
if ($result) {
    
    if ($cmd eq 'CreateNewForecast') {
        while ( 1 ) {
            print "\nSleep(5) ...\n\n";
            sleep(5);
            
            my $list = call_method('GetForecastList', undef, $soap_options, json => $json, usetoken => $usetoken);
            my $cnt = grep {$_->{StatusForecast} eq 'Done' && $_->{ForecastID} == $result} @$list;

            if ($cnt) {
                my $res = call_method('GetForecast', $result, $soap_options, json => $json, usetoken => $usetoken);
                if ($res) {
                    print YAML::Syck::Dump($res);
                    # $res = unsoapize($res);
                    
                    # my %res11 = %$res;
                    # my $json = JSON->new->allow_nonref;
                    # print $json->pretty->encode( \%res11 );
                    
                    # print my $res1 = call_method('DeleteForecastReport', $result, $soap_options, json => $json, usetoken => $usetoken);
                    last;
                }
            } else {
                warn Dumper {list => $list};
            }
        }
    } elsif ($cmd eq 'CreateNewWordstatReport') {
        while ( 1 ) {
            print "\nSleep(5) ...\n\n";
            sleep(5);
            
            my $list = call_method('GetWordstatReportList', undef, $soap_options, json => $json, usetoken => $usetoken);
            my $cnt = grep {$_->{StatusReport} eq 'Done' && $_->{ReportID} == $result} @$list;

            if ($cnt) {
                my $res = call_method('GetWordstatReport', $result, $soap_options, json => $json, usetoken => $usetoken);
                if ($res) {
                    print YAML::Syck::Dump($res);
                    
                    print my $res1 = call_method('DeleteWordstatReport', $result, $soap_options, json => $json, usetoken => $usetoken);
                    last;
                }
            } else {
                warn Dumper {list => $list};
            }
        }
    } elsif ($cmd eq 'CreateNewReport') {

        my $reportInfo;
        my $counter = 0;
        
        my $ilist = call_method('GetReportList', undef, $soap_options, json => $json, usetoken => $usetoken);
        print Dumper {list => $ilist};

        print "ReportID: $result\n";

        # ждем пока отчет будет создан
        while ((!$reportInfo || $reportInfo->{StatusReport} ne 'Done')
                    && $counter++ < 20) {
            print "Sleep(10) ...\n\n";
            sleep(10);
            my $list = call_method('GetReportList', $result, $soap_options, json => $json, usetoken => $usetoken);
            if (@$list) {
                ($reportInfo) = grep {$_->{ReportID} == $result && $_->{StatusReport} eq 'Done'} @$list;
                
                if (! $reportInfo) {
                    print Dumper {list => $list};
                }
            }
        }

        if ($reportInfo->{Url}) {
            warn "URL: $reportInfo->{Url}";
            
            # выводим отчет в STDOUT
            print "Report url: $reportInfo->{url}\n";
            print "Get report file:\n";
            print get_report( $reportInfo->{Url} );
            print "\n";
            
            sleep(3);
            # my $res3 = call_method('DeleteReport', $reportInfo->{ReportID}, $soap_options, json => $json, usetoken => $usetoken);
            # print $res3;
            
        } elsif( $counter > 20 ) {
            die "Превышено допустимое количество обращений";
        } else {
            die "Неизвестная ошибка";
        }

    } elsif ($cmd eq 'GetRubrics') {
    
        my $catalog_tree = {};
        foreach my $i (@$result) {
            $catalog_tree->{ $i->{RubricID} } = $i;
        }
        
        print "Get ".scalar(keys(%$catalog_tree))." rubrics\n";
        
        foreach my $r (keys %$catalog_tree) {
            if ($catalog_tree->{$r}{ParentID} && ! defined $catalog_tree->{ $catalog_tree->{$r}{ParentID} }) {
                die "Not exists parent rubric with RubricID = ".$catalog_tree->{$r}{ParentID};
            }
        }
        
        if (! $short) {
          foreach my $r (keys %$catalog_tree) {
            foreach my $f (qw/RubricID RubricName RubricFullName ParentID Url/) {
                my $suffix = $f eq 'ParentID' ? 
                        " (".$catalog_tree->{ $catalog_tree->{$r}{ParentID} }{RubricFullName}.") "
                        : "";
                my $prefix = $f eq 'RubricID' ? "" : "\t";
                
                print "$prefix $f:\t".Encode::encode_utf8($catalog_tree->{$r}{$f} . $suffix)."\n" if defined $catalog_tree->{$r}{$f};
            }
            
            print "---\n";
          }
      }

    
    } elsif ($cmd eq 'GetCampaignsList' && $short) {
        foreach my $i (@$result) {
            print Encode::encode_utf8("$i->{CampaignID} - $i->{Name}"), "\n";
        }
    } elsif ($cmd eq 'GetCampaignsParams' && $param && $param eq 'change') {

        my $result1 = $result->[0];
        $result1->{CampaignID} = undef if $param2 eq 'renew';
        $result1->{ContextLimitSum} = 0;
#         $result1->{Name} .= $param2 || 1;
#         $result1->{TimeTarget} = {
#          'TimeZone' => 'Europe/Moscow',
#          'DaysHours' => [
#                  {
#                      'Hours' => [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13],
#                      'Days' => [1, 2, 3, 4],
#                  },
#                  {
#                      'Hours' => [1, 2, 3, 4, 5, 6, 7, 8, 9, 10],
#                      'Days' => [6, 7],
#                  }
#              ],
#          };


        my $upd_res = call_method('CreateOrUpdateCampaign', $result1, $soap_options, json => $json, usetoken => $usetoken);

        my $new_camp = call_method('GetCampaignsParams', {CampaignIDS => [$upd_res]}, $soap_options, json => $json, usetoken => $usetoken);
   
    } elsif ($cmd eq 'CreateOrUpdateCampaign' && $param2 eq 'bulk-create') { 

        foreach my $n (1 .. $param) {
            my $params = $CMDS{CreateOrUpdateCampaign};
            $params->{Name} = "$n from $param";
            my $upd_res = call_method('CreateOrUpdateCampaign', $params, $soap_options, json => $json, usetoken => $usetoken);
            print STDERR "$n - $upd_res\n";

            my @banners = ();
            foreach (1..100) {
                my @phrases = ();
                
                $BANNER->{CampaignID} = $upd_res;

                foreach (1..15) {
                    push @phrases, {
                                        Phrase => get_random_string(length => 10, alphabets => 'wd')
                                        , Price => (int(rand(5) * 100 + 0.5) / 100 + 0.1)
                                    };
                }

                $BANNER->{Phrases} = \@phrases;
                push @banners, $BANNER;
            }

            my $b_ids = call_method('CreateOrUpdateBanners', \@banners, $soap_options, json => $json, usetoken => $usetoken);
            print STDERR "$n - ".scalar(@$b_ids)."\n\n";

        }

    } elsif ($cmd eq 'GetClientInfo' && $param2 eq 'update') {

        my $result1 = $result->[0];
        # $result1->{Email} = "    ".$result1->{Email}."   ";
        $result1->{FIO} = $result1->{FIO}." 2";
# warn Dumper {for_update => $result1};
        my $upd_res = call_method('UpdateClientInfo', [$result1], $soap_options, json => $json, usetoken => $usetoken);

        my $new_camp = call_method('GetClientInfo', [$result1->{Login}], $soap_options, json => $json, usetoken => $usetoken);
# warn Dumper {result => $new_camp};
    } elsif ($cmd eq 'GetBanners' && $param2 && $param2 eq 'update') {

        if ($result->[0]->{Title} =~ /Х$/) {
            #$result->[0]->{Title} =~ s/Х$//;
        } else {
            #$result->[0]->{Title} =~ s/\w$/Х/;
        }

        # $result->[0]->{AgeLabel} = "16+";
        
        # $result->[1]->{CampaignID} = $result->[0]->{CampaignID};
        foreach my $b (@$result) {
            $b->{BannerStatusShow} = "No" if $b->{BannerID} % 2;

            foreach my $p (@{$b->{Phrases} || []}) {
                $p->{Price} += 0.1;
            }
        }
        # @{$result1->{Phrases}}[0]->{Price} += 0.1;
        # push @{$result->[1]->{Phrases}}, { Phrase => "plus14 word", Price => 1 }; # . (@{$result1->{Phrases}}[0]->{Phrase});
        # delete $result1->{ContactInfo};

        my $upd_res = call_method('CreateOrUpdateBanners', [grep { $_->{StatusArchive} ne "Yes" } @$result], $soap_options, json => $json, usetoken => $usetoken);
       
        print STDERR Dumper ($upd_res); 
        

    } else {
        print YAML::Syck::Dump($result);
        # print Dumper {api_test_client_result => $result};
    }
}

print "\nTime processed: ", Time::HiRes::time() - $t, "\n\n" if $debug;

sub unsoapize {
    my $v = shift;
    
    if (ref($v) eq 'SOAP::Data' && $v->type !~ /^ArrayOf/i) {
        $v = $v->value;
        $v = unsoapize($v);
    }
    
    if (ref($v) eq 'ARRAY') {
        $_ = unsoapize($_) for @$v;
    } elsif (ref($v) eq 'HASH') {
        $_ = unsoapize($_) for values %$v;
    } elsif (ref($v) eq 'SOAP::Data' && $v->type =~ /^ArrayOf/i) {
        $v = $v->value;
        $_ = unsoapize($_) for @$v;
    } else {
        # other
    }

    return $v;
}

=head2 call_method(method, data)

    Функция вызывает указанный метод интерфейса программирования приложений Яндекс.Директ ( API )

=cut

sub call_method
{
    my $method_name = shift || return;
    my $method_data = shift;

    my $soap_options = shift;
    my %OPT = @_;

    my $ltm = Time::HiRes::time();
    print "Call method: $method_name\n";
#    print "Params:".(ref $method_data ? "1".to_json($method_data) : "2".$method_data)."\n\n";

    my $soap = SOAP::Lite
        -> uri('API');

    if (defined $soap_options->{debug}) {
        # $soap -> on_debug(sub {print join(">\n", split(">", join("", @_)));});
        $soap -> on_debug(sub {print colored [('blue','magenta')[int(10*rand()) % 2]], @_});
    }
    
    my $domain = $soap_options->{server} || 'soap.direct.yandex.ru';
    #my $domain = 'ppcsoap02d.yandex.ru';
    #my $domain = 'api.direct.yandex.ru';
    #my $domain = '8037.beta.direct.yandex.ru';

    my $url_suffix = $json ? "$api_version/json" : "$api_version/soap";
    $url_suffix .= "/" if rand(1) > .5;

    # my $url_suffix = $json ? "json-api/$api_version/" : "api/$api_version/";
    my $scheme = 'https';
    my $port = ''; # '443';
    #my $port = '15443';

    if ($soap_options->{beta}) {
      $domain = $soap_options->{beta} . ".beta.direct.yandex.ru";
      $scheme = 'https';
      $port = '14443';

    }
  
    if ($soap_options->{test}) {
        $scheme = 'https';
        $port = '14443';
        $domain = 'test-direct.yandex.ru';
    } elsif ($soap_options->{test2}) {
        $scheme = 'https';
        $port = '15443';
        $domain = 'test2-direct.yandex.ru';
    }
    
    if ($soap_options->{http}) {
        $scheme = 'http';
        $port = '14080';
    }

    my $url = "$scheme://$domain".($port ? ":$port" : '')."/$url_suffix";
# $url = "https://8038.beta.direct.yandex.ru:14443/json-api/v4/";
    # kostyl'
    # if ($json && $soap_options->{beta}) {
        # $url = 'http://beta.direct.yandex.ru:'.$beta_number.'/json-api/v'.$version.'/';
        # $url = 'http://'.$beta_number.'.beta.direct.yandex.ru/json-api/v'.$version.'/';
    # }

    print STDERR "\n", "#" x 30, "\n";
    print STDERR colored ['red'], "\n", $url, "\n";
    # print STDERR "Request: $method_name ( ".($method_data ? to_json($method_data) : ''), " )\n";
    print STDERR "\n", "#" x 30, "\n\n";

    my $request;
    if (! $OPT{json}) {
        $soap->proxy($url);

        $request = $soap->call($method_name
                                , @{ $soap_options->{headers} || []}
                                , $method_data);

        unless ($request->fault) {
            # в случае успешного выполнения запроса - возвращаем результат
            return $request->result;
        } else {
            # если возникла ошибка - выводим сообщение в STDERR и завершаем выполнение программы
            print "\n", "#" x 30, "\n";
            print colored ['yellow'], "\nError code: ".$request->faultcode;
            print colored ['red'], "\nDescribe error: ".($request->faultstring || '');
            print colored ['blue'], "\nDetails: ".($request->faultdetail || '');
            print "\n\n", "#" x 30, "\n\n";
            
            return undef;
        }
        
    } elsif ($OPT{json}) {
        use HTTP::Request::Common;
        use HTTP::Response;
        use LWP::UserAgent;
       
        my $json_api_data = {};
        $json_api_data->{locale} = $locale || 'en';

        $json_api_data->{param} = $method_data;
        $json_api_data->{method} = $method_name;

        $json_api_data->{ agcl } = 1;
        if ($OPT{usetoken}) {
            $json_api_data->{$_} = $soap_options->{json_auth}{$_} foreach (qw/login token application_id fake_login/);
        }

        my $ua = new LWP::UserAgent( timeout => 600 );

        my $headers = HTTP::Headers->new;

        # $headers->push_header('Content-Type' => 'application/x-www-form-urlencoded');
        # $headers->push_header('Content-Type' => 'text/xml');

        my $dreq = to_json($json_api_data);
# $dreq = qq|{"method":"GetSummaryStat","locale":"ru","param":{"StartDate":"2012-02-26","EndDate":"2012-04-02","CampaignIDS":[9356]},"login":"AlekseyBelousov","application_id":"da61ec8359ee45eeab120f8505bdcca2","token":"3bc8dfc0a68445f49a80ab6358914349"}|;

# $dreq = qq|{"method":"CreateOrUpdateBanners","locale":"en","param":[{"BannerID":0,"Title":"test api 1","Text":"testestestestes api 2","CampaignID":"342246","Geo":"1,2","Href":"http://ya.ru","phrases":"123","Phrases":[{"PhraseID":272385273,"Price":0.19,"AutoBroker":"No","IsRubric":"No","Phrase":"phrase test133 -test5 -test23"},{"PhraseID":272385272,"Price":0.14}]}]}|;
        warn $dreq if $soap_options->{debug};
#$dreq = qq|{"method":"GetClientInfo","param":["cybergogic"],"locale":"ru","login":"cybergogic","application_id":"3887ff5490064aea8279e00adc298411","token":"b5d7f10656c74d148ed29920bd34c292"}|;

        $dreq = deep_encode_utf8($dreq);

#$dreq = '{"login":"feya.test.profy","method":"GetClientInfo","param":["feya.test.profy"],"token":"b537aacf2bfd48bba55db6be354b39b1","application_id":"bf332f6d93914cc5925b85d513bff033"}';
#$dreq = '{ "token": "e89a4d1ac6ad4de59fe68f83b831e98f", "locale": "en", "login": "at-direct-api-test", "application_id": "ae99016820074f809e5c268e564bebad", "method": "PingAPI" }';

        my $request = HTTP::Request->new('POST', $url, $headers, $dreq);
        my $response = $ua->request($request);
        
        warn "---\n".$request->as_string, "\n\n" if $soap_options->{debug};
        warn "----\n".$response->as_string, "\n\n" if $soap_options->{debug};
        
        if ($response->is_success) {

            if ($method_name eq 'GetCampaignsSpecialStat') {
                print ">>".$response->content."<<";
            } else {
                my $data = from_json(Encode::decode 'utf8', $response->decoded_content());
                # print to_json($data);

                # exit(1);
                # print Dumper {api_data => $data};
                
                if ($data->{error_code}) {
                    
                    print Dumper {api_response => $data};
                    return undef;
                } else {                
                    return $data->{data};
                }
            }

        } else {
            print "request failed!";
        }
    }
    
    if ($debug) {
        printf "(time: %0.4f sec)", Time::HiRes::time() - $ltm; print "\n";
    }

    return undef;
}

=head2 get_report(reportURL)

    Фукнкция загружает указанный URL( полученный с помощью метода GetReportURL ) и возвращает содержимое страницы( готовый XML отчет )

=cut

sub get_report
{
    return get(shift);
}

sub _http_post
{
    my $url = shift;
    my %options = @_;

    my $post_content = join "&", map { $_."=".$options{req}{$_} } keys %{$options{req}};

    my $headers = HTTP::Headers->new;
    $headers->push_header('Content-type' => 'application/x-www-form-urlencoded');
    $headers->push_header('Content-Length' => length($post_content));
    $headers->push_header('Host' => 'oauth.yandex.ru');
    
    # $headers->push_header('Authorization' => 'Basic '.encode_base64($options{app_id}, ""));

    my $ua = LWP::UserAgent->new(timeout => 60);
    my $request = HTTP::Request->new(POST, $url, $headers, $post_content);
    my $response = $ua->request($request);
 print STDERR "\n--\n", $request->as_string, "\n--\n";
    if ($response->is_success()) {
        return $response->content();
    } else {
        print STDERR "$0 error \nresponse-code: " . $response->code . "\ncontent: " . $response->content();
        return;
    }
}

sub _http_post2
{
    my $url = shift;
    my %options = @_;

    use HTTP::Request::Common;
    
    # my $headers = HTTP::Headers->new;
    # $headers->push_header('Content-type' => 'application/x-www-form-urlencoded');
    # $headers->push_header('Content-Length' => length($post_content));
    # $headers->push_header('Host' => 'oauth.yandex.ru');
    
    # $headers->push_header('Authorization' => 'Basic '.encode_base64($options{app_id}, ""));

    my $ua = LWP::UserAgent->new(timeout => 60);
    my $response = $ua->request(POST $url, Content => $options{req});

    if ($response->is_success()) {
        return $response->content();
    } else {
        print STDERR "$0 error \nresponse-code: " . $response->code . "\ncontent: " . $response->content();
        return;
    }
}

sub deep_encode_utf8 {
    my $v = shift;
    if (ref($v) eq 'ARRAY') {
        $_ = deep_encode_utf8($_) for @$v;
    } elsif (ref($v) eq 'HASH') {
        #$_ = deep_decode_utf8($_) for values %$v;
        $v->{encode_utf8($_)} = deep_encode_utf8(delete $v->{$_}) for keys %$v;
    } elsif (!ref $v) {
        $v = encode_utf8($v);
    }
    return $v;
}

{

# содержит информацию, вызывали ли мы srand для текущего процесса
my $called_srand;

=head2 get_random_string

    Генерирует случайную строку с префиксом (если передан)
        Параметры именованные:
        prefix - префикс случайной строки (default = '')
        alphabets - параметры выбора символов, из которых будет состоять строка, (default = wWds)
            w - маленькие латинские буквы
            W - большие латинские буквы
            d - цифры
            s - спецсимволы
        length - итоговая длина строки (включая префикс) (default = 10)

=cut

sub get_random_string {
    my %O = @_;

    # значения по умолчанию
    $O{length} ||= 10;
    $O{prefix} ||= '';
    $O{alphabets} ||= 'wWds';

    # собираем алфавит
    my $symbols = {
        'w' => 'abcdefghijklmnopqrstuvwxyz',
        'W' => 'ABCDEFGHIJKLMNOPQRSTUVWXYZ',
        'd' => '0123456789',
        's' => '!@#$%^&*()_+,.'
    };

    my $alphabet = join ('', @{$symbols}{split('', $O{alphabets})});

    # усекаем префикс, если его длина не позволяет сгенерировать 6 и более случайных символов
    if (length($O{prefix}) > $O{length} - 6) {
        $O{prefix} = substr($O{prefix}, 0, $O{length} - 6);
    }

    if (! defined $called_srand || $called_srand != $$) {
        srand();
        $called_srand = $$;
    }

    my $random = join '', map { substr($alphabet, int(rand(length($alphabet))), 1) } (1 .. ($O{length} - length($O{prefix})));

    return join '', $O{prefix}, $random;
}

}
