#!/usr/bin/python
# -*- coding: utf8 -*-

import requests
from datetime import date, datetime, timedelta
import argparse


BOUND1, BOUND2 = 40000.0, 60000.0
CHUNK_SIZE = 100
CHUNKS = 2000
# из графиков предположил, что значения больше 2000*100 не встречаются

groups = ["ci%", "ppcsoap%", "ppcscripts%", "ppcback%", "%-24470_vm_search", "%-21909_vm_search", "%-31790_vm_search", "%-17218_vm_search", "%-16800_vm_search", "%-25439_vm_search", "%-16791_vm_search", "%-24490_vm_search"]


def run():
    #timestamps
    l_ts = int((datetime(year=2017, month=8, day=1, hour=0, minute=0, second=0) - datetime.fromtimestamp(0)).total_seconds())
    r_ts = int((datetime(year=2017, month=11, day=1, hour=0, minute=0, second=0) - datetime.fromtimestamp(0)).total_seconds())
    # Пока тут берется фиксированный период времени: 2017-08-01 .. 2017-10-31. Можно сделать это параметрами

    paths = []
#    for gr in groups:
#        data = "select Path from graphite_d where Path like 'one_min.direct._hosts.%s.trace.bsrank:bsrank_call.all_ela' and Time = %d and Date = toDate('%s')" % (gr, r_ts, str(date.fromtimestamp(r_ts)))
#        r = requests.post("http://ppcgraphite-storage.yandex.net:8123/", data=data, auth=('readonly', ''), stream=True)
#        paths += r.text.strip().split()
#    for p in paths:
#        print p
    with open('auction_paths', 'r') as f:
        paths = f.read().split()

    mins_of_val = [0] * CHUNKS  # mins_of_val[k] - число минут, когда значение в промежутке [ k*CHUNK_SIZE; (k+1)*CHUNK_SIZE )
    with open('stats_auction_08_10', 'w') as f:
        while l_ts < r_ts:
            f.write(str(datetime.fromtimestamp(l_ts))+' ')
            val = 0.0   # sum of metrics
            for path in paths:
                try:
                    data = "select Value from graphite_d where Path = '%s' and Time >= %d and Time < %d" % (path, l_ts, l_ts+60)
                    r = requests.post("http://ppcgraphite-storage.yandex.net:8123/", data=data, auth=('readonly', ''), stream=True)
                    s = r.text.strip()
                    x = 0.0
                    if s:
                        x = float(s)
                    val += x
                except:
                    print r.text
            f.write("%f" % val)
            if val > BOUND2:
                f.write(" FAIL")
            elif val > BOUND1:
                f.write(" BAD")
            f.write("\n")
            
            k = int(val) / CHUNK_SIZE
            mins_of_val[k] += 1
            l_ts += 60

    with open('distrib_auction_08_10', 'w') as f:
        for i in xrange(CHUNKS):
            f.write("%d %d\n" % (i*CHUNK_SIZE, mins_of_val[i]))


if __name__ == '__main__':
    run()
