#!/usr/bin/python
# -*- coding: utf8 -*-

import requests
from datetime import datetime, timedelta
import argparse


BOUND = 1000.0

reps = ['01e', '01f', '01h', '01i', '02f']  # взято из графитовых графиков


def run():
    parser = argparse.ArgumentParser()
    parser.add_argument("ppcdata", help="shard", type=int, choices=range(1, 13))
    #parser.add_argument("start_month", type=int, choices=range(1, 13))
    #parser.add_argument("end_month", type=int, choices=range(1, 13))
    args = parser.parse_args()
    # Пока тут берется фиксированный период времени: 2017-01-01 .. 2017-06-30 (1-ое полугодие 2017). Можно сделать это параметрами, как написано выше
    
    #timestamps
    l_ts = int((datetime(year=2017, month=1, day=1, hour=0, minute=0, second=0) - datetime.fromtimestamp(0)).total_seconds())
    r_ts = int((datetime(year=2017, month=7, day=1, hour=0, minute=0, second=0) - datetime.fromtimestamp(0)).total_seconds())
    mins_unavailable = 0
    f = open('stats_ppcdata%d_01_06' % args.ppcdata, 'w')
    while l_ts < r_ts:
        f.write(str(datetime.fromtimestamp(l_ts))+' ')
        mx = 0.0
        for rep in reps:
            try:
                data = "select Value from graphite_d where Path = 'one_min.ppcdata%d-%s_yandex_ru.mysqlqps_ppcdata%d.qps' and Time >= %d and Time < %d" % (args.ppcdata, rep, args.ppcdata, l_ts, l_ts+60)
                r = requests.post("http://ppcgraphite-storage.yandex.net:8123/", data=data, auth=('readonly', ''), stream=True)
                s = r.text.strip()
                val = 0.0
                if s:
                    val = float(s)
                mx = max(mx, val)
            except:
                print r.text
        f.write("%f" % mx)
        if mx < BOUND:
            f.write(" BAD")
            mins_unavailable += 1
        f.write("\n")
        l_ts += 60
    
    #print mins_unavailable
    f.close()


if __name__ == '__main__':
    run()
