#!/usr/bin/python

import requests
from datetime import datetime, timedelta
import argparse


#CHUNKS = 2000
CHUNK_SIZE = 100

vhosts = {"direct.yandex.ru": 600, "api.direct.yandex.ru": 2000, "intapi.direct.yandex.ru": 600, "java-web.direct.yandex.net": 100, "java-api.direct.yandex.ru": 600, "java-intapi.direct.yandex.ru": 100}



def run():
    parser = argparse.ArgumentParser()
    parser.add_argument("vhost", type=str, choices=vhosts.keys())
    parser.add_argument("start_month", type=int, choices=range(1, 13))
    parser.add_argument("end_month", type=int, choices=range(1, 13))
    # year 2017
    args = parser.parse_args()
    CHUNKS = vhosts[args.vhost]

    l_date = datetime(year=2017, month=args.start_month, day=1, hour=0, minute=0, second=0)
    for month in xrange(args.start_month,args.end_month+1):
        r_date = datetime(year=2017, month=month+1, day=1, hour=0, minute=0, second=0)
        rpm_month = [0] * CHUNKS

        while l_date < r_date:
            data = "select count() from ppclogpusher.logs_direct where vhost = '%s' and toStartOfMinute(date) = toDateTime('%s')" % (args.vhost, l_date.isoformat(' '))
            try:
                r = requests.post("http://ppcgraphite-storage.yandex.net:8123/", data=data, auth=('readonly', ''), stream=True)
                s = r.text.strip()
                k = 0
                if s:
                    k = int(s) / CHUNK_SIZE
                rpm_month[k] += 1
            except:
                print r.text
            l_date += timedelta(minutes=1)

        fn = '%s_17_' % args.vhost
        if month < 10:
            fn += '0%s' % month
        else:
            fn += '%s' % month
        with open(fn, 'w') as f:
            for i in xrange(CHUNKS):
                f.write("%s %s\n" % (i*CHUNK_SIZE, rpm_month[i]))





if __name__ == '__main__':
    run()
