package BEM::Builder;
use strict;
use warnings;

use BEM::Builder::Make;
use BEM::Builder::Tools;

my %COMMAND_MAP = (
    make        => \&make,
    clean_cache => \&clean_cache,
);

sub run_command {
    my ( $name, $config ) = @_;

    my $handler = $COMMAND_MAP{$name} or die "Invalid command $name\n";
    return $handler->($config);
}

sub make {
    my ($config) = @_;
    return BEM::Builder::Make::run($config);
}

sub clean_cache {
    my ($config) = @_;
    my $cache_info = BEM::Builder::Tools::get_cache_info($config);

    BEM::Builder::Tools::clean_cache(
        cache_root => $cache_info->{cache_root},
        groups     => [ map { $_->{cache_group} } @{ $config->{make_actions} } ],
        logdir     => $config->{logdir},
        exp_days   => $config->{cache_expire_after_days},
    );

    return 0;
}

1;
