use strict;
use warnings;

package BetaPorts;


# $Id$


=head1 NAME


=head1 DESCRIPTION


=cut

use Data::Dumper;
use List::MoreUtils qw{ firstval uniq};
use Yandex::Hostname;

use utf8;

our $BETAS_BASE_DIR = "/var/www";
our $RESERVE_BASE_DIR = "$BETAS_BASE_DIR/reserve";

our %RESERVED = (
    'ppcdev1.yandex.ru' => {
        '*' => [8000 .. 8399, 8401 .. 8499, 8501 .. 8999],
        'non-human' => [8000 .. 8009, 8010 .. 8019, 8990 .. 8995, 8997, 8999],
        auto => [8970 .. 8989],     # зарезервированы, но реально не используются
        autobeta => [8020 .. 8029, 8780 .. 8799, 8996, 8998], # диапазон для автобет 2.0
        'mediaplan' => [8470 .. 8479],    # для медиапланов в cocaine

        'a-urukov' => [8120 .. 8129],
        'aleks-konst' => [8960 .. 8969],
        'alex-sannikov' => [8830 .. 8839],
        'alkaline' => [8160 .. 8169],
        'adubinkin' => [8240 .. 8249],
        'beet' => [ 8315 .. 8319 ],
        'belyanskii' => [8440 .. 8449],
        'coffeeich' => [8850 .. 8859],
        'collapsus' => [8100 .. 8109],
        'dima117a' => [8110 .. 8119],
        'dimitrovsd' => [8280 .. 8289],
        'direvius' => [8210 .. 8214],
        'eboguslavskaya' => [8550 .. 8574],
        'elwood' => [8635 .. 8639],
        'evolkowa' => [8350 .. 8359],
        'esokirkina' => [8088 .. 8089],
        'freakbelka' => [8640 .. 8644],
        'gerdler' => [8450 .. 8459],
        'vitalij-kov' => [8460 .. 8469],
        'gorbatov' => [8200 .. 8204],
        'heliarian' => [8300 .. 8309],
        'johnbuevich' => [8076 .. 8079],
        'korichevalex' => [8810 .. 8819],
        'kuhtich' => [8945 .. 8949],
        'lento4ka' => [8040 .. 8049],
        'mestet' => [8645 .. 8649],
        'mirage' => [8030 .. 8039],
        'mrronuar' => [8950 .. 8959],
        'pavryabov' => [8940 .. 8944],
        'ppalex' => [8600 .. 8604],
        'prof' => [8190 .. 8199],
        'pe4kin' => [8150 .. 8154],
        'ruzhansky' => [8870 .. 8879],
        'sandramav' => [8130 .. 8139],
        'santama' => [8650 .. 8654],
        'sco76' => [8320 .. 8329, 8370 .. 8379],
        'skirsanov' => [8655 .. 8659],
        'sshin278' => [8270 .. 8279],
        'sskorn' => [8380 .. 8389],
        'snaury' => [8060 .. 8069],
        'snirinn' => [8660 .. 8664],
        'vyuhim' => [8820 .. 8829],
        'yukaba' => [8420 .. 8429],
        'zakhar'=> [ 8310 .. 8314 ],
        'maxlog' => [8890 .. 8899],
        'a-lobanova' => [8700 .. 8709],
        'vovichek62'=> [8073 .. 8075],
        'avzaykov' => [8840 .. 8849],
        'marfuzzi' => [8900 .. 8909],
        'angryobj' => [8590 .. 8599],
        'tgnc' => [8290 .. 8299],
        'peterpiskizhe' => [8520 .. 8529],
        'andreypav' => [8530 .. 8539],
        'matyushin' => [8540 .. 8549],
        'ilya777grin23' => [8860 .. 8869],
    },
    'ppcdev2.yandex.ru' => {
        '*'              => [9000 .. 9999],
        'non-human'      => [9990 .. 9999],
        auto             => [9970 .. 9989],     # зарезервированы, но реально не используются
        autobeta         => [9940 .. 9969],
        'mediaplan'      => [9470 .. 9479],

        # список отсортирован по алфавиту, поддерживайте сортировку, пожалуйста
        'a-lobanova'     => [9700 .. 9709],
        'a-urukov'       => [9130 .. 9139],
        'adubinkin'      => [9205 .. 9209],
        'ajkon'          => [9380 .. 9389],
        'aleks-konst'    => [9890 .. 9899],
        'alkaline'       => [9160 .. 9169],
        'andreymak'      => [9040 .. 9049],
        'artra'          => [9530 .. 9539],
        'artyrian'       => [9440 .. 9445],
        'belyanskii'     => [9500 .. 9509],
        'coffeeich'      => [9911 .. 9919],
        'collapsus'      => [9100 .. 9109],
        'dima117a'       => [9210 .. 9219],
        'dimitrovsd'     => [9070 .. 9079],
        'eboguslavskaya' => [9550 .. 9574],
        'esokirkina'     => [9203 .. 9204, 9125 .. 9129],
        'gerdler'        => [9250 .. 9259],
        'heliarian'      => [9300 .. 9309],
        'invizor'        => [9280 .. 9289],
        'johnbuevich'    => [9360 .. 9369],
        'kovalp'         => [9865 .. 9869],
        'kvlasov'        => [9270 .. 9279],
        'lakate'         => [9860 .. 9864],
        'lento4ka'       => [9080 .. 9089],
        'mirage'         => [9030 .. 9039],
        'n-svoykina'     => [9880 .. 9889],
        'ollven'         => [9200],
        'palasonic'      => [9350 .. 9359],
        'ppalex'         => [9600 .. 9604],
        'pe4kin'         => [9340 .. 9349],
        'qwdm'           => [9496 .. 9499],
        'rivik'          => [9310 .. 9319],
        'ruzhansky'      => [9870 .. 9879],
        'sandramav'      => [9430 .. 9439],
        'santama'        => [9906 .. 9910],
        'slepo'          => [9370 .. 9379],
        'sco76'          => [9320 .. 9329],
        'snaury'         => [9420 .. 9429],
        'ssor96'         => [9520 .. 9529],
        'sudar'          => [9201],
        'tau-chieftain'  => [9060 .. 9069],
        'upcfrost'       => [9920 .. 9929],
        'vazgen'         => [9240 .. 9249],
        'yarashid'       => [9590 .. 9599],
        'yukaba'         => [9540 .. 9549],
        'vrozaev'        => [9575 .. 9579],
        # список отсортирован по алфавиту, поддерживайте сортировку, пожалуйста
    },
    'ppcdev3.yandex.ru' => {
        '*'              => [10000 .. 10999],
        'autobeta'       => [10960 .. 10989],
        'mediaplan'      => [10470 .. 10479],

        # Список портов на ppcdev3 исторически отсортирован по первому порту
        'ilya777grin23'  => [10010 .. 10019],
        'lento4ka'       => [10020 .. 10029],
        'mirage'         => [10030 .. 10039],
        'lagunov'        => [10051 .. 10059],
        'vitalij-kov'    => [10060 .. 10069],
        'antonpudikov'   => [10070 .. 10079],
        'collapsus'      => [10100 .. 10109],
        'heliarian'      => [10110 .. 10119],
        'a-urukov'       => [10120 .. 10129],
        'evolkowa'       => [10130 .. 10139],
        'belyanskii'     => [10140 .. 10149],
        'akimov'         => [10150 .. 10159],
        'artyrian'       => [10240 .. 10245],
        'ovazhnev'       => [10246 .. 10250],
        'kaero'          => [10255 .. 10259],
        's-mamchits'     => [10270 .. 10279],
        # Список портов на ppcdev3 отсортирован по первому порту
        'prof'           => [10300 .. 10309],
        'sco76'          => [10320 .. 10329],
        'snaury'         => [10420 .. 10429],
        'alkaline'       => [10440 .. 10449],
        'gerdler'        => [10450 .. 10459],
        'andreypav'      => [10530 .. 10539],
        'yukaba'         => [10540 .. 10549],
        'adubinkin'      => [10560 .. 10569],
        'eboguslavskaya' => [10570 .. 10579],
        'sskorn'         => [10580 .. 10589],
        'ppalex'         => [10600 .. 10604],
        'aevd'           => [10700 .. 10709],
        'a-lobanova'     => [10710 .. 10719],
        'remez'          => [10340 .. 10349],
        'tgnc'           => [10350 .. 10359],
        'tau-chieftain'  => [10360 .. 10369],
        'marfuzzi'       => [10780 .. 10789],
        'maxlog'         => [10800 .. 10809],
        'andreymak'      => [10840 .. 10849],
        'coffeeich'      => [10850 .. 10859],
        'klesteralexey'  => [10860 .. 10869],
        'ruzhansky'      => [10870 .. 10879],
        'vrozaev'        => [10940 .. 10949],
        'aleks-konst'    => [10990 .. 10998],
        # Список портов на ppcdev3 отсортирован по первому порту
    },
    'ppcdev4.yandex.ru' => {
        '*'              => [11000 .. 11999],
        'non-human'      => [11990 .. 11999],
        'autobeta'       => [11960 .. 11989],
        'mediaplan'      => [11470 .. 11479],

        # список примерно отсортирован по алфавиту
        'a-lobanova'     => [11700 .. 11709],
        'a-urukov'       => [11120 .. 11129],
        'aleks-konst'    => [11660 .. 11669],
        'alkaline'       => [11160 .. 11169],
        'andreymak'      => [11010 .. 11029],
        'asavanovich'    => [11316 .. 11319],
        'belyanskii'     => [11440 .. 11449],
        'binarin'        => [11150 .. 11159, 11860 .. 11869],
        'coffeeich'      => [11850 .. 11859],
        'collapsus'      => [11210 .. 11219],
        'dimitrovsd'     => [11190 .. 11199],
        'eboguslavskaya' => [11550 .. 11569],
        'gerdler'        => [11450 .. 11459],
        'gorbatov'       => [11200 .. 11204],
        'heliarian'      => [11300 .. 11309],
        'johnson'        => [11280 .. 11299],
        # список примерно отсортирован по алфавиту
        'klesteralexey'  => [11390 .. 11399],
        'lagunov'        => [11340 .. 11349],
        'lento4ka'       => [11040 .. 11049],
        'martynovdi'     => [11130 .. 11139],
        'meridian'       => [11070 .. 11072],
        'mirage'         => [11030 .. 11039],
        'monoid'         => [11310 .. 11315],
        'mspirit'        => [11370 .. 11379],
        'toggle-jun'     => [11380 .. 11389],
        'trishlex'       => [11060 .. 11069],
        'ngavrilova'     => [11073 .. 11074],
        'n-svoykina'     => [11330 .. 11339],
        'ppalex'         => [11100 .. 11119],
        'pe4kin'         => [11510 .. 11514],
        'prof'           => [11530 .. 11539],
        'sandramav'      => [11515 .. 11519],
        'sco76'          => [11320 .. 11329],
        'simfarsenio'    => [11270 .. 11279],
        'snaury'         => [11075 .. 11079],
        'sskorn'         => [11205 .. 11209],
        'upcfrost'       => [11350 .. 11359],
        'vakoy'          => [11230 .. 11249],
        'yukaba'         => [11420 .. 11429],
        'qavaleria'      => [11460 .. 11469],
        'tgnc'           => [11520 .. 11529],
        # список примерно отсортирован по алфавиту
    },
    'ppcdev5.yandex.ru' => {
        '*'              => [12000 .. 12999],
        'non-human'      => [12990 .. 12999],
        auto             => [12950 .. 12989],
        ppc              => [12850 .. 12949, 12345],
        mediaplan        => [12840 .. 12849],

        'aleks-konst'    => [12390 .. 12399],
        'yukaba'         => [12352 .. 12353],
        'rinatous'       => [12280 .. 12289],

        "aleran"         => [12020 .. 12029],
        "aspichueva"     => [12190 .. 12199],
        "buhter"         => [12030 .. 12039],
        "caesarea"       => [12014 .. 12016],
        "ginger"         => [12050 .. 12059],
        "i-pokusaev"     => [12290 .. 12299],
        "ilya777grin23"  => [12300 .. 12309],
        "kturchak"       => [12160 .. 12169],
        "kuhtich"        => [12060 .. 12069],
        "l-jul"          => [12310 .. 12319, 12358 .. 12359],
        "elwood"         => [12360 .. 12361],
        "larilena"       => [12346 .. 12347],
        "edip-asanov"    => [12338 .. 12339],
        "trapitsyn"       => [12180 .. 12189],
        "mexicano"       => [12080 .. 12089],
        "ngavrilova"     => [12170 .. 12179],
        "olimiya"        => [12250 .. 12259],
        "ollven"         => [12332 .. 12335],
        "omaz"           => [12090 .. 12099],
        "ovazhnev"       => [12200 .. 12204],
        "pashkus"        => [12150 .. 12159],
        "pavryabov"      => [12100 .. 12109],
        "popovskii"      => [12260 .. 12264],
        "qavaleria"      => [12145 .. 12149, 12356 .. 12357],
        "raketa"         => [12340 .. 12341],
        "sandramav"      => [12275 .. 12279],
        "s-golovanova"   => [12265 .. 12274],
        "silver"         => [12040 .. 12049],
        "simfarsenio"    => [12362 .. 12369],
        "sonch"          => [12010 .. 12011],
        "sourx"          => [12012 .. 12013],
        "ssdmitriev"     => [12110 .. 12119],
        "sudar"          => [12336 .. 12337],
        "vananos"        => [12240 .. 12249],
        "xy6er"          => [12120 .. 12129],
        'vitalij-kov'    => [12130 .. 12139],
        "zakhar"         => [12342 .. 12343],

        "gerdler"        => [12354 .. 12355],
        "sco76"          => [12320 .. 12321],
        "ajkon"          => [12370 .. 12379],
        "irineva"        => [12380 .. 12384],
        "aevd"           => [12385 .. 12389],
        "xikxp1"         => [12410 .. 12419],
        "kirill-ign"     => [12420 .. 12429],
        "jensenspb"      => [12430 .. 12435],
        "dimazoll"       => [12550 .. 12559],
    },
    'ppcdev6.yandex.ru' => {
        '*'              => [13000 .. 13999],
        'non-human'      => [13990 .. 13999],
        'autobeta'       => [13960 .. 13989],
        'ppc'            => [13100 .. 13119, 13590 .. 13599, 13620 .. 13689],
        'mediaplan'      => [13470 .. 13479],

        # порты на ppcdev6 были некогда отсортированы по логинам по алфавиту
        'a-lobanova'     => [13700 .. 13709],
        'a-urukov'       => [13120 .. 13129],
        'aleks-konst'    => [13800 .. 13809],
        'alkaline'       => [13160 .. 13169],
        'belyanskii'     => [13440 .. 13449],
        'binarin'        => [13150 .. 13159, 13860 .. 13869],
        'coffeeich'      => [13850 .. 13859],
        'collapsus'      => [13210 .. 13219],
        'dima117a'       => [13080 .. 13089],
        'dmitriy-ch'     => [13280 .. 13289],
        'eboguslavskaya' => [13550 .. 13569],
        'evolkowa'       => [13130 .. 13139],
        'gerdler'        => [13450 .. 13459],
        'gorohovsky'     => [13240 .. 13249],
        'heliarian'      => [13300 .. 13309],
        'i-pokusaev'     => [13290 .. 13299],
        'klesteralexey'  => [13480 .. 13489],
        'lagunov'        => [13200 .. 13209, 13490 .. 13499],
        'lento4ka'       => [13040 .. 13049],
        'marfuzzi'       => [13950 .. 13959],
        'meridian'       => [13070 .. 13072],
        'mirage'         => [13030 .. 13039],
        'mspirit'        => [13340 .. 13349],
        'trishlex'       => [13060 .. 13069],
        'monoid'         => [13830 .. 13834],
        'ppalex'         => [13600 .. 13604],
        'ruzhansky'      => [13270 .. 13279],
        'sco76'          => [13320 .. 13329],
        'simfarsenio'    => [13190 .. 13199],
        'snaury'         => [13075 .. 13079],
        'snirinn'        => [13925 .. 13929],
        'sskorn'         => [13230 .. 13239],
        'toggle-jun'     => [13350 .. 13359],
        'yukaba'         => [13420 .. 13429],
        # при добавлении нового в список: порты на ppcdev6 разбиты по группам и ≈ отсортированы по логинам по алфавиту

        # порты тестировщиков
        "aevd"       => [13710 .. 13714],
        "aleran"     => [13010 .. 13014],
        "buhter"     => [13820 .. 13824],
        "caesarea"   => [13025 .. 13029],
        "ginger"     => [13835 .. 13839],
        "kturchak"   => [13840 .. 13844],
        "kuhtich"    => [13845 .. 13849],
        "larilena"   => [13870 .. 13874],
        "edip-asanov"=> [13875 .. 13879],
        "trapitsyn"   => [13885 .. 13889],
        "mexicano"   => [13890 .. 13894],
        "ngavrilova" => [13895 .. 13899],
        "ollven"     => [13900 .. 13904],
        "omaz"       => [13905 .. 13909],
        "pashkus"    => [13910 .. 13914],
        "pavryabov"  => [13915 .. 13919],
        "raketa"     => [13920 .. 13924],
        "silver"     => [13015 .. 13019],
        "sonch"      => [13930 .. 13934],
        "sourx"      => [13935 .. 13939],
        "ssdmitriev" => [13020 .. 13024],
        "sudar"      => [13940 .. 13944],
        "xy6er"      => [13945 .. 13949],

        # порты разработчиков
        "avzaykov"   => [13510 .. 13519],
        "faustkun"   => [13370 .. 13379],
        "ovazhnev"   => [13605 .. 13609],
        "xikxp1"     => [13380 .. 13389],
        "kirill-ign" => [13390 .. 13399],
    },
    'ppcdev7.yandex.ru' => {
        '*'              => [14000 .. 14999],
        'non-human'      => [14990 .. 14999],
        'autobeta'       => [14960 .. 14989],
        ppc              => [14600 .. 14699],
        'obi-wan'        => [14540 .. 14549],
        'aleks-konst'    => [14560 .. 14569],
        'lagunov'        => [14445 .. 14449],
        'zakhar'         => [14020 .. 14029],
        'sco76'          => [14320 .. 14329],
        'aevd'           => [14490 .. 14494],
        'antonpudikov'   => [14495 .. 14499],
        'ppalex'         => [14440 .. 14444],
        'pe4kin'         => [14016 .. 14019],
        'gerdler'        => [14450 .. 14459],
        'mariachernova'  => [14460 .. 14469],
        'sagid-m'         => [14530 .. 14539],
        'maxlog'         => [14800 .. 14809],
        'dima117a'       => [14810 .. 14819],
        'dimazoll'       => [14550 .. 14559],
        'kuhtich'        => [14820 .. 14829],
        'mexicano'       => [14840 .. 14849],
        'esokirkina'     => [14850 .. 14859],
        'pavryabov'      => [14860 .. 14869],
        'buhter'         => [14870 .. 14879],
        'alkaline'       => [14470 .. 14479],
        'vrozaev'        => [14700 .. 14709],
        'invizor'        => [14710 .. 14719],
        'vitalij-kov'    => [14720 .. 14729],
        'lento4ka'       => [14740 .. 14749],
        'faustkun'       => [14750 .. 14759],
        'xikxp1'         => [14760 .. 14769],
        'kirill-ign'     => [14770 .. 14779],
        'klesteralexey'  => [14480 .. 14489],
        'yukaba'         => [14946 .. 14949],
        'ilya777grin23'  => [14790 .. 14799],
        'andreypav'      => [14950 .. 14959],
        'ammsaid'        => [14570 .. 14575],

        # порты тестировщиков
        'sudar'          => [14880 .. 14884],
        'larilena'       => [14885 .. 14889],
        'vananos'        => [14890 .. 14894],
        'kturchak'       => [14895 .. 14899],
        'olimiya'        => [14900 .. 14904],
        'qavaleria'      => [14905 .. 14909],
        'raketa'         => [14910 .. 14914],
        'l-jul'          => [14915 .. 14919],
        'sonch'          => [14920 .. 14924],
        'ngavrilova'     => [14925 .. 14929],
        's-golovanova'   => [14930 .. 14934],
        'irineva'        => [14935 .. 14939],
        'jensenspb'      => [14940 .. 14945],
    },

    'gtxdev1.yandex.ru' => {
        '*'          => [8000 .. 8999],
        'autobeta'   => [8960 .. 8989],

        'abtest'     => [8080 .. 8089],
        'azhakov'    => [8700 .. 8704],
        'amikish'    => [8705 .. 8709],
        'collapsus'  => [8140 .. 8149],
        'dima117a'   => [8130 .. 8139],
        'yukaba'     => [8420 .. 8429],
        'evolkowa'   => [8090 .. 8099],
    },
    'ppcmoddev1-new.yandex.ru' => {
        '*'                    => [8000 .. 8999],
        'non-human'            => [8900 .. 8909],
        'mirage'               => [8001 .. 8009, 8040 .. 8060],
        'lento4ka'             => [8061 .. 8070],
        'belyanskii'           => [8101 .. 8110],
        'andreymak'            => [8120 .. 8129],
        'meridian'             => [8400 .. 8419],
        'yukaba'               => [8420 .. 8429],
        'xy6er'                => [8430 .. 8439],
        'robot-moderation-tst' => [8440 .. 8449],
        'autobeta'             => [8780 .. 8799],
        'auto'                 => [8970 .. 8989],
        'heliarian'            => [8130 .. 8139],
        'beet'                 => [8810 .. 8820],
        'antilost'             => [8210 .. 8219],
        'qavaleria'            => [8821 .. 8829],
    },
    'ppcmoddev2.yandex.ru' => {
        '*'                    => [9000 .. 9999],
        'raketa'               => [9020 .. 9039],
        'non-human'            => [9900 .. 9909],
        'mirage'               => [9001 .. 9009, 9040 .. 9060],
        'lento4ka'             => [9061 .. 9070],
        'belyanskii'           => [9101 .. 9110],
        'sco76'                => [9320 .. 9322],
        'meridian'             => [9400 .. 9419],
        'yukaba'               => [9420 .. 9429],
        'xy6er'                => [9430 .. 9439],
        'robot-moderation-tst' => [9440 .. 9449],
        'pashkus'              => [9450 .. 9459],
        'autobeta'             => [9780 .. 9799],
        'gerdler'              => [9251 .. 9260],
        'ppalex'               => [9600 .. 9619],
        'gorohovsky'           => [9560 .. 9599],
        'auto'                 => [9970 .. 9989],
        'dima117a'             => [9010 .. 9019],
        'coffeeich'            => [9081 .. 9090],
        'alkaline'             => [9990 .. 9999],
        'vovichek62'           => [9111 .. 9114],
        'evolkowa'             => [9231 .. 9241],
        'beet'                 => [9115 .. 9129],
        'heliarian'            => [9130 .. 9139],
        'linoge'               => [9391 .. 9399],
        'collapsus'            => [9910 .. 9915],
        'a-urukov'             => [9150 .. 9159],
        'iakolzin'             => [9242 .. 9250],
        'qwdm'                 => [9220 .. 9230],
        'losev'                => [9170 .. 9179],
        'andreymak'            => [9180 .. 9189],
        'larilena'             => [9210 .. 9219],
        'antilost'             => [9261 .. 9269],
        'artra'                => [9490 .. 9499],
        'popovskii'            => [9476 .. 9479],
        'qavaleria'            => [9820 .. 9829],
        'ilya777grin23'        => [9000 .. 9000],
    },
);

our %ALIASES = (
    'ppcdev1.yandex.ru' => [qw/
        ppcdev-precise.yandex.ru
        ppcdev1.da.yandex.ru
        /],
    'ppcdev2.yandex.ru' => [qw/
        ppcdev.yandex.ru
        ppcdev2.da.yandex.ru
        /],
    'ppcdev3.yandex.ru' => [qw/
        ppcdev3.da.yandex.ru
        /],
    'ppcdev4.yandex.ru' => [qw/
        ppcdev4.da.yandex.ru
        /],
    'ppcdev5.yandex.ru' => [qw/
        ppcdev5.da.yandex.ru
        /],
    'ppcdev6.yandex.ru' => [qw/
        ppcdev6.da.yandex.ru
        /],
    'ppcdev7.yandex.ru' => [qw/
        ppcdev7.ppc.yandex.ru
        /],
    'gtxdev1.yandex.ru' => [qw/
        beta1.geocontext.yandex.ru
        /],
    'ppcmoddev1-new.yandex.ru' => [qw/
        ppcmoddev1.yandex.ru
        /],
);

for my $host (sort keys %ALIASES){
    die "unknown host $host" unless exists $RESERVED{$host};
    for my $alias ( @{$ALIASES{$host}} ){
        $RESERVED{$alias} = $RESERVED{$host};
    }
}


=head2 get_free_beta

    Возвращает один свободный номер из зарезервированных за указанным пользователе
    т.е. номер, с которым можно создать бету для указанного пользователя

    Если у пользователя нет зарезервированных номеров или все уже заняты -- умирает

    $port = get_free_beta( for => "lena-san");


=cut
sub get_free_beta
{
    my %O = @_;

    my $reserved_ports = get_reserved_ports(%O);

    my %used = ( map {$_ => 1} grep {/^\d+$/} map {s/.*\.(\d{4,5})$/$1/; $_} split "\n", `ls $BETAS_BASE_DIR 2>/dev/null` );

    my $p = firstval {!$used{$_}} @$reserved_ports or die "no free ports available for $O{for}";

    return $p;
}


=head2 get_used_paths

    Возвращает ссылку на массив строк.
    Полные пути ко всем бетам пользователя, указанного в параметре for

=cut
sub get_used_paths
{
    my %O = @_;
    my $current_host = current_host(); 
    die "no ports specified for '$O{for}', host '$current_host'" if !$O{for} || !exists $RESERVED{$current_host}->{$O{for}};

    my %reserved = map {$_ => 1} @{$RESERVED{$current_host}->{$O{for}}};

    my @used = ( map {/\.(\d{4,5})$/ ; $1 && $reserved{$1} ? $_ : () } split "\n", `ls -d $BETAS_BASE_DIR/* 2>/dev/null` );

    return \@used;
}


=head2 get_used_ports

    возвращает ссылку на массив чисел
    Порты, занятые бетами пользователя, указанного в параметре for

=cut
sub get_used_ports
{
    my %O = @_;

    my $used_paths = get_used_paths( for => $O{for} );
    my @used_ports = map { /.*\.(\d{4,5})$/ ? $1 : () } @$used_paths;

    return \@used_ports;
}


=head2 get_reserved_ports

    возвращает ссылку на массив чисел (или на пустой массив)
    Порты, зарезервированные под беты пользователя, указанного в параметре for

    $ports = get_reserved_ports(for => "lena-san");

    Параметры:
    for

=cut
sub get_reserved_ports
{
    my %O = @_;

    die "illegal 'for' value: '$O{for}', stop" if !$O{for};

    my $current_host = current_host(); 

    my @reserved_from_code = ();
    if ( $O{for} eq '*' ){
        # если хотим порты, зарезервированные за кем-либо -- обходим всех содержательные записи в %RESERVED
        for my $consumer ( keys %{$RESERVED{$current_host}||{}} ){
            next if $consumer eq '*';
            push @reserved_from_code, @{$RESERVED{$current_host}->{$consumer} || []}
        }
    } else {
        # если хотим порты одного потребителя -- смотрим запись про него
        @reserved_from_code = @{$RESERVED{$current_host}->{$O{for}}||[]};
    }

    my $login_re = $O{for} eq '*' ? '*' : "\Q$O{for}\E";
    my @reserved_from_fs = ();
    if ( ! -e $RESERVE_BASE_DIR || ! -d $RESERVE_BASE_DIR ){
        # ничего не делаем, здесь нет резерва на ФС 
    } else{
        # почти повторяется с get_fs_owners_ports
        @reserved_from_fs = ( map {/\.(\d{4,5})$/ ? $1 : () } split "\n", `ls -d $RESERVE_BASE_DIR/reserve\.$login_re\.* 2>/dev/null` );
    } 

    my %reserved = map { $_ => 1 } ( @reserved_from_code, @reserved_from_fs );

    my @reserved = (sort keys %reserved);

    return \@reserved;
}


=head2 get_fs_owners_ports

    возвращает ссылку на хеш "владелец => список хостов"

=cut
sub get_fs_owners_ports
{
    # если здесь нет резерва на ФС -- выходим
    return {} if ( ! -e $RESERVE_BASE_DIR || ! -d $RESERVE_BASE_DIR );

    # хеш "порт => владелец"
    # коллизии не ловим, если один порт зарезериврован двоими -- запишется к обоим
    my %reserved;
    for my $line ( split "\n", `ls -d $RESERVE_BASE_DIR/reserve\.* 2>/dev/null` ){
        next unless $line =~ m!.*/reserve\.([a-z0-9\-]*)\.(\d{4,5})$!i;
        push @{$reserved{$1}}, $2;
    }

    return \%reserved;
}


=head2 get_ports_pool

    возвращает ссылку на массив с всеми портами, отведенными под беты на текущем сервере

=cut
sub get_ports_pool
{
    my $current_host = current_host(); 
    my $pool = $RESERVED{$current_host}->{'*'} || [];

    return $pool;
}


=head2 reserve_ports

=cut
sub reserve_ports
{
    my ($ports_arr, %O) = @_;

    die "illegal 'for' value: '$O{for}', stop" if $O{for} !~ /^[a-z0-9\-]+$/;

    my $res = {
        success => [],
        errors => {},
    };

    my %in_pool  = map { $_ => 1 } @{get_ports_pool()};
    my %reserved = map { $_ => 1 } @{get_reserved_ports( for => '*' )};

    for my $p ( @$ports_arr ){
        if ( ! $in_pool{$p} ){
            $res->{errors}->{$p} = "port $p not in pool for current host";
            next;
        }

        my $lock_dir = "$RESERVE_BASE_DIR/lock.$p";
        # берем лок против одновременного резервирования одного и того же порта
        if ( ! mkdir $lock_dir){
            $res->{errors}->{$p} = "can't get lock for reserving port $p, details: $!";
            next;
        }

        # проверяем, нет ли уже такого резерва:
        # 1. на файловой системе
        my $existing_reserve = `ls -d $RESERVE_BASE_DIR/reserve\.*\.$p 2>/dev/null`;
        if ( $existing_reserve ){
            $res->{errors}->{$p} = "port $p already reserved: $existing_reserve";
            rmdir $lock_dir; 
            next;
        }
        # 2. в коде
        if ( $reserved{$p} ){
            # вообще-то в %reserved может лежать лишнее, не только из кода, но ФС должна отловиться предыдущей проверкой
            $res->{errors}->{$p} = "port $p already reserved in BetaPorts.pm";
            rmdir $lock_dir; 
            next;
        }

        my $file = "$RESERVE_BASE_DIR/reserve.$O{for}.$p";
        my $msg = `touch $file 2>&1`;
        if ( -e $file ){
            push @{$res->{success}}, $p
        } else {
            $res->{errors}->{$p} = "can't reserve port $p, details: $msg"
        } 

        rmdir $lock_dir; 
    }

    return $res;
}


=head2 release_ports

=cut
sub release_ports
{
    my ($ports_arr, %O) = @_;

    die "illegal 'for' value: '$O{for}', stop" if $O{for} !~ /^[a-z0-9\-]+$/;

    my $res = {
        success => [],
        errors => {},
    };

    for my $p ( @$ports_arr ){
        my $lock_dir = "$RESERVE_BASE_DIR/lock.$p";
        # берем лок против одновременной работы с одним и тем же портом
        if ( ! mkdir $lock_dir){
            $res->{errors}->{$p} = "can't get lock for reserving port $p, details: $!";
            next;
        }

        # проверяем, что нет беты с таким номером
        if ( !is_port_free($p) ){
            $res->{errors}->{$p} = "port $p in use";
            rmdir $lock_dir; 
            next;
        }

        # проверяем, что есть есть файловый резерв с указанным пользователем
        my $file = "$RESERVE_BASE_DIR/reserve.$O{for}.$p";
        if ( !-e $file ){
            $res->{errors}->{$p} = "can't find file for reserve ($file)";
            rmdir $lock_dir; 
            next;
        }

        my $msg = `rm $file 2>&1`;
        if ( -e $file ){
            $res->{errors}->{$p} = "can't free port $p, details: $msg"
        } else {
            push @{$res->{success}}, $p
        } 

        rmdir $lock_dir; 
    }

    return $res;
}


=head2 is_port_free

    Позиционный параметр -- номер порта
    Возвращает истину, если этот порт не занят никакой бетой

=cut
sub is_port_free
{
    my ($p, %O) = @_;

    return ! grep { $_ == $p } @{get_used_ports(for => '*')} ;
}

{
    my $current_hostname_cache;
sub current_host
{
    $current_hostname_cache ||= Yandex::Hostname::hostfqdn();
    return $current_hostname_cache;
}
}

{
    my $CACHE = {};

#TODO filesystem
sub get_betas_info
{
    my %O = @_;
    my $current_host = current_host(); 

    return $CACHE->{$current_host} if exists $CACHE->{$current_host};

    #check_reserved_betas();

    my $reserved_from_code = $RESERVED{$current_host} || {};
    my $reserved_from_fs = get_fs_owners_ports();

    my @owners_from_code = sort grep {!/^\*$/} keys %$reserved_from_code;
    my @owners_from_fs = sort keys %$reserved_from_fs;
    my %owner;
    for my $p (@{$reserved_from_code->{'*'}}){
        $owner{$p} = '';
    }
    for my $o (@owners_from_code){
        next if $o eq '*';
        for my $p (@{$reserved_from_code->{$o}}){
            $owner{$p} = $o;
        }
    }
    for my $o (@owners_from_fs){
        for my $p (@{$reserved_from_fs->{$o}}){
            $owner{$p} = $o;
        }
    }

    my $prev_owner = '*';
    my @ranges;
    my $r;
    for my $p ( sort {$a <=> $b} keys %owner ){
        if( $owner{$p} ne $prev_owner ){
            $r = {
                start => $p,
                owner => $owner{$p},
            };
            push @ranges, $r;
            $prev_owner = $owner{$p};
        }
        $r->{end} = $p;
        $r->{length}++;
    }


    my %ranges_by_owners;
    my @unreserved_ranges;
    my @owners;
    for my $r (@ranges){
        if ( $r->{owner} ){
            push @{$ranges_by_owners{$r->{owner}}}, $r;
            push @owners, $r->{owner};
        } else {
            push @unreserved_ranges, $r;
        }
    }
    @owners = uniq @owners;

    $CACHE->{$current_host} = {
        ranges => \@ranges,
        owners => [sort @owners],
        ranges_by_owners => \%ranges_by_owners,
        unreserved_ranges => \@unreserved_ranges,
    };
    return $CACHE->{$current_host};
}
}


#TODO filesystem, молчаливый режим, делать juggler-события
sub check_reserved_betas
{
    for my $host ( keys %RESERVED ){
        my $betas = $RESERVED{$host};
        # 1. есть *
        die "$host: no '*' rule" unless exists $betas->{"*"};
        # 2. нет ''
        for my $login ( keys %$betas ){
            die "$host: incorrect login '$login'" if $login ne '*' && $login !~ /^[a-zA-Z0-9_\-]+$/;
        }
        # 3. все указанные диапазоны не пересекаются и не выходят за *
        my %OWNER;
        for my $login (sort keys %$betas ){
            next if $login eq '*';
            for my $port ( @{$betas->{$login}} ){
                push @{$OWNER{$port}}, $login;
            }
        }
        for my $port (sort keys %OWNER){
            die "$host: port $port belongs to more than 1 range: ".join(", ", @{$OWNER{$port}}) if @{$OWNER{$port}} > 1;
            die "$host: port $port (owner @{$OWNER{$port}}) exceeds range for '*'" unless grep {$_ == $port} @{$betas->{'*'}}
        }
    }

    return '';
}


sub check_used_betas
{
    # не используются незарезервированные беты
}


sub range_to_str
{
    my ($r, %O) = @_;

    return "[$r->{start} .. $r->{end}]".($O{count}? " (".( $r->{end} - $r->{start} + 1 ).")" : "");
}

1;
