#!/usr/bin/perl -w

=pod
    $Id$
=cut

use strict;
use Test::More;
use Test::Exception;

use BetaPorts;

use utf8;
use open ':std' => ':utf8';

lives_ok {BetaPorts::check_reserved_betas();};

my @tests_good = (
    {
        'project_1' => {
            '*'=> [123],
            'login_1' => [123],
        },
    },
);

my @tests_bad = (
    # нет '*'
    {
        'project_1' => {
            'login_1' => [123],
        },
    },
    # нет '*' в одном из проектов
    {
        'project_2' => {
            '*'=> [123],
            'login_1' => [123],
        },
        'project_2_2' => {
            'login_1' => [123],
        },
    },
    # порт выходит за границы '*'
    {
        'project_3' => {
            '*'=> [123],
            'login_1' => [123],
        },
        'project_3_2' => {
            '*' => [1 ..10],
            'login_1' => [123],
        },
    },
    # порты повторяются
    {
        'project_4' => {
            '*'=> [123],
            'login_1' => [123],
        },
        'project_4_2' => {
            '*' => [1 ..10],
            'login_1' => [1, 2, 3],
            'login_2' => [5, 2, 6],
        },
    },
);

for my $R (@tests_good){
    %BetaPorts::RESERVED = %$R;
    lives_ok {BetaPorts::check_reserved_betas();};
}

for my $R (@tests_bad){
    %BetaPorts::RESERVED = %$R;
    dies_ok {BetaPorts::check_reserved_betas();};
}


done_testing();
