package Beta::Service::cocaine;


=head1 DESCRIPTION

Базовый класс для кокаиновых сервисов. Умеет общаться с облаком -
загрузить, запустить, проверить и остановить приложение

=cut

use Mouse;
use File::Slurp;
use Yandex::Shell;
use JSON;

extends 'Beta::Service';

has app_id => (
    is => 'ro',
    isa => 'Str',
    required => 1,
);

our $COCAINE_PROFILE;
our $_profile_uploaded;

sub BUILDARGS
{
    my ($self, $args) = @_;
    $self->SUPER::BUILDARGS($args);
    $args->{app_id} = join '_', $args->{name}, $args->{PORT};
    return $args;
}

sub _upload_profile
{
    my $self = shift;
    return if $_profile_uploaded;
    my $profile_id = $COCAINE_PROFILE;
    my $profile = { "pool-limit" => 4, "concurrency" => 1 };

    my $profile_json = encode_json $profile;

    $self->_cocaine('profile', 'upload', '--name' => $self->_get_cocaine_id($profile_id), '--profile' => \$profile_json);
    $_profile_uploaded = 1;
}

sub _upload_app
{
    my $self = shift;
    my ($app_id, $cmd, %opt) = @_;

    my $manifest = encode_json { %opt, slave => $cmd };

    # запускаем из пустой директории, чтобы не слать в кокаин лишнего
    local $Yandex::Shell::CHDIR = 1;
    $self->_cocaine('app', 'upload', '--name' => $self->app_id, '--manifest' => \$manifest);
}

sub _get_cocaine_id
{
    my $self = shift;
    my $name = shift // $self->name;
    return join '_',  ($name, $self->PORT);
}

sub _cocaine
{
    shift;
    return yash_system 'cocaine-tool', @_, '--timeout' => 20;
}

sub start
{
    my $self = shift;
    $self->_upload_profile();
}

sub started
{
    my $self = shift;
    my $name = $self->app_id;
    my $res = yash_qx("cocaine-tool app check -n $name 2>&1 || true");
    return $res =~ m!1;32mrunning! ? 1 : 0;
}

sub stop
{
    my $self = shift;
    $self->_cocaine('app', 'stop', '--name' => $self->app_id);
}

1;
