package Beta::Service::cocaine::ext;


=head1 DESCRIPTION

Класс для внешнего (не-перлового) кокаинового приложения. Предполагается, что
приложение живет в другом репозитории и чекаутится при создании беты.

Параметры:
init: команда, которая выполняется один раз при создании беты
dest_dir: директория, где обитает сервис. Должна создаваться внутри init. Если директория
    существует, то init не вызывается
start_cmd:
restart_cmd:
stop_cmd: команды запуска и остановки
app_name: имя приложения в кокаиновом облаке

=cut

use Mouse;
use File::Slurp;
use Yandex::Shell;
use JSON;

extends 'Beta::Service::cocaine';

has init => (
    is => 'ro',
    isa => 'Str',
    required => 1,
);

has dest_dir => (
    is => 'ro',
    isa => 'Str',
    required => 1,
);

has start_cmd => (
    is => 'ro',
    isa => 'Str',
    required => 1,
);

has restart_cmd => (
    is => 'ro',
    isa => 'Str',
    required => 0,
);

has stop_cmd => (
    is => 'ro',
    isa => 'Str',
    required => 0, # по-умолчанию останавливаем как все кокаиновые приложения: cocaine app stop
);

has app_name => (
    is => 'ro',
    isa => 'Str',
    required => 0, # по-умолчанию $self->name
);

our $COCAINE_PROFILE;
our $_profile_uploaded;

sub BUILDARGS
{
    my ($self, $args) = @_;
    $self->SUPER::BUILDARGS($args);
    if ($args->{app_name}) {
        $args->{app_id} = $args->{app_name} . '_' . $args->{PORT};
    }
    return $args;
}

sub _inited
{
    my $self = shift;
    return -d $self->ROOT . '/' . $self->dest_dir;
}

sub _init
{
    my $self = shift;
    yash_system($self->init);
}

sub start
{
    my $self = shift;
    if (!$self->_inited()) {
        $self->log(sprintf("initing %s: %s", $self->app_id, $self->init));
        $self->_init();
    }
    $self->_upload_profile();
    yash_system($self->start_cmd);
}

around restart => sub {
    my $orig = shift;
    my $self = shift;

    return $self->$orig(@_)  if !$self->restart_cmd;

    yash_system($self->restart_cmd);
};

sub stop
{
    my $self = shift;
    if ($self->stop_cmd) {
        yash_system($self->stop_cmd);
        return;
    }
    $self->_cocaine('app', 'stop', '--name' => $self->_get_cocaine_id());
}

sub show
{
    return shift->app_id;
}

1;

