package Beta::Service::cocaine::perl;


=head1 DESCRIPTION

Перловое кокаиновое приложение

Параметры:
module: имя модуля

=cut

use Mouse;
use JSON;
use Yandex::Shell;

extends 'Beta::Service::cocaine';

my $COCAINE_PROFILE = $Beta::Service::cocaine::COCAINE_PROFILE;
our $APP //= "/usr/local/bin/cocaine-worker.pl";

has module => (
    is => 'ro',
    isa => 'Str',
    required => 1,
);

sub BUILDARGS
{
    my ($self, $args) = @_;
    $self->SUPER::BUILDARGS($args);
    return $args;
}

sub start
{
    my $self = shift;
    $self->_upload_profile();

    my $env = {
        COCAINE_MODULE => $self->module,
        PERL5LIB => $self->ROOT."/protected",
    };
    $self->_upload_app($self->name, $APP, environment => $env);
    $self->_cocaine('app', 'restart', '--name' => $self->_get_cocaine_id(), '--profile' => $self->_get_cocaine_id($COCAINE_PROFILE));
}

sub show
{
    my $self = shift;
    return $self->module;
}

1;
