package Beta::Service::gearman;


=head1 DESCRIPTION

Гирмановский демон

Параметры:
module: имя модуля

=cut

use Mouse;
use File::Slurp;

extends 'Beta::Service::daemon';

has module => (
    is => 'ro',
    isa => 'Str',
    required => 1,
);

sub BUILDARGS
{
    my ($self, $args) = @_;

    my $module_lc = (lc $args->{module}) =~ s!::!_!gr;
    $args->{pid_file} = "protected/run/gearman_$module_lc.pid";
    $args->{cmd} = "scripts/gearman_worker.pl";
    $args->{args} = [ '--module' => $args->{module} ];
    $args->{match} = "Gearman ".$args->{module};
    
    $self->SUPER::BUILDARGS($args);

    return $args;
}

sub show
{
    my $self = shift;
    return $self->module;
}

1;
