package Beta::Service::group;


=head1 DESCRIPTION

Скрипт, который нужно перезапускать через равный интервал

Параметры:
TODO

=cut

use Mouse;

extends 'Beta::Service';

# items can be object or string (name of service)
has childs => (
    is => 'rw',
    isa => 'ArrayRef',
    required => 1,
);

sub _real_childs
{
    my ($self) = @_;
    return [ map { ref $_ ? $_ : ( $Beta::Service::SERVICES{$_} // die "unknown item in group: $_" ) } @{$self->childs} ];
}

sub start
{
    my $self = shift;
    for my $s (@{$self->_real_childs}) {
        $s->start();
    }
}

sub restart
{
    my $self = shift;
    for my $s (@{$self->_real_childs}) {
        $s->restart();
    }
}

sub stop
{
    my $self = shift;
    for my $s (@{$self->_real_childs}) {
        $s->stop();
    }
}

sub show
{
    my $self = shift;
    return "[".(join ", ", map { $_->name } @{$self->_real_childs})."]";
}

sub status
{
    my $self = shift;
    for my $s (@{$self->_real_childs}) {
        $s->status();
    }
}

sub started
{
    return 0;
}

1;

