package Beta::Service::mod_daemon;


=head1 DESCRIPTION

Демон модерации, запускаемый из start_daemon.pl

Параметры:
 совпадают с аргументами start_daemon.pl
 # mod /var/www/direct-mod.yandex.ru/protected/start_daemon.pl --module NewAngel --auto-restart  2>&1 | tail -c 100000
 module: 
 auto-restart:
 tries:
 argv: параметры модуля

=cut

use Mouse;
use Fcntl qw/:flock/;
use lib 'protected';
eval "use Settings";
if ($@) {
    die $@;
}

extends 'Beta::Service';

has module => (
    is => 'ro',
    isa => 'Str',
    required => 1,
);

has auto_restart => (
    is => 'ro',
    isa => 'Bool',
    default => 0,
);

has tries => (
    is => 'ro',
    isa => 'Int',
    default => 0,
);

has argv => (
    is => 'ro',
    isa => 'ArrayRef',
    default => sub{[]},
);

sub BUILDARGS
{
    my ($self, $args) = @_;
    $self->SUPER::BUILDARGS($args);

    $args->{auto_restart} //= $args->{'auto-restart'};

    return $args;
}

sub start
{
    my $self = shift;
    if ($self->started) {
        $self->log($self->name." : already started");
        return;
    }
    my @args;
    push @args, ( '--module' => $self->module );
    if ($self->auto_restart) {
        push @args, ( '--auto-restart' => 1 );
    }
    if ($self->tries) {
        push @args, ( '--tries' => $self->tries );
    }
    my $pid = fork();
    if ($pid == 0) {
        my $cmd = join ' ', "protected/start_daemon.pl", @args, @{$self->argv};
        exec "$cmd >/dev/null 2&>1";
    }
}

sub stop
{
    my $self = shift;
    if (!$self->started) {
        $self->log($self->name." already stopped");
        return;
    }
    my $pid = fork();
    if ($pid == 0) {
        exec("protected/start_daemon.pl", '--module' => $self->module, '--stop');
    }
    $self->wait_until_stop();
}

sub show
{
    my $self = shift;
    my $res = $self->module;
    return $res;
}

sub started
{
    my $self = shift;
    if (! -f $self->pid_file) {
        return 0;
    }
    open(my $FH, '<', $self->pid_file);
    if (flock($FH, LOCK_EX | LOCK_NB)) {
        flock($FH, LOCK_UN);
        return 0;
    }
    return 1;
}

sub pid_file
{
    my $self = shift;

    my $file_name = $self->module;
    $file_name =~ s/[\W\s]/_/g;
    return "$Settings::PATH_TO_LOCK_FILES/$file_name.lock";
}

1;

