package Beta::Service::sharded;


=head1 DESCRIPTION

Шардированный скрипт - демон.

Параметры:
TODO

=cut

use Mouse;
use File::Slurp;
use lib 'protected';
use my_inc for => 'protected';
use ShardingTools;
use Module::Load qw//;
use List::MoreUtils qw/all none/;
use Yandex::ListUtils qw/as_array/;

extends 'Beta::Service::group';

has script => (
    is => 'ro',
    isa => 'HashRef',
    required => 1,
);

sub BUILDARGS
{
    my ($self, $args) = @_;
    $self->SUPER::BUILDARGS($args);
    for my $shard (ppc_shards()) {
        my $class = "Beta::Service::$args->{script}->{type}";
        Module::Load::load $class;
        my $script_args = { %{$args->{script}} };
        my $fn = $script_args->{cmd} =~ s!.*/!!r;
        my $pid_file_t = $script_args->{pid_file} // "$args->{ROOT}/protected/run/$fn.pid";
        $script_args->{args} = as_array($script_args->{args}//[]);
        push @{$script_args->{args}}, ( '--shard-id' => $shard );
        my $srv = $class->new({
            %$script_args,
            type => $script_args->{type},
            name => $args->{name}.":$shard",
            hidden => 1,
            pid_file => $pid_file_t.".$shard",
        });
        push @{$args->{childs}}, $srv;
    }
    return $args;
}

sub status
{
    my ($self) = @_;
    my @status = map { $_->started } @{$self->childs};
    my $size = scalar @status;
    if (all { $_ } @status) {
        printf "%s : started [$size/$size]\n", $self->pad_name;
    }
    elsif (none { $_ } @status) {
        printf "%s : not started [$size/$size]\n", $self->pad_name;
    }
    else {
        for my $s (@{$self->childs}) {
            printf "%s : %s\n", $s->pad_name, ($s->started ? "started" : "not started");
        }
    }
}

sub show
{
    my $self = shift;
    return $self->childs->[0]->show();
}

1;

__END__

client_data:
    type: sharded
    script_type: sleep
    watch: 60
