package Beta::Service::sleep;


=head1 DESCRIPTION

Скрипт, который нужно перезапускать через равный интервал

Параметры:
cmd - команда, которую нужно запустить
match - ищем среди процессов совпадение с match (регулярка); Если не указан - пытаемся матчить по имени скрипта
stop_method => 'stop' | 'kill' - как останавливать: --stop или kill $pid
sleep => N - сколько секунд спать между запусками
args - массив строк - параметры скрипта

=cut

use Mouse;
use File::Slurp;

extends 'Beta::Service::daemon';

has sleep => (
    is => 'ro',
    isa => 'Int',
    required => 1,
);

sub BUILDARGS
{
    my ($self, $args) = @_;
    $self->SUPER::BUILDARGS($args);

    return $args;
}

sub start
{
    my $self = shift;
    if ($self->started) {
        $self->log($self->name." : already started");
        return;
    }
    my $cmd = $self->cmd;
    if ($self->args) {
        $cmd .= join ' ', ('', @{$self->args});
    }
    $cmd = "while [ 1 ] ; do $cmd ; sleep ".$self->sleep." ; done";
    $self->_run($cmd);
}

1;
