#!/usr/bin/perl -w

use strict;
use warnings;

=pod

    $Id$

=head1 DESCRIPTION

    Скрипт проверяет даты рождений коллег из списка
    
    Строка из крона, которая находит ближайшие ДР, проводит розыгрыш и отправляет письма:
        ./check-birthday.pl --days=20 --find_auto_login --send_emails
        ./check-birthday.pl --days=15 --find_auto_login (не отправляет письма)
    
    Вывести дни рождения в ближайшие 15 дней:
        ./check-birthday.pl --days=15

    Вывести дни рождений в указанный месяц:
        ./check-birthday.pl --month=4

    Вывести дни рождения в текущем месяце:
        ./check-birthday.pl --current_month

    Запустить розыгрыш для дня рождения указанного логина ( выводится на экран, письма не отправляются! ):
        ./check-birthday.pl --login=mirage

    С розыгрышем и отправкой писем:
        ./check-birthday.pl --login=mirage --send_emails

=cut

use utf8;

# use lib '/home/mirage/tmp/direct-utils/yandex-lib/staff/lib/';

use Yandex::Shell;

use Yandex::Staff3 qw( get_staff_info );
use Yandex::SendMail;
use Yandex::TimeCommon;
use Yandex::Log;

use Encode qw/encode_utf8/;
use JSON;
use POSIX;
use File::Slurp;
use Data::Dumper;
use Yandex::Log;
use Getopt::Long;

# $Yandex::Staff::STAFF_API_TOKEN = $Yandex::Staff::STAFF_API_TOKEN."&fields=id|login|first_name|last_name|work_email|work_phone|position|birthday";

# кол-во логинов, которые выбираются случайным образом
my $COUNT_LOGINS = 5;
my $WINNER_STEP = $COUNT_LOGINS;
my $DB_FILE_NAME = "birthdays_db_file.json";
my @curators = qw/mirage lena-san/;
$| = 1;

$Yandex::Log::LOG_ROOT = "./";

my $log = Yandex::Log->new(log_file_name => "check-birthday.log");
$log->out("start");

my ($days, $month, $current_month_flag, $login);
my ($send_emails, $find_auto_login, $showlist);
GetOptions(
    'days=s' => \$days
    , 'month=s' => \$month
    , 'current_month' => \$current_month_flag
    , 'login=s' => \$login
    , 'find_auto_login' => \$find_auto_login
    , 'send_emails' => \$send_emails
    , 'showlist' => \$showlist
) or die "No specified params";

$log->out({days => $days, month => $month, current_month => $current_month_flag, login => $login, send_emails => $send_emails, DEBUG => $ENV{DEBUG}, find_auto_login => $find_auto_login, showlist => $showlist});

# TODO: лучше не на staff ходить, а прямо здесь сохранить даты рождений
my @logins = qw/
    hrustyashko
    lena-san
    liosha
    eboguslavskaya
    zhur
    sco76
    icenine
    n-boy
    gukserg
    adubinkin
    serafim
    a-lobanova
    kaerber
    monoid
    lagunov
    semals
    stason
    s-mamchits
    simplylizz
    gerdler
    smagellan
    maxlog
    kuhtich
/;

if ($ENV{DEBUG} && $ENV{EXTRA}) {
    # тестирование && менеджеры
    push @logins, qw/galeeva a-balakina kiev andreyka domanickaya kotina coolisha rockman mariabye caesarea vovichek62 ginger pavryabov a-tigran teux levol nbpetrov tarmasik johnyh nadiano kuzmin qub eml morozoff/;
}

my $sending_history = {};
eval {
    $sending_history = from_json( read_file( $DB_FILE_NAME ) ) if -f $DB_FILE_NAME;
};
warn $@ if $@;

my $hash;

if ($days || $month || $current_month_flag || $showlist) {
    $hash = check_birthdays(\@logins, days => $days, month => $month, current_month_flag => $current_month_flag);
}

if ($find_auto_login) {
    foreach my $birthday_login (keys %{ $hash->{soon} || {} }) {
        # проверяем не отправили ли письмо уже
        next if $sending_history->{logins}{$birthday_login};

	warn to_json( $sending_history ) if $ENV{DEBUG};
       
	foreach my $login (keys %{ $sending_history->{winners} || {} }) {
		$sending_history->{winners}{ $login } ||= 0;
		$sending_history->{winners}{ $login } -= 1;
	}
 
        $sending_history = select_santas_and_send_letter($birthday_login, $send_emails, $sending_history);
    }
    
    write_file($DB_FILE_NAME, to_json($sending_history)) if !$ENV{DEBUG} && !$showlist;
}

if ($login) {
    foreach my $w_login (keys %{ $sending_history->{winners} || {} }) {
	$sending_history->{winners}{ $w_login } ||= 0;
        $sending_history->{winners}{ $w_login } -= 1;
    }

    # выбираем победителей и отправляем письмо
    $sending_history = select_santas_and_send_letter($login, $send_emails, $sending_history);
    
    write_file($DB_FILE_NAME, to_json($sending_history)) if !$ENV{DEBUG} && !$showlist;
}

sub check_birthdays
{
    my $logins = shift;
    my %O = @_;

    my $hash = {};
    
    my ( $current_year ) = ( localtime( time ) )[5] + 1900;
    my ( $current_month ) = ( localtime( time ) )[4] + 1;
    my @list_info = ();
    
    foreach my $login (@logins) {

        my $info = get_staff_info($login, [qw/id login name.first.ru name.last.ru work_email personal.birthday/]);

	if ($ENV{DEBUG} || $showlist) {
		my $bd = $info->{personal}->{birthday};
		$bd =~ s/^\d{4}\-//;
		push @list_info, Encode::encode_utf8("$bd ( $info->{personal}->{birthday} ) :: $info->{name}->{first}->{ru} $info->{name}->{last}->{ru} ($login)");
	}

	if (! $info->{personal}->{birthday}) {
	    warn Dumper {info => $info};
	    next;
	}

        my ($b_month, $b_day) = $info->{personal}->{birthday} =~ /^\d+\-(\d+)\-(\d+)$/;
    
        $hash->{current_month}{$login} = $info if $O{month} && $b_month == $O{month} || $O{current_month_flag} && $b_month == $current_month;
        my $b_timestamp = mysql2unix("$current_year-$b_month-$b_day");

        if (time() < $b_timestamp && time() + ($O{days} || 31) * 3600 * 24 >= $b_timestamp ) {
            $hash->{soon}{$login} = $info;
        }
    }

    if ($showlist || $ENV{DEBUG}) {
	print STDERR join "\n", sort {$a cmp $b} @list_info;
	print STDERR "\n\n";
    }
    exit(1) if $showlist;

    if ($ENV{DEBUG}) {
        if ($O{current_month_flag} || $O{month}) {
            foreach my $u (@{$hash->{current_month} || []}) {
                print $sending_history->{logins}{$u->{login}} ? "+ " : "- ";
                print Encode::encode_utf8( join (": ", "$u->{name}->{first}->{ru} $u->{name}->{last}->{ru}", $u->{personal}->{birthday}));
                print "\n";
            }
        } elsif ($O{days}) {
            foreach my $login (keys %{$hash->{soon} || {}}) {
                my $u = $hash->{soon}{$login};
                print $sending_history->{logins}{$u->{login}} ? "+ " : "- ";
                print Encode::encode_utf8(join ": ", "$u->{name}->{first}->{ru} $u->{name}->{last}->{ru}", $u->{personal}->{birthday});
                print "\n";
            }
        }
    }
    
    return $hash;
}


sub select_santas_and_send_letter
{
    my $login = shift;
    my $send_emails = shift;
    my $local_db = shift;
   
    my $info = get_staff_info($login, [qw/id login name.first.ru name.last.ru work_email personal.birthday/]);

    my @users = get_random_users($login, $local_db);

    my ($letter);
    while (<DATA>) { $letter .= $_ };
    
    my $winners_str = join "\n", map { "$_->{login}: $_->{rnd}".($ENV{DEBUG} ? " (".sprintf("%.2f", $_->{koeff}).")" : "") } @users;
    print $winners_str."\n\n" if $ENV{DEBUG};

    foreach my $l (@users) {
        die if $l eq $login;
    }

    foreach my $winner_login (@users) {
	$local_db->{winners}{ $winner_login->{login} } += $WINNER_STEP;
    }

    my $first = shift @users;

    my ( $current_year ) = ( localtime( time ) )[5] + 1900;
    my ( $current_month ) = ( localtime( time ) )[4] + 1;

    my @b_dates = split /\-/, $info->{personal}->{birthday};
    # TODO: не всегда так - в январе может случиться следующий год
    $b_dates[0] = $current_year;

    $info->{birthday_ym} = join '-', reverse @b_dates;

    my $letter_str = sprintf($letter, "$info->{name}->{first}->{ru} $info->{name}->{last}->{ru}", $info->{birthday_ym}, $winners_str);

    my $recip_email = $first->{login}."\@yandex-team.ru";
    # my $recip_email = 'mirage@yandex-team.ru';
    my $cc_emails = join(", ", map {"$_\@yandex-team.ru"} map {$_->{login}} @users);
    my $bcc_emails =  join (", ", map {"$_\@yandex-team.ru"} grep {$_ ne $login} @curators);

    print encode_utf8($letter_str)."\n\n" if $ENV{DEBUG};
    print Dumper({ first => $recip_email, cc => $cc_emails, bcc => $bcc_emails })."\n" if $ENV{DEBUG};

    if ($send_emails && !$ENV{DEBUG}) {
        $log->out({to => $recip_email, cc => $cc_emails, bcc => $bcc_emails, letter => $letter_str});
	
	$local_db->{logins}{ $login } = 1;

        Yandex::SendMail::sendmail({ 
                        to => $recip_email
                        , cc => $cc_emails
                        , bcc => $bcc_emails
            }, "devnull\@yandex.ru", "Happy birthday, $info->{name}->{first}->{ru} ($login)!", \$letter_str);
        
    } else {
	$local_db->{logins}{ $login } = 0;
    }
    
    return $local_db;
}

$log->out("end.");
print "\n";

sub get_random_users
{
    my $except_login = shift || die "Not specified login";
    my $local_db = shift;

    my %prev_winners = %{ $local_db->{winners} || {} };

    my @winners = 
        map { { login => $_->{login}, rnd => $_->{rnd}, koeff => calc_koeff( $prev_winners{ $_->{login} } ) } } 
        sort { $b->{rnd} <=> $a->{rnd} } 
        map { {login => $_, rnd => int( calc_koeff($prev_winners{$_}) * xrandom() ) } } 
        grep { $_ ne $except_login } 
        @logins;
   
    warn to_json(\@winners) if $ENV{DEBUG};
 
    return @winners[0 .. $COUNT_LOGINS-1];
}

# Чем дольше не выбирали в победители, тем больше множитель. И наоборот первые WINNER_STEP розыгрышей после победы происходят с понижающим коэффициентом
sub calc_koeff
{
    my $current_koeff = shift || 0;

    return $current_koeff > 0 ? (1 / ( $current_koeff + 1 )) : ( abs($current_koeff) + 1 );
}

sub xrandom
{
    my $rnd = yash_qx("od -An -N4 -l /dev/random");
    $rnd =~ s/\D+//gsi;

    return $rnd;
}

__DATA__
Коллеги, добрый день!

Скоро случится отличный повод поздравить коллегу с днем рождения!
%s (%s)

Чтобы событие произошло успешно - прошел жребий, который вновь выявил победителей (тебя в том числе!):

%s

PS Для придания таинственности событию - письмо отправлено только победителям :)

PPS Чтобы избежать накладок - 1) начинайте обсуждение как можно раньше; 2) заранее бронируйте переговорку для обсуждения. Если собираетесь на момент поздравления в отпуск - договоритесь об этом с остальными участниками. Повторного письма с напоминанием не будет.

PPPS Письмо отправлено в полуавтоматическом режиме. Скрипт в svn+ssh://svn.yandex.ru/direct-utils/birthdays/usr/bin/check-birthday.pl

Удачи!
