red=`tput setaf 1`
green=`tput setaf 2`
reset=`tput sgr0`

usage() {
	cat <<- EOF
	Использование: `basename $0` param1 param2

		Параметры:
		param1: базовая версия (указывается без буквы v)
		param2: дополнительная версия, коммиты которой хотим добавить к базовой (указывается без буквы v)

	Пример: `basename $0` 0.0.67 0.0.89
	EOF
}

branchName=bricks-release-$1-$2
cloneFolderPath=$(mktemp -d /tmp/$branchName.XXXXXXX) || exit 1
tagName=release-v$1-v$2

# Клонируем репозиторий во временную папку
git clone https://github.yandex-team.ru/direct/bricks.git $cloneFolderPath || exit
cd $cloneFolderPath

# Если такой ветки нет на удаленном сервере, то создаем ее на основе тега базовой версии, которая приходит в параметрах
# Черипикаем поверх дополнительную версию, коммитим, пушим, создаем новый тег
branchExists=`git show-ref $branchName`

if [ -n "$branchExists" ]; then
    echo "${green}Ветка уже существует: $branchName, tag: release-v$1-v$2${reset}"
else
    git branch $branchName v$1 || ( usage && exit )
    git checkout $branchName

    tagsArray=(`git tag --list v*`)
    extraVersionIndex=`echo ${tagsArray[@]} | tr -s " " "\n" | grep -n "v$2" | cut -d":" -f 1`

    if [$extraVersionIndex == ""]; then
        echo "${red}Не найдена версия v$2${reset}"
        usage
        exit
    fi

    git cherry-pick -n `git rev-list --reverse ${tagsArray[$((extraVersionIndex - 2))]}..v$2 --no-merges`

    #если конфликтные файлы CHANGELOG.md или package.json решаем в пользу версии, которую накатываем поверх
    while [ "$(git ls-files -u | cut -f 2 | sort -u |grep -E 'CHANGELOG|package')" != "" ]
    do
        if [ "$(git ls-files -u | cut -f 2 | sort -u |grep -E 'CHANGELOG')" ]; then
            git checkout --theirs CHANGELOG.md
            git add CHANGELOG.md
        fi

        if [ "$(git ls-files -u | cut -f 2 | sort -u |grep -E 'package')" ]; then
            git checkout --theirs package.json
            git add package.json
        fi

        git commit -m "Cherry-pick iteration of $2 on $1"

        git cherry-pick --continue
    done

    #если конфликты так и остались - выдаем ошибочное сообщение, если все ок - коммитим, пушим, создаем тег
    if [ "$(git ls-files -u | cut -f 2 | sort -u)" ]; then
        echo "${red}Произошли конфликты при попытке cherry-pick изменений. Обратитесь фронтендеру, для разрешения конфликта${reset}"
    else
        git tag -a $tagName -m "Release tag $tagName"
        git push origin $branchName
        git push origin $tagName
        echo "${green}Создана новая ветка: $branchName, tag: release-v$1-v$2${reset}"
    fi
fi
