#!/usr/bin/perl

=head1 NAME

    direct-callchains-to-freemind.pl - преобразование вывода direct-callchains.pl в формат freemind

=head1 SYNOPSIS

    direct-callchains.pl /var/www/beta.hmepas.9173/protected/ CreateOrUpdateBanners \
        | direct-callchains-to-freemind.pl > coub_free_mind.mm

=head1 DESCRIPTION

    Скачать бесплатный MindMap-редактор можно тут http://www.xmind.net/download/
    При импорте надо указывать импорт из FreeMind.
    В этой программе, кажется, самое полезное представление для получившейся карты -
    структура -> дерево (направо).

    Этот скрипт - примитивный парсер на скорую руку, если есть идеи, что добавить, пишите hmepas@. 

=cut

use strict;
use warnings;
use utf8;

use DDP;
use Data::Dumper;
use JSON;

my $limit = 500000;
my $tree = {};
while(<>) {
    chomp;
    my @path = map { s/^\s*//g ; s/\s*$//g ; $_} (split ' -> ');

    my $cur = $tree;
    while(my $branch = shift @path) {
        $cur = $cur->{$branch} //= {};
    }
    last unless $limit--;
}

tree_to_xml($tree);

sub tree_to_xml {
    my $tree = shift;
    print '<map version="0.8.0">';

    print_nodes($tree);

    print '</map>';
}

sub print_nodes {
    my $tree = shift;

    foreach my $node (keys %$tree) {
        if(scalar keys %{$tree->{$node}}) {
            print "<node text=\"$node\">";
            print_nodes($tree->{$node});
            print '</node>';
        } else {
            print "<node text=\"$node\" />";
        }
    }
}


