#!/usr/bin/python
# -*- coding: utf-8 -*-

import os
import sys
import mimetypes
import logging
import json
import flask
from flask import request

sys.path.insert(0, '/var/lib')

import telepot

Bots = {}

logging.basicConfig(stream=sys.stderr, level=logging.DEBUG)

app = flask.Flask(__name__)


@app.route('/send_message')
def send_message():
    global Bots
    if request.method == 'POST':
        chat_id = request.form['chat_id']
        title = request.form['title']
        bot_name = request.form['bot']
        message = request.form['message']
        quiet_param = request.form['quiet']
    elif request.method == 'GET':
        chat_id = request.args.get('chat_id', '')
        title = request.args.get('title', '')
        bot_name = request.args.get('bot', '')
        message = request.args.get('message', '')
        quiet_param = request.args.get('quiet', '')

    disable_notification = quiet_param in [ '1' ]

    bot = Bots[bot_name]
    bot.sendMessage(chat_id, message, disable_notification=disable_notification)
    return json.dumps({'ok': 1}, sort_keys=True)



@app.route('/set_title', methods=['POST', 'GET'])
def set_title():
    global Bots
    if request.method == 'POST':
        chat_id = request.form['chat_id']
        title = request.form['title']
        bot_name = request.form['bot']
    elif request.method == 'GET':
        chat_id = request.args.get('chat_id', '')
        title = request.args.get('title', '')
        bot_name = request.args.get('bot', '')

    bot = Bots[bot_name]
    bot.setChatTitle(chat_id, title) #"\xF0\x9F\x92\x9A" )
    return json.dumps({'ok': 1}, sort_keys=True)



@app.route('/get_chat_info', methods=['GET'])
def get_chat_info():
    global Bots
    chat_id = request.args.get('chat_id', '')
    bot_name = request.args.get('bot', '')

    bot = Bots[bot_name]
    full_chat_info = bot.getChat(chat_id)
    chat_info = {}
    for k in ['description', 'title', 'id']:
        if k not in full_chat_info:
            continue
        chat_info[k] = full_chat_info[k]
    return json.dumps({'chat_info': chat_info,}, sort_keys=True)


def pepare():
    global Bots
    tg_keys_file = '/home/lena-san/tg-auth-keys.json'
    with open(tg_keys_file, 'r') as fd:
        tg_auth_keys = json.load(fd)
    for name, key in tg_auth_keys.iteritems():
        Bots[name.encode("ascii")] = telepot.Bot(key.encode("ascii"))


pepare()

if __name__ == "__main__":
    app.run(host='::', port=5123)
