#!/bin/sh

# cat direct.domains.txt | ./direct-check-certs.sh
# пишет на STDOUT проблемы; кодом выхода сигнализирует, нашлась ли хоть одна

code=0
while read url
do 
    expire_date=`curl -m 5 --insecure -v $url -s 2>&1 |grep 'expire date: ' | sed 's/^[^:]*: //'`
    expire_ts=`date --date="$expire_date" +%s`
    now_ts=`date +%s`
    remain_days=$(( ($expire_ts - $now_ts) / 86400 ))
    #echo $url $now_ts $expire_ts $remain_days
    if [ $remain_days -lt 10 ]
    then
        echo ALARM! Certificate on $url expires in $remain_days days
        code=1
    fi
done
exit $code
