#!/usr/bin/env python

from ppchouse import utils
from ppchouse import locker
from optparse import OptionParser


if __name__ == '__main__':
    USAGE = "usage: %prog --table <table name>"
    VERSION = "1.0"

    parser = OptionParser(usage=USAGE, version=VERSION)

    parser.add_option(  "-t", "--table",
                        action="store", default="", type="string",
                        dest="table", help="the table with which the data is copied"
                        )
    parser.add_option(  "-d", "--debug",
                        action="store_true",
                        dest="debug", help="enable debug mode"
                        )
    parser.add_option( "--src", "--donor", 
                        action="store", default="ppchouse04f.yandex.ru", type="string", 
                        dest="src", help="donor clickhouse server" 
                        )
    parser.add_option( "--dest", 
                        action="store", default="ppcdiscord-trusty.haze.yandex.net", type="string",
                        dest="dest", help="destenation clickhouse server"
                        )
    parser.add_option( "--more",
                        action="store", default=None, type="string",
                        dest="more", help="select more than the specified time"
                        )
    parser.add_option( "--less",
                        action="store", default=None, type="string",
                        dest="less", help="select less than the specified time"
                        )

    (option, args) = parser.parse_args()

    if not option.src: raise
    if not option.dest: raise

    if option.debug:
        t = utils.Support(table=option.table, log_level='DEBUG')
    else:
        t = utils.Support(table=option.table)
    t.logger.debug('DK/PK: {0}, {1}'.format(t.getDateKey(), t.getPrimaryKeysList()))
    meta_data =  t.readGroupKeys(hostname=option.src, more=option.more, less=option.less)
    for data in t.saveRowsByDate(hostname=option.src, total=meta_data):
        lock = locker.Locker(meta=t.meta)
        lock.getLock()
        if lock.getSuccessCnt() >= t.cnt: continue
        save_cnt, fail_cnt, msg = t.loadChData(option.dest, data)
        lock.writeStatusCnt(save_cnt, fail_cnt)
        if msg.len: lock.writeErrorMessg(msg)
        lock.getUnlock()


