import fcntl
import os

LIB_PATH = '/usr/lib/chload/'


class Locker():
    def __init__(self, libpath=None, meta=None):
        libpath = libpath if libpath else LIB_PATH
        meta = os.path.join(*[str(i) for i in meta]) if meta else ' '
        self.path = os.path.join(libpath, meta)    
     
    def getLock(self):
        print "set lock {0}".format(self.path)
        if not os.path.exists(self.path):
            os.makedirs(self.path)
        try:
            with open(os.path.join(self.path, 'lock'), 'wb') as f1le:
                self.lock = fcntl.flock(f1le, fcntl.LOCK_EX | fcntl.LOCK_NB)
        except IOError as errmsg:
            if errno.errorcode.get(errmsg.args[0]) == 'EAGAIN':
                raise IOError('found already running script. Code: %d. Exit.' % errmsg.args[0])
        return

    def getUnlock(self):
        with open(os.path.join(self.path, 'lock'), 'rb') as f1le:
            fcntl.flock(f1le.fileno(), fcntl.LOCK_UN)

    def getSuccessCnt(self):
        if not os.path.exists(os.path.join(self.path, 'success')):
            return 0
        with open(os.path.join(self.path, 'success'), 'r') as f1le:
            return int(f1le.read())

    def getFailedCnt(self):
        with open(os.path.join(self.path, 'failed'), 'r') as f1le:
            return f1le.read()

    def writeStatusCnt(self, success, failed):
        with open(os.path.join(self.path, 'success'), 'w') as f1le:
            f1le.write(success.encode('utf8'))
        with open(os.path.join(self.path, 'failed'), 'w') as f1le:
            f1le.write(failed.encode('utf8'))

    def writeErrorMessg(self, data):
        with open(os.path.join(self.path, 'fail_msg'), 'a') as f1le:
            f1le.write(data.read())
            f1le.write('\n')
            data.close()
