from infi.clickhouse_orm import models, fields, engines

class Balance(models.Model):
    log_date = fields.DateField()
    log_time = fields.DateTimeField()
    method = fields.StringField()
    param = fields.StringField()
    reqid = fields.StringField()
    host = fields.StringField()
    proc_id = fields.Int64Field()
    data_type = fields.StringField()
    source = fields.StringField()
    engine = engines.MergeTree('log_date', ('log_date', 'log_time'), 8192)

    @classmethod
    def table_name(cls):
        return 'balance_v3_mergetree'

class Bsexport_data(models.Model):
    log_date = fields.DateField()
    log_time = fields.DateTimeField()
    par_id = fields.Int64Field()
    data_type = fields.StringField()
    cid = fields.Int64Field()
    pid = fields.Int64Field()
    bid = fields.Int64Field()
    source = fields.StringField()
    metadata = fields.StringField()
    data = fields.StringField()
    engine = engines.MergeTree('log_date', ('log_date', 'log_time'), 8192)

    @classmethod
    def table_name(cls):
        return 'bsexport_data_v3_mergetree'

class Bsexport_prices(models.Model):
    log_date = fields.DateField()
    log_time = fields.DateTimeField()
    par_id = fields.Int64Field()
    data_type = fields.StringField()
    cid = fields.Int64Field()
    pid = fields.Int64Field()
    source = fields.StringField()
    metadata = fields.StringField()
    date = fields.StringField()
    engine = engines.MergeTree('log_date', ('cid', 'log_time'), 8192)

    @classmethod
    def table_name(cls):
        return 'bsexport_prices_v3_mergetree'

class Bsimport_active_orders(models.Model):
    log_date = fields.DateField()
    log_time = fields.DateTimeField()
    order_id = fields.Int64Field()
    stop = fields.UInt8Field()
    shows = fields.Int64Field()
    clicks = fields.Int64Field()
    micro_cost = fields.Int64Field()
    micro_cost_cur = fields.Int64Field()
    update_time = fields.DateTimeField()
    engine = engines.MergeTree('log_date', ('order_id', 'log_time'), 8192)

    @classmethod
    def table_name(cls):
        return 'bsimport_active_orders_v3_mergetree'

class Dbshards_ids(models.Model):
    log_date = fields.DateField()
    log_time = fields.DateTimeField()
    source = fields.StringField()
    host = fields.StringField()
    reqid = fields.Int64Field()
    key = fields.StringField()
    ids = fields.ArrayField(fields.Int64Field())
    insert_data = fields.StringField()
    engine = engines.MergeTree('log_date', ('log_date', 'log_time'), 8192)

    @classmethod
    def table_name(cls):
        return 'dbshards_ids_v3_mergetree'

class Mediaplan(models.Model):
    log_date = fields.DateField()
    log_time = fields.DateTimeField()
    source = fields.StringField()
    host = fields.StringField()
    reqid = fields.Int64Field()
    cid = fields.Int64Field()
    action = fields.StringField()
    values = fields.StringField()
    engine = engines.MergeTree('log_date', ('log_date', 'log_time'), 8192)

    @classmethod
    def table_name(cls):
        return 'mediaplan_v3_mergetree'

class Messages(models.Model):
    log_date = fields.DateField()
    log_time = fields.DateTimeField()
    host = fields.StringField()
    service = fields.StringField()
    method = fields.StringField()
    trace_id = fields.UInt64Field()
    parent_id = fields.UInt64Field()
    span_id = fields.UInt64Field()
    prefix = fields.StringField()
    log_level = fields.StringField()
    class_name = fields.StringField()
    message = fields.StringField()
    engine = engines.MergeTree('log_date', ('log_date', 'service', 'method', 'log_time'), 8192)

    @classmethod
    def table_name(cls):
        return 'messages_v3_mergetree'

class Moderate(models.Model):
    log_date = fields.DateField()
    log_time = fields.DateTimeField()
    cid = fields.Int64Field()
    pid = fields.Int64Field()
    bid = fields.Int64Field()
    data_type = fields.StringField()
    uuid = fields.StringField()
    metadata = fields.StringField()
    source = fields.StringField()
    data = fields.StringField()
    engine = engines.MergeTree('log_date', ('log_date', 'log_time'), 8192)

    @classmethod
    def table_name(cls):
        return 'moderate_v3_mergetree'

class Ppclog_api(models.Model):
    log_date = fields.DateField()
    log_time = fields.DateTimeField()
    cid = fields.ArrayField(fields.Int64Field())
    bid = fields.ArrayField(fields.Int64Field())
    ip = fields.StringField()
    cmd = fields.StringField()
    runtime = fields.Float32Field()
    param = fields.StringField()
    http_status = fields.Int64Field()
    cluid = fields.ArrayField(fields.Int64Field())
    reqid = fields.Int64Field()
    uid = fields.Int64Field()
    host = fields.StringField()
    proc_id = fields.Int64Field()
    fulltime = fields.Float32Field()
    error_detail = fields.StringField()
    units = fields.Int64Field()
    units_stats = fields.StringField()
    api_version = fields.UInt8Field()
    interface = fields.StringField()
    application_id = fields.StringField()
    response = fields.StringField()
    response_ids = fields.ArrayField(fields.Int64Field())
    source = fields.StringField()
    units_spending_user_client_id = fields.Int64Field()
    error_object_count = fields.Int64Field()
    warning_object_count = fields.Int64Field()
    engine = engines.MergeTree('log_date', ('log_date', 'log_time'), 8192)

    @classmethod
    def table_name(cls):
        return 'ppclog_api_v3_mergetree'

class Ppclog_cmd(models.Model):
    log_date = fields.DateField()
    log_time = fields.DateTimeField()
    cid = fields.ArrayField(fields.Int64Field())
    bid = fields.ArrayField(fields.Int64Field())
    pid = fields.ArrayField(fields.Int64Field())
    ip = fields.StringField()
    cmd = fields.StringField()
    runtime = fields.Float32Field()
    param = fields.StringField()
    http_status = fields.Int16Field()
    cluid = fields.ArrayField(fields.Int64Field())
    reqid = fields.Int64Field()
    uid = fields.Int64Field()
    host = fields.StringField()
    proc_id = fields.Int64Field()
    fulltime = fields.Float32Field()
    cpu_user_time = fields.Float32Field()
    yandexuid = fields.StringField()
    role = fields.StringField()
    source = fields.StringField()
    engine = engines.MergeTree('log_date', ('log_date', 'log_time'), 8192)

    @classmethod
    def table_name(cls):
        return 'ppclog_cmd_v3_mergetree'

class Ppclog_price(models.Model):
    log_date = fields.DateField()
    log_time = fields.DateTimeField()
    service = fields.StringField()
    method = fields.StringField()
    reqid = fields.Int64Field()
    uid = fields.Int64Field()
    host = fields.StringField()
    ip = fields.StringField()
    cid = fields.Int64Field()
    pid = fields.Int64Field()
    bid = fields.Int64Field()
    id = fields.Int64Field()
    type = fields.StringField()
    currency = fields.StringField()
    price = fields.Float32Field()
    price_ctx = fields.Float32Field()
    engine = engines.MergeTree('log_date', ('log_date', 'log_time'), 8192)

    @classmethod
    def table_name(cls):
        return 'ppclog_price_v3_mergetree'

