from infi.clickhouse_orm.database import Database
from infi.clickhouse_orm import fields
from ppchouse.structure import *
from pytz import timezone
from threading import Timer

import copy
import csv
import datetime
import logging
import os
import subprocess
import StringIO
import shlex
import sys
import pytz

reload(sys)
sys.setdefaultencoding('utf8')
csv.field_size_limit(sys.maxsize)

TABLES = {  'balance': Balance(), 'balance_v2': Balance(), 'balance_v3': Balance(),
            'bsexport_data': Bsexport_data(), 'bsexport_data_v2': Bsexport_data(),
            'bsexport_prices': Bsexport_prices(), 'bsexport_prices_v2': Bsexport_prices(),
            'bsimport_active_orders': Bsimport_active_orders(), 'bsimport_active_orders_v2': Bsimport_active_orders(),
            'dbshards_ids': Dbshards_ids(), 'dbshards_ids_v2': Dbshards_ids(),
            'mediaplan': Mediaplan(), 'mediaplan_v2': Mediaplan(),
            'messages': Messages(), 'messages_v2': Messages(),
            'moderate': Moderate(), 'moderate_v2': Moderate(),
            'ppclog_api': Ppclog_api(), 'ppclog_api_v2': Ppclog_api(),
            'ppclog_cmd': Ppclog_cmd(), 'ppclog_cmd_v2': Ppclog_cmd(), 'ppclog_cmd_v3': Ppclog_cmd(),
            'ppclog_price': Ppclog_price(), 'ppclog_price_v2': Ppclog_price()
}
LOG_LEVEL = "CRITICAL"

class Support:
    def __init__(self, db='default', table=None, log_level=LOG_LEVEL):
        if not table: raise
        self.name_table = table
        struct = copy.deepcopy(TABLES)
        self.struct_table = struct.get(table, None)
        if not self.struct_table: raise
        self.db_name = db
        self.logger = self.getLogSetup(log_level)

    def dbh(self, hostname, ro=True):
        url = "http://{0}:8123".format(hostname)
        if ro:
            dbh = Database(self.db_name, url, username='readonly', readonly=ro)
        else:
            dbh = Database(self.db_name, url, username='default', readonly=ro)
        return dbh

    def getPrimaryKeysList(self):
        return self.struct_table.engine.key_cols

    def getPrimaryKeysStr(self):
        return ', '.join(self.struct_table.engine.key_cols)

    def getDateKey(self):
        return self.struct_table.engine.date_col

    def getAllKeys(self):
        result = list(self.struct_table.engine.key_cols)
        result.append(self.struct_table.engine.date_col)
        return list(set(result))

    def getColumnList(self):
        return self.struct_table.to_dict().keys()

    def getColumnStr(self, exclude=[]):
        l1st = [ i for i in self.struct_table.to_dict().keys() if i not in exclude ]
        return ', '.join(l1st)

    def getTimeZone(self):
        with open('/etc/timezone', 'r') as f1le:
            tz = pytz.timezone(f1le.read().strip())
        tzinfo = datetime.datetime.now(tz).tzinfo
        return tzinfo
 
    def getLogSetup(self, log_level):
        logger = logging.getLogger('steam logs to console')
        logger.setLevel(level=getattr(logging, log_level))
        # create console handler and set level to LEVEL
        ch = logging.StreamHandler()
        ch.setLevel(level=getattr(logging, log_level))
        # create formatter
        formatter = logging.Formatter('%(asctime)s - %(name)s - %(levelname)s - %(message)s')
        # add formatter to ch
        ch.setFormatter(formatter)
        # add ch to logger
        logger.addHandler(ch)
        return logger

    def repairData(self, data):
        output = StringIO.StringIO()
        for line in data.split('\n'):
            if not line: continue
            try:
                cmd = "echo '{0}' | iconv -t latin1".format(line)
                proc = subprocess.Popen( cmd, 
                                         stdout=subprocess.PIPE,
                                         stderr=subprocess.PIPE,
                                         shell=True
                                         #encoding='utf8',
                                       )
                kill_proc = lambda p: p.kill()
                try:
                    timer = Timer(60, kill_proc, [proc])
                    timer.start()
                    stdout, stderr = proc.communicate()
                    if not stdout or stderr: 
                        raise ValueError('data convert error: {0} error {1}'.format(cmd, stderr))
                finally:
                    timer.cancel()
                #line = stdout
                output.write(stdout.encode('utf8'))
            #except ValueError as err:
                #self.logger.debug(err)
                #pass
            except Exception as err:
                #self.logger.error(err)
                #self.logger.error(line)
                output.write(line.encode('utf8'))
            #try:
            #    output.write(line.encode('utf8'))
            #except Exception as err:
            #    self.logger.debug(err)
            #    self.logger.debug(line)
            #output.write(line)
            output.write("\n")
        output.seek(0)
        return output

    def readGroupKeys(self, hostname, more=None, less=None):
        more = "log_date >= toDate('{0}')".format(more) if more else ""
        less = "log_date < toDate('{0}')".format(less) if less else ""
        if more and less:
             suffix = "WHERE {0} AND {1}".format(more, less)
        elif more or less:
             suffix = "WHERE {0}{1}".format(more, less)
        else:
             suffix =""

        req = '''SELECT log_date           AS date,
                        toHour(log_time)   AS hour, 
                        toMinute(log_time) AS minute,
                        count() AS cnt 
                 FROM {0}.{1}_mergetree {2}
                 GROUP BY date, hour, minute
                 ORDER BY date, hour, minute
              '''.format(self.db_name, self.name_table, suffix)
        self.logger.debug(req)
        dbh_read = self.dbh(hostname, ro=True)
        return [i for i in dbh_read.select(req)]

    def saveRowsByDate(self, hostname, total, user='readonly'):
        sum_dates = len(total)
        sum_count = sum([ int(i.cnt) for i in total ])
        self.logger.debug("total dates: {0}, total counts: {1}".format(sum_dates, sum_count))

        for times in total:
            req = '''
                     SELECT {0} FROM {1}.{2}_mergetree
                     WHERE log_date=toDate('{3}') 
                     AND toHour(log_time) = {4} 
                     AND toMinute(log_time) = {5}
                     FORMAT CSVWithNames
                  '''.format(
                             self.getColumnStr(), self.db_name,
                             self.name_table, times.date,
                             times.hour, times.minute,
                             times.date.strftime("%Y-%m-%d"))
            self.logger.debug(req)
            dbh_read = self.dbh(hostname, ro=False)
            text = dbh_read.raw(req)
            yield self.repairData(text)
            #yield f1le

    def loadChData(self, hostname, data):
        dbh_write = self.dbh(hostname, False)
        tz = self.getTimeZone()
        fieldnames = self.getColumnList()
        reader = csv.DictReader(data)
        result = list()
        try:
            for row in reader:
                struct = copy.deepcopy(TABLES)
                r = struct.get(self.name_table)
                [ setattr(r, i, row[i]) for i in row ]
                r.log_time = r.log_time.replace(tzinfo=tz)
                result.append(r)
        except Exception as err:
            print 'OK2', row
            self.logger.error(err)
            self.logger.error(row)
            #raise
        finally:
            dbh_write.insert(result)
        data.close()
