#!/usr/bin/perl

use strict;
use warnings;

use utf8;
use open qw/:std :encoding(UTF-8)/;

use List::MoreUtils qw/uniq/;

my ($table, $partition) = @ARGV;
die "missing or incorrect partition" unless $partition && $partition =~ /^[0-9]{6}$/;
die "missing table name" unless $table;
my $my_host = `hostname -f`;
my @hosts = `clickhouse-client -q "SELECT host_name from system.clusters where cluster = 'logs' and is_local"`;
#@hosts = grep {!/ppchouse03f/} @hosts;
chomp for ($my_host, @hosts);
my @other_hosts = grep { $_ ne $my_host } @hosts;
opendir D, "/opt/clickhouse/data/default/$table/detached" or die $!;
my @parts;
while (readdir D) {
    push @parts, $_ if /^\Q$partition\E/;
}
for my $part (@parts) {
    print STDERR "Attaching part $part\n";
    my $status = system('clickhouse-client', '-q', "ALTER TABLE $table ATTACH PART '$part'");
    die "exited with " . ($status >> 8) if $status;
    print STDERR "Waiting for part $part to replicate\n";
    my $done = 0;
    while (!$done) {
        my @cnts = map {scalar `clickhouse-client --host $_ -q "select sum(rows) from system.parts where active and table='$table' and partition='$partition'"`} @hosts;
        if (uniq(@cnts) == 1) {
            $done = 1;
        } else {
            sleep(60);
        }
    }
}
print STDERR "DONE\n";
